/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import com.mojang.logging.LogUtils;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class AttachmentHolder
implements IAttachmentHolder {
    public static final String ATTACHMENTS_NBT_KEY = "neoforge:attachments";
    private static final boolean IN_DEV = !FMLLoader.isProduction();
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    Map<AttachmentType<?>, Object> attachments = null;

    private void validateAttachmentType(AttachmentType<?> type) {
        Objects.requireNonNull(type);
        if (!IN_DEV) {
            return;
        }
        if (!NeoForgeRegistries.ATTACHMENT_TYPES.containsValue(type)) {
            throw new IllegalArgumentException("Data attachment type with default value " + String.valueOf(type.defaultValueSupplier.apply(this.getExposedHolder())) + " must be registered!");
        }
    }

    final Map<AttachmentType<?>, Object> getAttachmentMap() {
        if (this.attachments == null) {
            this.attachments = new IdentityHashMap(4);
        }
        return this.attachments;
    }

    IAttachmentHolder getExposedHolder() {
        return this;
    }

    @Override
    public final boolean hasAttachments() {
        return this.attachments != null && !this.attachments.isEmpty();
    }

    @Override
    public final boolean hasData(AttachmentType<?> type) {
        this.validateAttachmentType(type);
        return this.attachments != null && this.attachments.containsKey(type);
    }

    @Override
    public final <T> T getData(AttachmentType<T> type) {
        this.validateAttachmentType(type);
        Object ret = this.getAttachmentMap().get(type);
        if (ret == null) {
            ret = type.defaultValueSupplier.apply(this.getExposedHolder());
            this.attachments.put(type, ret);
        }
        return (T)ret;
    }

    @Override
    public <T> Optional<T> getExistingData(AttachmentType<T> type) {
        this.validateAttachmentType(type);
        if (this.attachments == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.attachments.get(type));
    }

    @Override
    @MustBeInvokedByOverriders
    @Nullable
    public <T> T setData(AttachmentType<T> type, T data) {
        this.validateAttachmentType(type);
        Objects.requireNonNull(data);
        return (T)this.getAttachmentMap().put(type, data);
    }

    @Override
    @MustBeInvokedByOverriders
    @Nullable
    public <T> T removeData(AttachmentType<T> type) {
        this.validateAttachmentType(type);
        if (this.attachments == null) {
            return null;
        }
        return (T)this.attachments.remove(type);
    }

    @Nullable
    public final CompoundTag serializeAttachments() {
        if (this.attachments == null) {
            return null;
        }
        CompoundTag tag = null;
        for (Map.Entry<AttachmentType<?>, Object> entry : this.attachments.entrySet()) {
            Object serialized;
            AttachmentType<?> type = entry.getKey();
            if (type.serializer == null || (serialized = type.serializer.write(entry.getValue())) == null) continue;
            if (tag == null) {
                tag = new CompoundTag();
            }
            tag.put(NeoForgeRegistries.ATTACHMENT_TYPES.getKey(type).toString(), serialized);
        }
        return tag;
    }

    protected final void deserializeAttachments(CompoundTag tag) {
        for (String key : tag.getAllKeys()) {
            ResourceLocation keyLocation = ResourceLocation.tryParse((String)key);
            if (keyLocation == null) {
                LOGGER.error("Encountered invalid data attachment key {}. Skipping.", (Object)key);
                continue;
            }
            AttachmentType type = (AttachmentType)NeoForgeRegistries.ATTACHMENT_TYPES.get(keyLocation);
            if (type == null || type.serializer == null) {
                LOGGER.error("Encountered unknown or non-serializable data attachment {}. Skipping.", (Object)key);
                continue;
            }
            try {
                this.getAttachmentMap().put(type, type.serializer.read(this.getExposedHolder(), tag.get(key)));
            }
            catch (Exception exception) {
                LOGGER.error("Failed to deserialize data attachment {}. Skipping.", (Object)key, (Object)exception);
            }
        }
    }

    public static <H extends AttachmentHolder> boolean areAttachmentsCompatible(H first, H second) {
        AttachmentType type;
        Map<Object, Object> firstAttachments = first.attachments != null ? first.attachments : Map.of();
        Map<Object, Object> secondAttachments = second.attachments != null ? second.attachments : Map.of();
        for (Map.Entry<Object, Object> entry : firstAttachments.entrySet()) {
            type = (AttachmentType)entry.getKey();
            if (type.serializer == null) continue;
            Object otherData = secondAttachments.get(type);
            if (otherData == null) {
                otherData = type.defaultValueSupplier.apply(second.getExposedHolder());
            }
            if (type.comparator.areCompatible(entry.getValue(), otherData)) continue;
            return false;
        }
        for (Map.Entry<Object, Object> entry : secondAttachments.entrySet()) {
            Object data;
            type = (AttachmentType)entry.getKey();
            if (type.serializer == null || (data = firstAttachments.get(type)) != null) continue;
            data = type.defaultValueSupplier.apply(first.getExposedHolder());
            if (type.comparator.areCompatible(entry.getValue(), data)) continue;
            return false;
        }
        return true;
    }

    public static class AsField
    extends AttachmentHolder {
        private final IAttachmentHolder exposedHolder;

        public AsField(IAttachmentHolder exposedHolder) {
            this.exposedHolder = exposedHolder;
        }

        @Override
        IAttachmentHolder getExposedHolder() {
            return this.exposedHolder;
        }

        public void deserializeInternal(CompoundTag tag) {
            this.deserializeAttachments(tag);
        }
    }
}

