/*
 * Copyright (c) NeoForged and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package net.neoforged.neoforge.client.event;

import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.NeoForge;

/**
 * Fired when the client is {@linkplain Minecraft#pause pause} and no longer performing ticks.
 *
 * <p>This event is not {@linkplain ICancellableEvent cancellable}, and does not {@linkplain HasResult have a result}.</p>
 *
 * <p>This event is fired on the {@linkplain NeoForge#EVENT_BUS main Forge event bus},
 * only on the {@linkplain LogicalSide#CLIENT logical client}.</p>
 */
public class ClientPauseUpdatedEvent extends Event {
    private final boolean paused;

    public ClientPauseUpdatedEvent(boolean isPaused) {
        this.paused = isPaused;
    }

    /**
     * {@return game is paused}
     */
    public boolean isPaused() {
        return paused;
    }
}
