/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class BlockTagIngredient
extends Ingredient {
    public static final Codec<BlockTagIngredient> CODEC = RecordCodecBuilder.create(i -> i.group((App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("tag").forGetter(BlockTagIngredient::getTag)).apply((Applicative)i, BlockTagIngredient::new));
    protected final TagKey<Block> tag;
    @Nullable
    protected ItemStack[] itemStacks;

    public BlockTagIngredient(TagKey<Block> tag) {
        super(Stream.of(new BlockTagValue(tag)), NeoForgeMod.BLOCK_TAG_INGREDIENT);
        this.tag = tag;
    }

    public ItemStack[] getItems() {
        ArrayList list = new ArrayList();
        for (Ingredient.Value value : this.values) {
            list.addAll(value.getItems());
        }
        this.itemStacks = (ItemStack[])list.toArray(ItemStack[]::new);
        return this.itemStacks;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        this.getItems();
        for (ItemStack itemStack : this.itemStacks) {
            if (!itemStack.is(stack.getItem())) continue;
            return true;
        }
        return false;
    }

    public TagKey<Block> getTag() {
        return this.tag;
    }

    public IngredientType<?> getType() {
        return NeoForgeMod.BLOCK_TAG_INGREDIENT.get();
    }

    public record BlockTagValue(TagKey<Block> tag) implements Ingredient.Value
    {
        public Collection<ItemStack> getItems() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (Holder holder : BuiltInRegistries.BLOCK.getTagOrEmpty(this.tag)) {
                ItemStack stack = new ItemStack((ItemLike)holder.value());
                if (stack.isEmpty()) continue;
                list.add(stack);
            }
            if (list.isEmpty()) {
                list.add(new ItemStack((ItemLike)Blocks.BARRIER).setHoverName((Component)Component.literal((String)("Empty Tag: " + String.valueOf(this.tag.location())))));
            }
            return list;
        }
    }
}

