/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.data;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.event.level.ChunkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Mod.EventBusSubscriber(modid="neoforge", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public abstract class ModelDataManager {
    ModelDataManager() {
    }

    @Nullable
    public abstract ModelData getAt(BlockPos var1);

    public abstract ModelData getAtOrEmpty(BlockPos var1);

    @ApiStatus.Internal
    public abstract Snapshot snapshotSectionRegion(int var1, int var2, int var3, int var4, int var5, int var6);

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor level = event.getChunk().getWorldForge();
        if (level == null) {
            return;
        }
        ModelDataManager modelDataManager = level.getModelDataManager();
        if (modelDataManager instanceof Active) {
            Active activeManager = (Active)modelDataManager;
            ChunkPos chunk = event.getChunk().getPos();
            int maxSection = level.getMaxSection();
            for (int y = level.getMinSection(); y < maxSection; ++y) {
                long section = SectionPos.asLong((int)chunk.x, (int)y, (int)chunk.z);
                activeManager.needModelDataRefresh.remove(section);
                activeManager.modelDataCache.remove(section);
            }
        }
    }

    @ApiStatus.Internal
    public static final class Active
    extends ModelDataManager {
        private final Thread owningThread = Thread.currentThread();
        private final Level level;
        private final Long2ObjectMap<Set<BlockPos>> needModelDataRefresh = new Long2ObjectOpenHashMap();
        private final Long2ObjectMap<Long2ObjectMap<ModelData>> modelDataCache = new Long2ObjectOpenHashMap();

        public Active(Level level) {
            this.level = level;
        }

        public void requestRefresh(BlockEntity blockEntity) {
            if (this.isOtherThread()) {
                throw new UnsupportedOperationException("Cannot request ModelData refresh outside the owning thread: " + String.valueOf(this.owningThread));
            }
            Preconditions.checkNotNull((Object)blockEntity, (Object)"BlockEntity must not be null");
            Preconditions.checkState((blockEntity.getLevel() == this.level ? 1 : 0) != 0, (Object)"BlockEntity does not belong to the level owning this manager");
            ((Set)this.needModelDataRefresh.computeIfAbsent(SectionPos.asLong((BlockPos)blockEntity.getBlockPos()), $ -> new HashSet())).add(blockEntity.getBlockPos());
        }

        @Override
        @Nullable
        public ModelData getAt(BlockPos pos) {
            Preconditions.checkArgument((boolean)this.level.isClientSide, (Object)"Cannot request model data for server level");
            long sectionPos = SectionPos.asLong((BlockPos)pos);
            this.refreshAt(sectionPos);
            return (ModelData)((Long2ObjectMap)this.modelDataCache.getOrDefault(sectionPos, (Object)Long2ObjectMaps.emptyMap())).get(pos.asLong());
        }

        @Override
        public ModelData getAtOrEmpty(BlockPos pos) {
            return Objects.requireNonNullElse(this.getAt(pos), ModelData.EMPTY);
        }

        @Override
        public Snapshot snapshotSectionRegion(int sectionMinX, int sectionMinY, int sectionMinZ, int sectionMaxX, int sectionMaxY, int sectionMaxZ) {
            if (this.isOtherThread()) {
                throw new UnsupportedOperationException("Cannot snapshot active manager outside the owning thread: " + String.valueOf(this.owningThread));
            }
            return new Snapshot(this, sectionMinX, sectionMinY, sectionMinZ, sectionMaxX, sectionMaxY, sectionMaxZ);
        }

        private void refreshAt(long section) {
            if (this.isOtherThread()) {
                return;
            }
            Set needUpdate = (Set)this.needModelDataRefresh.remove(section);
            if (needUpdate != null) {
                Long2ObjectMap data = (Long2ObjectMap)this.modelDataCache.computeIfAbsent(section, $ -> new Long2ObjectOpenHashMap());
                for (BlockPos pos : needUpdate) {
                    BlockEntity toUpdate = this.level.getBlockEntity(pos);
                    ModelData newData = ModelData.EMPTY;
                    if (toUpdate != null && !toUpdate.isRemoved()) {
                        newData = toUpdate.getModelData();
                    }
                    if (newData != ModelData.EMPTY) {
                        data.put(pos.asLong(), (Object)newData);
                        continue;
                    }
                    data.remove(pos.asLong());
                }
                if (data.isEmpty()) {
                    this.modelDataCache.remove(section);
                }
            }
        }

        private boolean isOtherThread() {
            return Thread.currentThread() != this.owningThread;
        }
    }

    @ApiStatus.Internal
    public static final class Snapshot
    extends ModelDataManager {
        public static final Snapshot EMPTY = new Snapshot();
        private final Long2ObjectMap<ModelData> modelDataCache;
        private final long sectionMin;
        private final long sectionMax;

        Snapshot(Active srcManager, int sectionMinX, int sectionMinY, int sectionMinZ, int sectionMaxX, int sectionMaxY, int sectionMaxZ) {
            this.sectionMin = SectionPos.asLong((int)sectionMinX, (int)sectionMinY, (int)sectionMinZ);
            this.sectionMax = SectionPos.asLong((int)sectionMaxX, (int)sectionMaxY, (int)sectionMaxZ);
            Long2ObjectOpenHashMap cache = new Long2ObjectOpenHashMap();
            for (int x = sectionMinX; x <= sectionMaxX; ++x) {
                for (int y = sectionMinY; y <= sectionMaxY; ++y) {
                    for (int z = sectionMinZ; z <= sectionMaxZ; ++z) {
                        long sectionPos = SectionPos.asLong((int)x, (int)y, (int)z);
                        srcManager.refreshAt(sectionPos);
                        cache.putAll((Map)srcManager.modelDataCache.getOrDefault(sectionPos, (Object)Long2ObjectMaps.emptyMap()));
                    }
                }
            }
            this.modelDataCache = cache.isEmpty() ? Long2ObjectMaps.emptyMap() : cache;
        }

        private Snapshot() {
            this.sectionMin = this.sectionMax = SectionPos.asLong((int)0, (int)0, (int)0);
            this.modelDataCache = Long2ObjectMaps.emptyMap();
        }

        @Override
        @Nullable
        public ModelData getAt(BlockPos pos) {
            return (ModelData)this.modelDataCache.get(pos.asLong());
        }

        @Override
        public ModelData getAtOrEmpty(BlockPos pos) {
            return (ModelData)this.modelDataCache.getOrDefault(pos.asLong(), (Object)ModelData.EMPTY);
        }

        @Override
        public Snapshot snapshotSectionRegion(int sectionMinX, int sectionMinY, int sectionMinZ, int sectionMaxX, int sectionMaxY, int sectionMaxZ) {
            Preconditions.checkArgument((this.sectionMin == SectionPos.asLong((int)sectionMinX, (int)sectionMinY, (int)sectionMinZ) && this.sectionMax == SectionPos.asLong((int)sectionMaxX, (int)sectionMaxY, (int)sectionMaxZ) ? 1 : 0) != 0, (Object)"Cannot request snapshot for a different range from this snapshot");
            return this;
        }
    }
}

