/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentCopyHandler;

public final class AttachmentUtils {
    private AttachmentUtils() {
    }

    public static <H extends AttachmentHolder> void copyAttachments(H from, H to, Predicate<AttachmentType<?>> filter) {
        if (from.attachments == null) {
            return;
        }
        for (Map.Entry<AttachmentType<?>, Object> entry : from.attachments.entrySet()) {
            Object copy;
            AttachmentType<?> type = entry.getKey();
            if (type.serializer == null) continue;
            IAttachmentCopyHandler<Object> copyHandler = type.copyHandler;
            if (!filter.test(type) || (copy = copyHandler.copy(to.getExposedHolder(), entry.getValue())) == null) continue;
            to.getAttachmentMap().put(type, copy);
        }
    }

    public static void copyStackAttachments(ItemStack from, ItemStack to) {
        AttachmentUtils.copyAttachments(from, to, type -> true);
    }

    public static void copyChunkAttachmentsOnPromotion(AttachmentHolder.AsField from, AttachmentHolder.AsField to) {
        AttachmentUtils.copyAttachments(from, to, type -> true);
    }
}

