/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.registration;

import java.util.Optional;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.ConfigurationPayloadContext;
import net.neoforged.neoforge.network.handling.IConfigurationPayloadHandler;
import net.neoforged.neoforge.network.registration.IDirectionAwarePayloadHandlerBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ConfigurationPayloadHandler<T extends CustomPacketPayload>
implements IConfigurationPayloadHandler<T> {
    @Nullable
    private final IConfigurationPayloadHandler<T> clientSide;
    @Nullable
    private final IConfigurationPayloadHandler<T> serverSide;

    private ConfigurationPayloadHandler(@Nullable IConfigurationPayloadHandler<T> clientSide, @Nullable IConfigurationPayloadHandler<T> serverSide) {
        this.clientSide = clientSide;
        this.serverSide = serverSide;
    }

    @Override
    public void handle(T payload, ConfigurationPayloadContext context) {
        if (context.flow().isClientbound()) {
            if (this.clientSide != null) {
                this.clientSide.handle(payload, context);
            }
        } else if (context.flow().isServerbound() && this.serverSide != null) {
            this.serverSide.handle(payload, context);
        }
    }

    Optional<PacketFlow> flow() {
        if (this.clientSide == null && this.serverSide == null) {
            return Optional.empty();
        }
        if (this.clientSide == null) {
            return Optional.of(PacketFlow.SERVERBOUND);
        }
        if (this.serverSide == null) {
            return Optional.of(PacketFlow.CLIENTBOUND);
        }
        return Optional.empty();
    }

    static class Builder<T extends CustomPacketPayload>
    implements IDirectionAwarePayloadHandlerBuilder<T, IConfigurationPayloadHandler<T>> {
        @Nullable
        private IConfigurationPayloadHandler<T> clientSide;
        @Nullable
        private IConfigurationPayloadHandler<T> serverSide;

        Builder() {
        }

        public Builder<T> client(IConfigurationPayloadHandler<T> clientSide) {
            this.clientSide = clientSide;
            return this;
        }

        public Builder<T> server(IConfigurationPayloadHandler<T> serverSide) {
            this.serverSide = serverSide;
            return this;
        }

        ConfigurationPayloadHandler<T> create() {
            return new ConfigurationPayloadHandler<T>(this.clientSide, this.serverSide);
        }
    }
}

