/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PacketDistributor<T> {
    public static final PacketDistributor<ServerPlayer> PLAYER = new PacketDistributor<ServerPlayer>(PacketDistributor::playerConsumer, PacketFlow.CLIENTBOUND);
    public static final PacketDistributor<ResourceKey<Level>> DIMENSION = new PacketDistributor<ResourceKey>(PacketDistributor::playerListDimConsumer, PacketFlow.CLIENTBOUND);
    public static final PacketDistributor<TargetPoint> NEAR = new PacketDistributor<TargetPoint>(PacketDistributor::playerListPointConsumer, PacketFlow.CLIENTBOUND);
    public static final PacketDistributor<Void> ALL = new PacketDistributor(PacketDistributor::playerListAll, PacketFlow.CLIENTBOUND);
    public static final PacketDistributor<Void> SERVER = new PacketDistributor(PacketDistributor::clientToServer, PacketFlow.SERVERBOUND);
    public static final PacketDistributor<Entity> TRACKING_ENTITY = new PacketDistributor<Entity>(PacketDistributor::trackingEntity, PacketFlow.CLIENTBOUND);
    public static final PacketDistributor<Entity> TRACKING_ENTITY_AND_SELF = new PacketDistributor<Entity>(PacketDistributor::trackingEntityAndSelf, PacketFlow.CLIENTBOUND);
    public static final PacketDistributor<LevelChunk> TRACKING_CHUNK = new PacketDistributor<LevelChunk>(PacketDistributor::trackingChunk, PacketFlow.CLIENTBOUND);
    private final BiFunction<PacketDistributor<T>, T, Consumer<Packet<?>>> functor;
    private final PacketFlow flow;

    public PacketDistributor(BiFunction<PacketDistributor<T>, T, Consumer<Packet<?>>> functor, PacketFlow flow) {
        this.functor = functor;
        this.flow = flow;
    }

    public PacketDistributor(Function<PacketDistributor<T>, Consumer<Packet<?>>> functor, PacketFlow flow) {
        this((PacketDistributor<T> d, T t) -> (Consumer)functor.apply((PacketDistributor)d), flow);
    }

    public PacketTarget with(T input) {
        return new PacketTarget(this.functor.apply(this, (PacketDistributor)input), this);
    }

    public PacketTarget noArg() {
        return new PacketTarget(this.functor.apply(this, null), this);
    }

    private Consumer<Packet<?>> playerConsumer(ServerPlayer entityPlayerMP) {
        return p -> entityPlayerMP.connection.send(p);
    }

    private Consumer<Packet<?>> playerListDimConsumer(ResourceKey<Level> dimensionType) {
        return p -> this.getServer().getPlayerList().broadcastAll(p, dimensionType);
    }

    private Consumer<Packet<?>> playerListAll() {
        return p -> this.getServer().getPlayerList().broadcastAll(p);
    }

    private Consumer<Packet<?>> clientToServer() {
        return p -> Objects.requireNonNull(Minecraft.getInstance().getConnection()).send(p);
    }

    private Consumer<Packet<?>> playerListPointConsumer(TargetPoint targetPoint) {
        return p -> {
            TargetPoint tp = targetPoint;
            this.getServer().getPlayerList().broadcast((Player)tp.excluded, tp.x, tp.y, tp.z, tp.r2, tp.dim, p);
        };
    }

    private Consumer<Packet<?>> trackingEntity(Entity entity) {
        return p -> ((ServerChunkCache)entity.getCommandSenderWorld().getChunkSource()).broadcast(entity, p);
    }

    private Consumer<Packet<?>> trackingEntityAndSelf(Entity entity) {
        return p -> ((ServerChunkCache)entity.getCommandSenderWorld().getChunkSource()).broadcastAndSend(entity, p);
    }

    private Consumer<Packet<?>> trackingChunk(LevelChunk chunkPos) {
        return p -> ((ServerChunkCache)chunkPos.getLevel().getChunkSource()).chunkMap.getPlayers(chunkPos.getPos(), false).forEach(e -> e.connection.send(p));
    }

    private MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static class PacketTarget {
        private final Consumer<Packet<?>> packetConsumer;
        private final PacketDistributor<?> distributor;

        PacketTarget(Consumer<Packet<?>> packetConsumer, PacketDistributor<?> distributor) {
            this.packetConsumer = packetConsumer;
            this.distributor = distributor;
        }

        public void send(Packet<?> packet) {
            this.packetConsumer.accept(packet);
        }

        public void send(CustomPacketPayload ... payloads) {
            block4: {
                block2: {
                    block3: {
                        if (!this.flow().isClientbound()) break block2;
                        if (payloads.length <= 1) break block3;
                        ArrayList<ClientboundCustomPayloadPacket> packets = new ArrayList<ClientboundCustomPayloadPacket>();
                        for (CustomPacketPayload payload : payloads) {
                            packets.add(new ClientboundCustomPayloadPacket(payload));
                        }
                        this.send((Packet<?>)new ClientboundBundlePacket(packets));
                        break block4;
                    }
                    if (payloads.length != 1) break block4;
                    this.send((Packet<?>)new ClientboundCustomPayloadPacket(payloads[0]));
                    break block4;
                }
                for (CustomPacketPayload payload : payloads) {
                    this.send((Packet<?>)new ServerboundCustomPayloadPacket(payload));
                }
            }
        }

        public PacketFlow flow() {
            return this.distributor.flow;
        }
    }

    public static final class TargetPoint {
        private final ServerPlayer excluded;
        private final double x;
        private final double y;
        private final double z;
        private final double r2;
        private final ResourceKey<Level> dim;

        public TargetPoint(ServerPlayer excluded, double x, double y, double z, double r2, ResourceKey<Level> dim) {
            this.excluded = excluded;
            this.x = x;
            this.y = y;
            this.z = z;
            this.r2 = r2;
            this.dim = dim;
        }

        public TargetPoint(double x, double y, double z, double r2, ResourceKey<Level> dim) {
            this.excluded = null;
            this.x = x;
            this.y = y;
            this.z = z;
            this.r2 = r2;
            this.dim = dim;
        }

        public static Supplier<TargetPoint> p(double x, double y, double z, double r2, ResourceKey<Level> dim) {
            TargetPoint tp = new TargetPoint(x, y, z, r2, dim);
            return () -> tp;
        }
    }
}

