/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.EntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.SequentialEntry;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.CompositeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.ToolActions;
import net.neoforged.neoforge.common.loot.CanToolPerformAction;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeLootTableProvider
extends LootTableProvider {
    private final List<Function<LootItemCondition, LootItemCondition.Builder>> conditionReplacers = new ArrayList<Function<LootItemCondition, LootItemCondition.Builder>>();

    public NeoForgeLootTableProvider(PackOutput packOutput) {
        super(packOutput, Set.of(), VanillaLootTableProvider.create((PackOutput)packOutput).getTables());
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationcontext) {
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        this.replaceLootItemCondition(condition -> {
            MatchTool matchTool;
            if (condition instanceof MatchTool && this.checkMatchTool(matchTool = (MatchTool)condition, Items.SHEARS)) {
                return CanToolPerformAction.canToolPerformAction(ToolActions.SHEARS_DIG);
            }
            return null;
        });
        return super.getTables().stream().map(entry -> new LootTableProvider.SubProviderEntry(() -> this.replaceAndFilterChangesOnly((LootTableSubProvider)entry.provider().get()), entry.paramSet())).collect(Collectors.toList());
    }

    private LootTableSubProvider replaceAndFilterChangesOnly(LootTableSubProvider subProvider) {
        return newConsumer -> subProvider.generate((resourceLocation, builder) -> {
            LootTable.Builder newBuilder = this.findAndReplaceInLootTableBuilder((LootTable.Builder)builder);
            if (newBuilder != null) {
                newConsumer.accept(resourceLocation, newBuilder);
            }
        });
    }

    private void replaceLootItemCondition(Function<LootItemCondition, LootItemCondition.Builder> replacer) {
        this.conditionReplacers.add(replacer);
    }

    @Nullable
    private LootTable.Builder findAndReplaceInLootTableBuilder(LootTable.Builder builder) {
        LootTable lootTable = builder.build();
        Optional randomSequence = (Optional)this.getPrivateValue(LootTable.class, lootTable, "randomSequence");
        List lootPools = (List)this.getPrivateValue(LootTable.class, lootTable, "pools");
        List lootItemFunctions = (List)this.getPrivateValue(LootTable.class, lootTable, "functions");
        boolean found = false;
        LootTable.Builder newBuilder = new LootTable.Builder();
        newBuilder.setParamSet(lootTable.getParamSet());
        randomSequence.ifPresent(arg_0 -> ((LootTable.Builder)newBuilder).setRandomSequence(arg_0));
        for (LootItemFunction lootItemFunction : lootItemFunctions) {
            newBuilder.apply(() -> lootItemFunction);
        }
        for (LootPool lootPool : lootPools) {
            found |= this.findAndReplaceInLootPool(lootPool, newBuilder);
        }
        return found ? newBuilder : null;
    }

    private boolean findAndReplaceInLootPool(LootPool lootPool, LootTable.Builder newBuilder) {
        List lootEntries = (List)this.getPrivateValue(LootPool.class, lootPool, "entries");
        List lootConditions = (List)this.getPrivateValue(LootPool.class, lootPool, "conditions");
        List lootFunctions = (List)this.getPrivateValue(LootPool.class, lootPool, "functions");
        LootPool.Builder poolBuilder = new LootPool.Builder();
        poolBuilder.setRolls(lootPool.getRolls());
        poolBuilder.setBonusRolls(lootPool.getBonusRolls());
        poolBuilder.name(lootPool.getName());
        boolean found = false;
        for (LootPoolEntryContainer lootEntry : lootEntries) {
            found |= this.findAndReplaceInLootEntry(lootEntry, arg_0 -> ((LootPool.Builder)poolBuilder).add(arg_0));
        }
        for (LootItemCondition lootCondition : lootConditions) {
            if (lootCondition instanceof InvertedLootItemCondition) {
                CompositeLootItemCondition compositeLootItemCondition;
                InvertedLootItemCondition invertedLootItemCondition = (InvertedLootItemCondition)lootCondition;
                LootItemCondition invLootCondition = invertedLootItemCondition.term();
                Consumer<LootItemCondition.Builder> consumer = cond -> poolBuilder.when(InvertedLootItemCondition.invert((LootItemCondition.Builder)cond));
                if (invLootCondition instanceof CompositeLootItemCondition && this.findAndReplaceInComposite(compositeLootItemCondition = (CompositeLootItemCondition)invLootCondition, consumer)) {
                    found = true;
                    continue;
                }
                found |= this.replaceCondition(invLootCondition, consumer);
                continue;
            }
            found |= this.replaceCondition(lootCondition, arg_0 -> ((LootPool.Builder)poolBuilder).when(arg_0));
        }
        for (LootItemFunction lootFunction : lootFunctions) {
            poolBuilder.apply(() -> lootFunction);
        }
        newBuilder.withPool(poolBuilder);
        return found;
    }

    private boolean findAndReplaceInParentedLootEntry(CompositeEntryBase entry, Consumer<LootPoolEntryContainer.Builder<?>> newBuilder) {
        List lootEntries = (List)this.getPrivateValue(CompositeEntryBase.class, entry, "children");
        boolean found = false;
        for (LootPoolEntryContainer lootEntry : lootEntries) {
            found |= this.findAndReplaceInLootEntry(lootEntry, newBuilder);
        }
        return found;
    }

    private boolean findAndReplaceInLootEntry(LootPoolEntryContainer entry, Consumer<LootPoolEntryContainer.Builder<?>> newBuilder) {
        AlternativesEntry.Builder builder;
        List lootConditions = (List)this.getPrivateValue(LootPoolEntryContainer.class, entry, "conditions");
        boolean found = false;
        if (entry instanceof CompositeEntryBase) {
            Consumer<LootPoolEntryContainer.Builder<?>> consumer;
            CompositeEntryBase compositeEntryBase = (CompositeEntryBase)entry;
            if (compositeEntryBase instanceof AlternativesEntry) {
                builder = new AlternativesEntry.Builder(new LootPoolEntryContainer.Builder[0]);
                consumer = arg_0 -> ((LootPoolEntryContainer.Builder)builder).otherwise(arg_0);
            } else if (compositeEntryBase instanceof SequentialEntry) {
                builder = new SequentialEntry.Builder(new LootPoolEntryContainer.Builder[0]);
                consumer = arg_0 -> ((LootPoolEntryContainer.Builder)builder).then(arg_0);
            } else if (compositeEntryBase instanceof EntryGroup) {
                builder = new EntryGroup.Builder(new LootPoolEntryContainer.Builder[0]);
                consumer = arg_0 -> ((LootPoolEntryContainer.Builder)builder).append(arg_0);
            } else {
                throw new IllegalStateException("Unknown CompositeEntryBase type: " + compositeEntryBase.getClass().getName());
            }
            found |= this.findAndReplaceInParentedLootEntry(compositeEntryBase, consumer);
        } else if (entry instanceof LootPoolSingletonContainer) {
            LootPoolSingletonContainer singleton = (LootPoolSingletonContainer)entry;
            if (singleton instanceof DynamicLoot) {
                DynamicLoot dynamicLoot = (DynamicLoot)singleton;
                name = (ResourceLocation)this.getPrivateValue(DynamicLoot.class, dynamicLoot, "name");
                builder = DynamicLoot.dynamicEntry((ResourceLocation)name);
            } else if (singleton instanceof EmptyLootItem) {
                builder = EmptyLootItem.emptyItem();
            } else if (singleton instanceof LootItem) {
                LootItem lootItem = (LootItem)singleton;
                Holder item = (Holder)this.getPrivateValue(LootItem.class, lootItem, "item");
                builder = LootItem.lootTableItem((ItemLike)((ItemLike)item.value()));
            } else if (singleton instanceof TagEntry) {
                TagEntry tagEntry = (TagEntry)singleton;
                TagKey tag = (TagKey)this.getPrivateValue(TagEntry.class, tagEntry, "tag");
                boolean expand = (Boolean)this.getPrivateValue(TagEntry.class, tagEntry, "expand");
                builder = expand ? TagEntry.expandTag((TagKey)tag) : TagEntry.tagContents((TagKey)tag);
            } else if (singleton instanceof LootTableReference) {
                LootTableReference reference = (LootTableReference)singleton;
                name = (ResourceLocation)this.getPrivateValue(LootTableReference.class, reference, "name");
                builder = LootTableReference.lootTableReference((ResourceLocation)name);
            } else {
                throw new IllegalStateException("Unknown LootPoolSingletonContainer type: " + singleton.getClass().getName());
            }
            int weight = (Integer)this.getPrivateValue(LootPoolSingletonContainer.class, singleton, "weight");
            int quality = (Integer)this.getPrivateValue(LootPoolSingletonContainer.class, singleton, "quality");
            List functions = (List)this.getPrivateValue(LootPoolSingletonContainer.class, singleton, "functions");
            ((LootPoolSingletonContainer.Builder)builder).setWeight(weight);
            ((LootPoolSingletonContainer.Builder)builder).setQuality(quality);
            for (LootItemFunction function : functions) {
                ((LootPoolSingletonContainer.Builder)builder).apply(() -> function);
            }
        } else {
            throw new IllegalStateException("Unknown LootPoolEntryContainer type: " + entry.getClass().getName());
        }
        for (LootItemCondition lootCondition : lootConditions) {
            if (lootCondition instanceof CompositeLootItemCondition) {
                CompositeLootItemCondition composite = (CompositeLootItemCondition)lootCondition;
                if (this.findAndReplaceInComposite(composite, arg_0 -> ((LootPoolEntryContainer.Builder)builder).when(arg_0))) {
                    found = true;
                    continue;
                }
            }
            found |= this.replaceCondition(lootCondition, arg_0 -> ((LootPoolEntryContainer.Builder)builder).when(arg_0));
        }
        newBuilder.accept((LootPoolEntryContainer.Builder<?>)builder);
        return found;
    }

    private boolean findAndReplaceInComposite(CompositeLootItemCondition alternative, Consumer<LootItemCondition.Builder> poolBuilder) {
        List lootConditions = (List)this.getPrivateValue(CompositeLootItemCondition.class, alternative, "terms");
        AllOfCondition.Builder builder = alternative instanceof AllOfCondition ? new AllOfCondition.Builder(new LootItemCondition.Builder[0]) : (alternative instanceof AnyOfCondition ? new AnyOfCondition.Builder(new LootItemCondition.Builder[0]) : null);
        boolean found = false;
        for (LootItemCondition lootCondition : lootConditions) {
            found |= this.replaceCondition(lootCondition, arg_0 -> ((CompositeLootItemCondition.Builder)builder).addTerm(arg_0));
        }
        poolBuilder.accept((LootItemCondition.Builder)builder);
        return found;
    }

    private boolean checkMatchTool(MatchTool lootCondition, Item expected) {
        return lootCondition.predicate().flatMap(ItemPredicate::items).filter(holders -> holders.contains((Holder)expected.builtInRegistryHolder())).isPresent();
    }

    private boolean replaceCondition(LootItemCondition lootCondition, Consumer<LootItemCondition.Builder> poolBuilder) {
        for (Function<LootItemCondition, LootItemCondition.Builder> conditionReplacer : this.conditionReplacers) {
            LootItemCondition.Builder newCondition = conditionReplacer.apply(lootCondition);
            if (newCondition == null) continue;
            poolBuilder.accept(newCondition);
            return true;
        }
        poolBuilder.accept(() -> lootCondition);
        return false;
    }

    private <T, C> T getPrivateValue(Class<C> clazz, C inst, String name) {
        Object value = ObfuscationReflectionHelper.getPrivateValue(clazz, inst, (String)name);
        if (value == null) {
            throw new IllegalStateException(clazz.getName() + " is missing field " + name);
        }
        return (T)value;
    }
}

