/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.CraftingHelper;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.Nullable;

public class NBTIngredient
extends Ingredient {
    public static final Codec<NBTIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.singularOrPluralCodec(BuiltInRegistries.ITEM.byNameCodec(), "item").forGetter(NBTIngredient::getContainedItems), (App)ExtraCodecs.strictOptionalField(CraftingHelper.TAG_CODEC, (String)"tag").forGetter(NBTIngredient::getOptionalTag), (App)ExtraCodecs.strictOptionalField(CraftingHelper.TAG_CODEC, (String)"neoforge:attachments").forGetter(NBTIngredient::getAttachmentNbt), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(NBTIngredient::isStrict)).apply((Applicative)builder, NBTIngredient::new));
    public static final Codec<NBTIngredient> CODEC_NONEMPTY = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.singularOrPluralCodecNotEmpty(BuiltInRegistries.ITEM.byNameCodec(), "item").forGetter(NBTIngredient::getContainedItems), (App)ExtraCodecs.strictOptionalField(CraftingHelper.TAG_CODEC, (String)"tag").forGetter(NBTIngredient::getOptionalTag), (App)ExtraCodecs.strictOptionalField(CraftingHelper.TAG_CODEC, (String)"neoforge:attachments").forGetter(NBTIngredient::getAttachmentNbt), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(NBTIngredient::isStrict)).apply((Applicative)builder, NBTIngredient::new));
    private final boolean strict;

    @Deprecated(forRemoval=true, since="1.20.4")
    protected NBTIngredient(Set<Item> items, CompoundTag tag, boolean strict) {
        this(items, tag, null, strict);
    }

    private NBTIngredient(Set<Item> items, Optional<CompoundTag> tag, Optional<CompoundTag> attachmentTag, boolean strict) {
        this(items, (CompoundTag)tag.orElse(null), (CompoundTag)attachmentTag.orElse(null), strict);
    }

    protected NBTIngredient(Set<Item> items, @Nullable CompoundTag tag, @Nullable CompoundTag attachmentTag, boolean strict) {
        super(items.stream().map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item, 1, attachmentTag == null ? null : attachmentTag.copy());
            if (tag != null) {
                stack.setTag(tag.copy());
            }
            return new Ingredient.ItemValue(stack, strict ? ItemStack::matches : NBTIngredient::compareStacksWithNBT);
        }), NeoForgeMod.NBT_INGREDIENT_TYPE);
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0, (Object)"At least one item needs to be provided for a nbt matching ingredient");
        if (!strict) {
            Preconditions.checkArgument((tag != null || attachmentTag != null ? 1 : 0) != 0, (Object)"Either nbt or attachment nbt needs to be provided for a non-strict nbt matching ingredient");
        }
        this.strict = strict;
    }

    protected boolean areStacksEqual(ItemStack left, ItemStack right) {
        return this.strict ? ItemStack.matches((ItemStack)left, (ItemStack)right) : NBTIngredient.compareStacksWithNBT(left, right);
    }

    public boolean synchronizeWithContents() {
        return false;
    }

    private static boolean compareStacksWithNBT(ItemStack left, ItemStack right) {
        return left.is(right.getItem()) && NbtUtils.compareNbt((Tag)left.getTag(), (Tag)right.getTag(), (boolean)true) && NbtUtils.compareNbt((Tag)left.serializeAttachments(), (Tag)right.serializeAttachments(), (boolean)true);
    }

    public static NBTIngredient of(boolean strict, CompoundTag nbt, ItemLike ... items) {
        return NBTIngredient.of(strict, nbt, null, items);
    }

    public static NBTIngredient of(boolean strict, @Nullable CompoundTag nbt, @Nullable CompoundTag attachmentNbt, ItemLike ... items) {
        return new NBTIngredient(Arrays.stream(items).map(ItemLike::asItem).collect(Collectors.toSet()), nbt, attachmentNbt, strict);
    }

    public static NBTIngredient ofAttachment(boolean strict, CompoundTag attachmentNbt, ItemLike ... items) {
        return NBTIngredient.of(strict, null, attachmentNbt, items);
    }

    public static NBTIngredient of(boolean strict, ItemStack stack) {
        CompoundTag attachmentNbt = stack.serializeAttachments();
        CompoundTag nbt = attachmentNbt == null ? stack.getOrCreateTag() : stack.getTag();
        return new NBTIngredient(Set.of(stack.getItem()), nbt, attachmentNbt, strict);
    }

    public Set<Item> getContainedItems() {
        return Arrays.stream(this.getItems()).map(ItemStack::getItem).collect(Collectors.toSet());
    }

    public CompoundTag getTag() {
        return this.getOptionalTag().orElseGet(CompoundTag::new);
    }

    public Optional<CompoundTag> getOptionalTag() {
        return this.getFirstItem().map(ItemStack::getTag);
    }

    public Optional<CompoundTag> getAttachmentNbt() {
        return this.getFirstItem().map(AttachmentHolder::serializeAttachments);
    }

    private Optional<ItemStack> getFirstItem() {
        ItemStack[] items = this.getItems();
        return items.length == 0 ? Optional.empty() : Optional.of(items[0]);
    }

    public boolean isSimple() {
        return false;
    }

    public boolean isStrict() {
        return this.strict;
    }
}

