/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.brewing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeRegistry {
    private static List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public static boolean addRecipe(Ingredient input, Ingredient ingredient, ItemStack output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(IBrewingRecipe recipe) {
        return recipes.add(recipe);
    }

    public static ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (input.isEmpty() || input.getCount() != 1) {
            return ItemStack.EMPTY;
        }
        if (ingredient.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (IBrewingRecipe recipe : recipes) {
            ItemStack output = recipe.getOutput(input, ingredient);
            if (output.isEmpty()) continue;
            return output;
        }
        return ItemStack.EMPTY;
    }

    public static boolean hasOutput(ItemStack input, ItemStack ingredient) {
        return !BrewingRecipeRegistry.getOutput(input, ingredient).isEmpty();
    }

    public static boolean canBrew(NonNullList<ItemStack> inputs, ItemStack ingredient, int[] inputIndexes) {
        if (ingredient.isEmpty()) {
            return false;
        }
        for (int i : inputIndexes) {
            if (!BrewingRecipeRegistry.hasOutput((ItemStack)inputs.get(i), ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void brewPotions(NonNullList<ItemStack> inputs, ItemStack ingredient, int[] inputIndexes) {
        for (int i : inputIndexes) {
            ItemStack output = BrewingRecipeRegistry.getOutput((ItemStack)inputs.get(i), ingredient);
            if (output.isEmpty()) continue;
            inputs.set(i, (Object)output);
        }
    }

    public static boolean isValidIngredient(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInput(ItemStack stack) {
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<IBrewingRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }

    static {
        BrewingRecipeRegistry.addRecipe(new VanillaBrewingRecipe());
    }
}

