/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;

public interface IQuadTransformer {
    public static final int STRIDE = DefaultVertexFormat.BLOCK.getIntegerSize();
    public static final int POSITION = IQuadTransformer.findOffset(DefaultVertexFormat.ELEMENT_POSITION);
    public static final int COLOR = IQuadTransformer.findOffset(DefaultVertexFormat.ELEMENT_COLOR);
    public static final int UV0 = IQuadTransformer.findOffset(DefaultVertexFormat.ELEMENT_UV0);
    public static final int UV1 = IQuadTransformer.findOffset(DefaultVertexFormat.ELEMENT_UV1);
    public static final int UV2 = IQuadTransformer.findOffset(DefaultVertexFormat.ELEMENT_UV2);
    public static final int NORMAL = IQuadTransformer.findOffset(DefaultVertexFormat.ELEMENT_NORMAL);

    public void processInPlace(BakedQuad var1);

    default public void processInPlace(List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            this.processInPlace(quad);
        }
    }

    default public BakedQuad process(BakedQuad quad) {
        BakedQuad copy = IQuadTransformer.copy(quad);
        this.processInPlace(copy);
        return copy;
    }

    default public List<BakedQuad> process(List<BakedQuad> inputs) {
        return inputs.stream().map(IQuadTransformer::copy).peek(this::processInPlace).toList();
    }

    default public IQuadTransformer andThen(IQuadTransformer other) {
        return quad -> {
            this.processInPlace(quad);
            other.processInPlace(quad);
        };
    }

    private static BakedQuad copy(BakedQuad quad) {
        int[] vertices = quad.getVertices();
        return new BakedQuad(Arrays.copyOf(vertices, vertices.length), quad.getTintIndex(), quad.getDirection(), quad.getSprite(), quad.isShade(), quad.hasAmbientOcclusion());
    }

    private static int findOffset(VertexFormatElement element) {
        int index = DefaultVertexFormat.BLOCK.getElements().indexOf((Object)element);
        return index < 0 ? -1 : DefaultVertexFormat.BLOCK.getOffset(index) / 4;
    }
}

