/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.ui;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.actions.Action;
import net.minecraftforge.installer.actions.ActionCanceledException;
import net.minecraftforge.installer.actions.Actions;
import net.minecraftforge.installer.actions.FatInstallerAction;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.actions.TargetValidator;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.OptionalLibrary;
import net.minecraftforge.installer.ui.Images;
import net.minecraftforge.installer.ui.L10nManager;
import net.minecraftforge.installer.ui.ProgressFrame;
import net.minecraftforge.installer.ui.TranslationTarget;

public class InstallerPanel
extends JPanel {
    private static final Path INSTALLER_SETTINGS = new File(SimpleInstaller.getMCDir(), ".neoforge_installer.properties").toPath();
    public static final L10nManager TRANSLATIONS = new L10nManager("neoforged/installer", INSTALLER_SETTINGS);
    private File targetDir;
    private ButtonGroup choiceButtonGroup;
    private JTextField selectedDirText;
    private JLabel infoLabel;
    private JButton sponsorButton;
    private JDialog dialog;
    private JPanel sponsorPanel;
    private final AtomicReference<Actions> action = new AtomicReference<Actions>(Actions.CLIENT);
    private JPanel fileEntryPanel;
    private JPanel fatInstallerOptionsPanel;
    private JCheckBox fatIncludeMC;
    private JCheckBox fatIncludeMCLibs;
    private JCheckBox fatIncludeInstallerLibs;
    private JCheckBox fatOffline;
    private List<OptionalListEntry> optionals = new ArrayList<OptionalListEntry>();
    private Map<String, Function<ProgressCallback, Action>> actions = new HashMap<String, Function<ProgressCallback, Action>>();
    private Optional<JButton> proceedButton = Optional.empty();
    private final InstallV1 profile;
    private final File installer;

    public static byte[] hexToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public InstallerPanel(File targetDir, InstallV1 profile, File installer) {
        this.profile = profile;
        this.installer = installer;
        this.setLayout(new BoxLayout(this, 1));
        BufferedImage image = Images.getImage(profile.getLogo());
        JPanel logoSplash = new JPanel();
        logoSplash.setLayout(new BoxLayout(logoSplash, 1));
        ImageIcon icon = new ImageIcon(image);
        JLabel logoLabel = new JLabel(icon);
        logoLabel.setAlignmentX(0.5f);
        logoLabel.setAlignmentY(0.5f);
        logoLabel.setSize(image.getWidth(), image.getHeight());
        logoSplash.add(logoLabel);
        JLabel tag = new JLabel();
        TRANSLATIONS.translate(tag, TranslationTarget.LABEL_TEXT, profile.getWelcome(), new Object[0]);
        tag.setAlignmentX(0.5f);
        tag.setAlignmentY(0.5f);
        logoSplash.add(tag);
        Box version = Box.createHorizontalBox();
        version.add(TRANSLATIONS.label("installer.welcome.version", new Object[0]));
        tag = new JLabel(profile.getVersion());
        tag.setFont(tag.getFont().deriveFont(1));
        version.add(tag);
        version.setAlignmentX(0.5f);
        version.setAlignmentY(0.5f);
        logoSplash.add(version);
        if (DownloadUtils.OFFLINE_MODE) {
            JLabel offline = new JLabel();
            offline.setFont(offline.getFont().deriveFont(1));
            offline.setForeground(Color.RED);
            TRANSLATIONS.translate(offline, TranslationTarget.LABEL_TEXT, "installer.welcome.offline", new Object[0]);
            offline.setAlignmentX(0.5f);
            offline.setAlignmentY(0.5f);
            logoSplash.add(offline);
        }
        logoSplash.setAlignmentX(0.5f);
        logoSplash.setAlignmentY(0.0f);
        this.add(logoSplash);
        this.sponsorPanel = new JPanel();
        this.sponsorPanel.setLayout(new BoxLayout(this.sponsorPanel, 0));
        this.sponsorPanel.setAlignmentX(0.5f);
        this.sponsorPanel.setAlignmentY(0.5f);
        this.sponsorButton = new JButton();
        this.sponsorButton.setAlignmentX(0.5f);
        this.sponsorButton.setAlignmentY(0.5f);
        this.sponsorButton.setBorderPainted(false);
        this.sponsorButton.setOpaque(false);
        this.sponsorButton.addActionListener(e -> this.openURL(this.sponsorButton.getToolTipText()));
        this.sponsorPanel.add(this.sponsorButton);
        this.add(this.sponsorPanel);
        this.choiceButtonGroup = new ButtonGroup();
        JPanel choicePanel = new JPanel();
        choicePanel.setLayout(new BoxLayout(choicePanel, 3));
        boolean first = true;
        SelectButtonAction sba = new SelectButtonAction();
        for (Actions action : Actions.values()) {
            if (action == Actions.CLIENT && profile.hideClient() || action == Actions.SERVER && profile.hideServer() || action == Actions.FAT_INSTALLER && DownloadUtils.OFFLINE_MODE) continue;
            this.actions.put(action.name(), prog -> action.getAction(profile, (ProgressCallback)prog));
            JRadioButton radioButton = TRANSLATIONS.radioButton(sba, action.getButtonLabel(), new Object[0]);
            TRANSLATIONS.setTooltip(radioButton, action.getTooltip(), new Object[0]);
            radioButton.setActionCommand(action.name());
            radioButton.setSelected(first);
            radioButton.setAlignmentX(0.0f);
            radioButton.setAlignmentY(0.5f);
            radioButton.setSize(15, 15);
            radioButton.setIconTextGap(10);
            radioButton.setMargin(new Insets(3, 3, 3, 3));
            this.choiceButtonGroup.add(radioButton);
            choicePanel.add(radioButton);
            choicePanel.add(Box.createRigidArea(new Dimension(1, 1)));
            first = false;
            radioButton.addChangeListener(e -> {
                if (radioButton.isSelected()) {
                    this.action.set(action);
                }
            });
            if (action != Actions.FAT_INSTALLER) continue;
            radioButton.addChangeListener(e -> {
                if (radioButton.isSelected()) {
                    this.remove(this.fileEntryPanel);
                    this.add(this.fatInstallerOptionsPanel);
                } else {
                    this.add(this.fileEntryPanel);
                    this.remove(this.fatInstallerOptionsPanel);
                }
            });
        }
        choicePanel.setAlignmentX(0.5f);
        choicePanel.setAlignmentY(0.5f);
        this.add(choicePanel);
        JPanel entryPanel = new JPanel();
        entryPanel.setLayout(new BoxLayout(entryPanel, 0));
        this.targetDir = targetDir;
        this.selectedDirText = new JTextField();
        this.selectedDirText.setEditable(false);
        TRANSLATIONS.setTooltip(this.selectedDirText, "installer.welcome.target.tooltip", new Object[0]);
        this.selectedDirText.setColumns(30);
        entryPanel.add(this.selectedDirText);
        JButton dirSelect = new JButton();
        dirSelect.setAction(new FileSelectAction());
        dirSelect.setText("...");
        TRANSLATIONS.setTooltip(dirSelect, "installer.welcome.dirselect.tooltip", new Object[0]);
        entryPanel.add(dirSelect);
        entryPanel.setAlignmentX(0.0f);
        entryPanel.setAlignmentY(0.0f);
        this.infoLabel = new JLabel();
        this.infoLabel.setHorizontalTextPosition(2);
        this.infoLabel.setVerticalTextPosition(1);
        this.infoLabel.setAlignmentX(0.0f);
        this.infoLabel.setAlignmentY(0.0f);
        this.infoLabel.setForeground(Color.RED);
        this.infoLabel.setVisible(false);
        this.fileEntryPanel = new JPanel();
        this.fileEntryPanel.setLayout(new BoxLayout(this.fileEntryPanel, 1));
        this.fileEntryPanel.add(this.infoLabel);
        this.fileEntryPanel.add(Box.createVerticalGlue());
        this.fileEntryPanel.add(entryPanel);
        this.fileEntryPanel.setAlignmentX(0.5f);
        this.fileEntryPanel.setAlignmentY(0.0f);
        this.add(this.fileEntryPanel);
        this.fatInstallerOptionsPanel = new JPanel();
        this.fatInstallerOptionsPanel.setLayout(new BoxLayout(this.fatInstallerOptionsPanel, 1));
        this.fatInstallerOptionsPanel.setAlignmentX(0.5f);
        this.fatInstallerOptionsPanel.setAlignmentY(0.0f);
        this.fatIncludeMC = TRANSLATIONS.checkBox("installer.fat.includemc", new Object[0]);
        TRANSLATIONS.setTooltip(this.fatIncludeMC, "installer.fat.includemc.tooltip", new Object[0]);
        this.fatIncludeMCLibs = TRANSLATIONS.checkBox("installer.fat.includemclibs", new Object[0]);
        TRANSLATIONS.setTooltip(this.fatIncludeMCLibs, "installer.fat.includemclibs.tooltip", new Object[0]);
        this.fatIncludeInstallerLibs = TRANSLATIONS.checkBox("installer.fat.includeinstallerlibs", new Object[0]);
        TRANSLATIONS.setTooltip(this.fatIncludeInstallerLibs, "installer.fat.includeinstallerlibs.tooltip", new Object[0]);
        this.fatInstallerOptionsPanel.add(this.fatIncludeMC);
        this.fatInstallerOptionsPanel.add(this.fatIncludeMCLibs);
        this.fatInstallerOptionsPanel.add(this.fatIncludeInstallerLibs);
        List<JCheckBox> fatOptions = Arrays.asList(this.fatIncludeMC, this.fatIncludeMCLibs, this.fatIncludeInstallerLibs);
        this.fatOffline = TRANSLATIONS.checkBox("installer.fat.offline", new Object[0]);
        TRANSLATIONS.setTooltip(this.fatOffline, "installer.fat.offline.tooltip", new Object[0]);
        this.fatOffline.setMargin(new Insets(3, 0, 0, 0));
        this.fatOffline.addChangeListener(e -> {
            if (this.fatOffline.isSelected()) {
                fatOptions.forEach(box -> {
                    box.setSelected(true);
                    box.setEnabled(false);
                });
            } else {
                fatOptions.forEach(box -> box.setEnabled(true));
            }
        });
        this.fatInstallerOptionsPanel.add(this.fatOffline);
        this.updateFilePath();
    }

    private void updateFilePath() {
        try {
            this.targetDir = this.targetDir.getCanonicalFile();
            this.selectedDirText.setText(this.targetDir.getPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Action action = this.actions.get(this.choiceButtonGroup.getSelection().getActionCommand()).apply(null);
        TargetValidator.ValidationResult valid = action.getTargetValidator().validate(this.targetDir);
        if (this.profile.getMirror() != null && this.profile.getMirror().isAdvertised()) {
            this.sponsorButton.setText(action.getSponsorMessage());
            this.sponsorButton.setToolTipText(this.profile.getMirror().getHomepage());
            if (this.profile.getMirror().getImageAddress() != null) {
                this.sponsorButton.setIcon(this.profile.getMirror().getImage());
            } else {
                this.sponsorButton.setIcon(null);
            }
            this.sponsorPanel.setVisible(true);
        } else {
            this.sponsorPanel.setVisible(false);
        }
        if (valid.valid) {
            this.selectedDirText.setForeground(null);
            this.infoLabel.setVisible(false);
            this.fileEntryPanel.setBorder(null);
            this.proceedButton.ifPresent(button -> button.setEnabled(true));
        } else {
            this.selectedDirText.setForeground(Color.RED);
            this.fileEntryPanel.setBorder(new LineBorder(Color.RED));
            TRANSLATIONS.translate(this.infoLabel, TranslationTarget.html(TranslationTarget.LABEL_TEXT), valid.message.key, valid.message.arguments);
            this.infoLabel.setVisible(true);
            this.proceedButton.ifPresent(button -> button.setEnabled(!valid.critical));
        }
        if (this.dialog != null) {
            this.dialog.invalidate();
            this.dialog.pack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run(ProgressCallback monitor) {
        languageBox = new JComboBox<Object>();
        known = InstallerPanel.TRANSLATIONS.getKnownLocales();
        languageBox.setModel(new DefaultComboBoxModel<Object>(known.toArray()));
        current = InstallerPanel.TRANSLATIONS.getLocale();
        languageBox.setSelectedItem(known.stream().filter((Predicate<L10nManager.LocaleSelection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$run$9(java.util.Locale net.minecraftforge.installer.ui.L10nManager$LocaleSelection ), (Lnet/minecraftforge/installer/ui/L10nManager$LocaleSelection;)Z)((Locale)current)).findFirst().orElse(known.get(0)));
        languageBox.addActionListener((ActionListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/awt/event/ActionEvent;)V, lambda$run$10(javax.swing.JComboBox java.awt.event.ActionEvent ), (Ljava/awt/event/ActionEvent;)V)(languageBox));
        proceedButton = InstallerPanel.TRANSLATIONS.button("installer.button.proceed", new Object[0]);
        cancelButton = InstallerPanel.TRANSLATIONS.button("installer.button.cancel", new Object[0]);
        optionPane = new JOptionPane(this, -1, 2, null, new Object[]{proceedButton, cancelButton, languageBox});
        proceedButton.addActionListener((ActionListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/awt/event/ActionEvent;)V, lambda$run$11(javax.swing.JOptionPane java.awt.event.ActionEvent ), (Ljava/awt/event/ActionEvent;)V)((JOptionPane)optionPane));
        cancelButton.addActionListener((ActionListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/awt/event/ActionEvent;)V, lambda$run$12(javax.swing.JOptionPane java.awt.event.ActionEvent ), (Ljava/awt/event/ActionEvent;)V)((JOptionPane)optionPane));
        this.proceedButton = Optional.of(proceedButton);
        this.dialog = optionPane.createDialog("");
        InstallerPanel.TRANSLATIONS.translate(this.dialog, new TranslationTarget<JDialog>((BiConsumer<JDialog, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, setTitle(java.lang.String ), (Ljavax/swing/JDialog;Ljava/lang/String;)V)()), "installer.window.title", new Object[]{this.profile.getProfile()});
        this.dialog.setIconImages(Images.getWindowIcons());
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setVisible(true);
        result = (Integer)(optionPane.getValue() != null ? optionPane.getValue() : Integer.valueOf(-1));
        if (result == 0) {
            if (this.action.get() == Actions.FAT_INSTALLER) {
                if (this.fatIncludeMC.isSelected()) {
                    isOk = new JOptionPane(new JLabel(InstallerPanel.TRANSLATIONS.translate("installer.fat.includemc.warning", new Object[0])), -1, 2);
                    okDialog = isOk.createDialog("WARNING");
                    okDialog.setDefaultCloseOperation(2);
                    okDialog.setVisible(true);
                    if (isOk.getValue() == null || (Integer)isOk.getValue() == 2) {
                        System.exit(0);
                    }
                    FatInstallerAction.OPTIONS.add(FatInstallerAction.Options.MC_JAR);
                    okDialog.dispose();
                }
                if (this.fatIncludeMCLibs.isSelected()) {
                    FatInstallerAction.OPTIONS.add(FatInstallerAction.Options.MC_LIBS);
                }
                if (this.fatIncludeInstallerLibs.isSelected()) {
                    FatInstallerAction.OPTIONS.add(FatInstallerAction.Options.INSTALLER_LIBS);
                }
                this.targetDir = new File(this.installer.getParent(), this.installer.getName().replace(".jar", "-fat.jar"));
            }
            prog = new ProgressFrame(monitor, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, interrupt(), ()V)((Thread)Thread.currentThread()), "installer.frame.installing", new Object[]{this.profile.getProfile(), this.profile.getVersion()});
            SimpleInstaller.hookStdOut(prog);
            optPred = (Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$run$14(java.lang.String ), (Ljava/lang/String;)Z)((InstallerPanel)this);
            action = this.actions.get(this.choiceButtonGroup.getSelection().getActionCommand()).apply(prog);
            try {
                prog.setVisible(true);
                prog.toFront();
                if (!action.run(this.targetDir, optPred, this.installer)) ** GOTO lbl67
                prog.start("Finished!");
                prog.getGlobalProgress().percentageProgress(1.0);
                JOptionPane.showMessageDialog(null, InstallerPanel.TRANSLATIONS.translate(action.getSuccessMessage()), InstallerPanel.TRANSLATIONS.translate("installer.installation.complete", new Object[0]), 1);
            }
            catch (ActionCanceledException e) {
                JOptionPane.showMessageDialog(null, InstallerPanel.TRANSLATIONS.translate("installer.installation.cancelled", new Object[0]), this.dialog.getTitle(), 2);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "There was an exception running task: " + e.toString(), "Error", 0);
                e.printStackTrace();
            }
            finally {
                prog.dispose();
                SimpleInstaller.hookStdOut(monitor);
            }
        } else if (result == 2) {
            System.exit(0);
        }
lbl67:
        // 7 sources

        this.dialog.dispose();
    }

    private void openURL(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InstallerPanel.this.dialog.toFront();
                    InstallerPanel.this.dialog.requestFocus();
                }
            });
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "An error occurred launching the browser", "Error launching browser", 0);
        }
    }

    private /* synthetic */ boolean lambda$run$14(String input) {
        Optional<OptionalListEntry> ent = this.optionals.stream().filter(e -> e.lib.getArtifact().equals(input)).findFirst();
        return !ent.isPresent() || ent.get().isEnabled();
    }

    private static /* synthetic */ void lambda$run$12(JOptionPane optionPane, ActionEvent e) {
        optionPane.setValue(2);
    }

    private static /* synthetic */ void lambda$run$11(JOptionPane optionPane, ActionEvent e) {
        optionPane.setValue(0);
    }

    private static /* synthetic */ void lambda$run$10(JComboBox languageBox, ActionEvent e) {
        TRANSLATIONS.setLocale(((L10nManager.LocaleSelection)languageBox.getSelectedItem()).locale, true);
    }

    private static /* synthetic */ boolean lambda$run$9(Locale current, L10nManager.LocaleSelection locate) {
        return locate.locale.equals(current);
    }

    private static class OptionalListEntry {
        OptionalLibrary lib;
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private class SelectButtonAction
    extends AbstractAction {
        private SelectButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstallerPanel.this.updateFilePath();
        }
    }

    private class FileSelectAction
    extends AbstractAction {
        private FileSelectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser dirChooser = new JFileChooser();
            dirChooser.setFileSelectionMode(1);
            dirChooser.setFileHidingEnabled(false);
            dirChooser.setDialogTitle("Select installation directory");
            dirChooser.setApproveButtonText("Select");
            dirChooser.ensureFileIsVisible(InstallerPanel.this.targetDir);
            dirChooser.setSelectedFile(InstallerPanel.this.targetDir);
            int response = dirChooser.showOpenDialog(InstallerPanel.this);
            if (response == 0) {
                InstallerPanel.this.targetDir = dirChooser.getSelectedFile();
                InstallerPanel.this.updateFilePath();
            }
        }
    }
}

