/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.actions.ProgressCallback;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Nullable;

@CheckReturnValue
public class Downloader {
    private static final Logger LOGGER = LogManager.getLogManager().getLogger("Downloading");
    public static final LocalSource LOCAL = LocalSource.detect();
    private LocalSource localSource;
    private final ProgressCallback monitor;
    private final String url;
    private String sha1;
    private String localPath;

    public Downloader(LocalSource localSource, ProgressCallback monitor, String url) {
        this.localSource = localSource;
        this.monitor = monitor;
        this.url = url;
    }

    public Downloader sha(@Nullable String sha) {
        this.sha1 = sha;
        return this;
    }

    public Downloader localPath(@Nullable String localPath) {
        this.localPath = localPath;
        return this;
    }

    public Downloader additionalDirectory(File ... dirs) {
        for (File dir : dirs) {
            this.localSource = this.localSource.fallbackWith(LocalSource.fromDir(dir.toPath()));
        }
        return this;
    }

    public boolean download(File target) {
        block17: {
            block16: {
                if (target.exists() && this.sha1 != null) {
                    if (Objects.equals(this.sha1, DownloadUtils.getSha1(target))) {
                        this.monitor.message("File " + target + " exists. Checksum valid.");
                        return true;
                    }
                    this.monitor.message("File " + target + " exists. Invalid checksum, deleting file.");
                    target.delete();
                }
                Path nio = target.toPath();
                try {
                    if (nio.getParent() != null) {
                        Files.createDirectories(nio.getParent(), new FileAttribute[0]);
                    }
                }
                catch (IOException exception) {
                    LOGGER.log(Level.WARNING, exception, () -> "Failed to create parent of " + target);
                    return false;
                }
                if (this.localPath != null) {
                    try {
                        LocalFile alternative = this.localSource.getArtifact(this.localPath);
                        if (alternative == null) break block16;
                        Files.copy(alternative.stream, nio, StandardCopyOption.REPLACE_EXISTING);
                        if (this.sha1 != null) {
                            String actualSha = DownloadUtils.getSha1(target);
                            if (!Objects.equals(actualSha, this.sha1)) {
                                this.monitor.message("Invalid checksum. Downloaded locally from " + alternative.path);
                                this.monitor.message("\tExpected: " + this.sha1);
                                this.monitor.message("\tActual:   " + actualSha);
                                break block16;
                            }
                            this.monitor.message("Downloaded file locally from " + alternative.path + ", valid checksum.");
                            return true;
                        }
                        this.monitor.message("Downloaded file locally from " + alternative.path + ", no checksum provided, assuming valid.");
                        return true;
                    }
                    catch (IOException exception) {
                        LOGGER.log(Level.WARNING, exception, () -> "Failed to download from local download source");
                    }
                }
            }
            if (DownloadUtils.OFFLINE_MODE) {
                this.monitor.message("\tFound no cached library at " + target + ", expecting download from " + this.url + ", but running in offline mode.");
                return false;
            }
            this.monitor.message("Downloading library from " + this.url);
            try {
                URLConnection connection = DownloadUtils.getConnection(this.url);
                if (connection == null) break block17;
                Files.copy(this.monitor.wrapStepDownload(connection), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (this.sha1 != null) {
                    String sha1 = DownloadUtils.getSha1(target);
                    if (Objects.equals(sha1, this.sha1)) {
                        this.monitor.message("\tDownload completed: Checksum validated.");
                        return true;
                    }
                    this.monitor.message("\tDownload failed: Checksum invalid, deleting file:");
                    this.monitor.message("\t\tExpected: " + this.sha1);
                    this.monitor.message("\t\tActual:   " + sha1);
                    if (!target.delete()) {
                        this.monitor.stage("\tFailed to delete file, aborting.");
                        return false;
                    }
                    break block17;
                }
                this.monitor.message("\tDownload completed: No checksum, Assuming valid.");
                return true;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e, () -> "Failed to download from " + this.url);
            }
        }
        return false;
    }

    public InputStream openStream() throws IOException {
        LocalFile alternative;
        if (this.localPath != null && (alternative = this.localSource.getArtifact(this.localPath)) != null) {
            return alternative.stream;
        }
        if (DownloadUtils.OFFLINE_MODE) {
            this.monitor.message("\tLibrary not cached, expecting download from " + this.url + ", but running in offline mode.");
            throw new RuntimeException("Running in offline mode, cannot download from " + this.url + ", cached version not found");
        }
        return this.monitor.wrapStepDownload(DownloadUtils.getConnection(this.url));
    }

    public static interface LocalSource {
        @Nullable
        public LocalFile getArtifact(String var1) throws IOException;

        default public LocalSource fallbackWith(@Nullable LocalSource other) {
            if (other == null) {
                return this;
            }
            return p -> {
                LocalFile art = this.getArtifact(p);
                return art != null ? art : other.getArtifact(p);
            };
        }

        public static LocalSource walkFromClassesOut(Path out) {
            for (int i = 0; i < 3; ++i) {
                out = out.getParent();
            }
            Path base = out.resolve("src/main/resources/maven");
            return LocalSource.fromDir(base);
        }

        @Nullable
        public static LocalSource walkFromLibs(Path source) {
            if ((source = source.getParent()) == null || source.getFileName() == null || !source.getFileName().toString().equals("libs")) {
                return null;
            }
            if ((source = source.getParent()) == null || source.getFileName() == null || !source.getFileName().toString().equals("build")) {
                return null;
            }
            if ((source = source.getParent()) == null) {
                return null;
            }
            Path base = source.resolve("src/main/resources/maven");
            return Files.isDirectory(base, new LinkOption[0]) ? LocalSource.fromDir(base) : null;
        }

        public static LocalSource fromDir(Path base) {
            return p -> {
                Path children = base.resolve(p);
                try {
                    return new LocalFile(Files.newInputStream(children, new OpenOption[0]), children.toFile().getAbsolutePath());
                }
                catch (NoSuchFileException ex) {
                    return null;
                }
            };
        }

        public static LocalSource fromResource() {
            return p -> {
                InputStream is = DownloadUtils.class.getResourceAsStream("/maven/" + p);
                return is == null ? null : new LocalFile(is, "jar:/maven/" + p);
            };
        }

        public static LocalSource detect() {
            try {
                URL url = DownloadUtils.class.getProtectionDomain().getCodeSource().getLocation();
                if (url.getProtocol().equals("file") && Files.isDirectory(Paths.get(url.toURI()), new LinkOption[0])) {
                    return LocalSource.walkFromClassesOut(Paths.get(url.toURI()));
                }
                return LocalSource.fromResource().fallbackWith(LocalSource.walkFromLibs(Paths.get(url.toURI())));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class LocalFile {
        public final InputStream stream;
        public final String path;

        public LocalFile(InputStream stream, String path) {
            this.stream = stream;
            this.path = path;
        }
    }
}

