/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;

public abstract class BakedModelWrapper<T extends BakedModel>
implements BakedModel {
    protected final T originalModel;

    public BakedModelWrapper(T originalModel) {
        this.originalModel = originalModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.originalModel.getQuads(state, side, rand);
    }

    public boolean useAmbientOcclusion() {
        return this.originalModel.useAmbientOcclusion();
    }

    public boolean useAmbientOcclusion(BlockState state) {
        return this.originalModel.useAmbientOcclusion(state);
    }

    public boolean useAmbientOcclusion(BlockState state, RenderType renderType) {
        return this.originalModel.useAmbientOcclusion(state, renderType);
    }

    public TriState useAmbientOcclusion(BlockState state, ModelData data, RenderType renderType) {
        return this.originalModel.useAmbientOcclusion(state, data, renderType);
    }

    public boolean isGui3d() {
        return this.originalModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.originalModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.originalModel.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.originalModel.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.originalModel.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return this.originalModel.getOverrides();
    }

    public BakedModel applyTransform(ItemDisplayContext cameraTransformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.originalModel.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return this.originalModel.getParticleIcon(data);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        return this.originalModel.getQuads(state, side, rand, extraData, renderType);
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        return this.originalModel.getModelData(level, pos, state, modelData);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return this.originalModel.getRenderTypes(state, rand, data);
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return this.originalModel.getRenderTypes(itemStack, fabulous);
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        return this.originalModel.getRenderPasses(itemStack, fabulous);
    }
}

