/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeRecipeProvider
extends VanillaRecipeProvider {
    private final Map<Item, TagKey<Item>> replacements = new HashMap<Item, TagKey<Item>>();
    private final Set<ResourceLocation> excludes = new HashSet<ResourceLocation>();

    public NeoForgeRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    private void exclude(ItemLike item) {
        this.excludes.add(BuiltInRegistries.ITEM.getKey((Object)item.asItem()));
    }

    private void exclude(String name) {
        this.excludes.add(new ResourceLocation(name));
    }

    private void replace(ItemLike item, TagKey<Item> tag) {
        this.replacements.put(item.asItem(), tag);
    }

    protected void buildRecipes(final RecipeOutput recipeOutput) {
        this.replace((ItemLike)Items.STICK, Tags.Items.RODS_WOODEN);
        this.replace((ItemLike)Items.GOLD_INGOT, Tags.Items.INGOTS_GOLD);
        this.replace((ItemLike)Items.GOLD_NUGGET, Tags.Items.NUGGETS_GOLD);
        this.replace((ItemLike)Items.IRON_INGOT, Tags.Items.INGOTS_IRON);
        this.replace((ItemLike)Items.IRON_NUGGET, Tags.Items.NUGGETS_IRON);
        this.replace((ItemLike)Items.NETHERITE_INGOT, Tags.Items.INGOTS_NETHERITE);
        this.replace((ItemLike)Items.COPPER_INGOT, Tags.Items.INGOTS_COPPER);
        this.replace((ItemLike)Items.AMETHYST_SHARD, Tags.Items.GEMS_AMETHYST);
        this.replace((ItemLike)Items.DIAMOND, Tags.Items.GEMS_DIAMOND);
        this.replace((ItemLike)Items.EMERALD, Tags.Items.GEMS_EMERALD);
        this.replace((ItemLike)Items.CHEST, Tags.Items.CHESTS_WOODEN);
        this.replace((ItemLike)Blocks.COBBLESTONE, Tags.Items.COBBLESTONE_NORMAL);
        this.replace((ItemLike)Blocks.COBBLED_DEEPSLATE, Tags.Items.COBBLESTONE_DEEPSLATE);
        this.replace((ItemLike)Items.STRING, Tags.Items.STRING);
        this.exclude(NeoForgeRecipeProvider.getConversionRecipeName((ItemLike)Blocks.WHITE_WOOL, (ItemLike)Items.STRING));
        this.exclude((ItemLike)Blocks.GOLD_BLOCK);
        this.exclude((ItemLike)Items.GOLD_NUGGET);
        this.exclude((ItemLike)Blocks.IRON_BLOCK);
        this.exclude((ItemLike)Items.IRON_NUGGET);
        this.exclude((ItemLike)Blocks.DIAMOND_BLOCK);
        this.exclude((ItemLike)Blocks.EMERALD_BLOCK);
        this.exclude((ItemLike)Blocks.NETHERITE_BLOCK);
        this.exclude((ItemLike)Blocks.COPPER_BLOCK);
        this.exclude((ItemLike)Blocks.AMETHYST_BLOCK);
        this.exclude((ItemLike)Blocks.COBBLESTONE_STAIRS);
        this.exclude((ItemLike)Blocks.COBBLESTONE_SLAB);
        this.exclude((ItemLike)Blocks.COBBLESTONE_WALL);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_STAIRS);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_SLAB);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_WALL);
        super.buildRecipes(new RecipeOutput(){

            public void accept(ResourceLocation id, Recipe<?> recipe, @Nullable AdvancementHolder advancement, ICondition ... conditions) {
                Recipe<?> modified = NeoForgeRecipeProvider.this.enhance(id, recipe);
                if (modified != null) {
                    recipeOutput.accept(id, modified, null, conditions);
                }
            }

            public Advancement.Builder advancement() {
                return recipeOutput.advancement();
            }
        });
    }

    @Nullable
    private Recipe<?> enhance(ResourceLocation id, Recipe<?> vanilla) {
        if (vanilla instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)vanilla;
            return this.enhance(id, shapeless);
        }
        if (vanilla instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)vanilla;
            return this.enhance(id, shaped);
        }
        return null;
    }

    @Nullable
    private ShapelessRecipe enhance(ResourceLocation id, ShapelessRecipe vanilla) {
        NonNullList ingredients = vanilla.getIngredients();
        boolean modified = false;
        for (int x = 0; x < ingredients.size(); ++x) {
            Ingredient ing = this.enhance(id, (Ingredient)ingredients.get(x));
            if (ing == null) continue;
            ingredients.set(x, ing);
            modified = true;
        }
        return modified ? vanilla : null;
    }

    protected CompletableFuture<?> buildAdvancement(CachedOutput p_253674_, AdvancementHolder p_301116_) {
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    @Nullable
    private ShapedRecipe enhance(ResourceLocation id, ShapedRecipe vanilla) {
        ShapedRecipePattern pattern = (ShapedRecipePattern)ObfuscationReflectionHelper.getPrivateValue(ShapedRecipe.class, (Object)vanilla, (String)"pattern");
        if (pattern == null) {
            throw new IllegalStateException(ShapedRecipe.class.getName() + " has no field pattern");
        }
        ShapedRecipePattern.Data data = (ShapedRecipePattern.Data)pattern.data().orElseThrow(() -> new IllegalArgumentException("recipe " + id + " does not have pattern data"));
        Map ingredients = data.key();
        boolean modified = false;
        for (Character x : ingredients.keySet()) {
            Ingredient ing = this.enhance(id, (Ingredient)ingredients.get(x));
            if (ing == null) continue;
            ingredients.put(x, ing);
            modified = true;
        }
        return modified ? vanilla : null;
    }

    @Nullable
    private Ingredient enhance(ResourceLocation name, Ingredient vanilla) {
        Ingredient.Value[] vanillaItems;
        if (this.excludes.contains(name)) {
            return null;
        }
        boolean modified = false;
        ArrayList<Object> items = new ArrayList<Object>();
        for (Ingredient.Value entry : vanillaItems = vanilla.getValues()) {
            if (entry instanceof Ingredient.ItemValue) {
                ItemStack stack = entry.getItems().stream().findFirst().orElse(ItemStack.EMPTY);
                TagKey<Item> replacement = this.replacements.get(stack.getItem());
                if (replacement != null) {
                    items.add(new Ingredient.TagValue(replacement));
                    modified = true;
                    continue;
                }
                items.add(entry);
                continue;
            }
            items.add(entry);
        }
        return modified ? Ingredient.fromValues(items.stream()) : null;
    }
}

