/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMaps;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.BaseMappedRegistry;

public class RegistrySnapshot {
    private static final Comparator<ResourceLocation> SORTER = ResourceLocation::compareNamespaced;
    private final Int2ObjectSortedMap<ResourceLocation> ids = new Int2ObjectRBTreeMap();
    private final Int2ObjectSortedMap<ResourceLocation> idsView = Int2ObjectSortedMaps.unmodifiable(this.ids);
    private final Map<ResourceLocation, ResourceLocation> aliases = new TreeMap<ResourceLocation, ResourceLocation>(SORTER);
    private final Map<ResourceLocation, ResourceLocation> aliasesView = Collections.unmodifiableMap(this.aliases);
    @Nullable
    private final Registry<?> fullBackup;
    @Nullable
    private byte[] binary = null;

    private RegistrySnapshot() {
        this.fullBackup = null;
    }

    public <T> RegistrySnapshot(Registry<T> registry, boolean full) {
        registry.keySet().forEach(key -> this.ids.put(registry.getId(key), key));
        this.aliases.putAll(((BaseMappedRegistry)registry).aliases);
        if (full) {
            MappedRegistry backup = new MappedRegistry(registry.key(), registry.registryLifecycle());
            for (Map.Entry entry : registry.entrySet()) {
                ResourceKey key2 = (ResourceKey)entry.getKey();
                Object value = entry.getValue();
                backup.registerMapping(registry.getId(key2), key2, value, registry.lifecycle(value));
            }
            backup.freeze();
            this.fullBackup = backup;
        } else {
            this.fullBackup = null;
        }
    }

    public RegistrySnapshot(FriendlyByteBuf buf) {
        this();
        buf.readMap(size -> this.ids, FriendlyByteBuf::readVarInt, FriendlyByteBuf::readResourceLocation);
        buf.readMap(size -> this.aliases, FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readResourceLocation);
    }

    public synchronized void write(FriendlyByteBuf buf) {
        if (this.binary == null) {
            FriendlyByteBuf pkt = new FriendlyByteBuf(Unpooled.buffer());
            try {
                pkt.writeMap(this.ids, FriendlyByteBuf::writeVarInt, FriendlyByteBuf::writeResourceLocation);
                pkt.writeMap(this.aliases, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeResourceLocation);
                this.binary = new byte[pkt.readableBytes()];
                pkt.readBytes(this.binary);
            }
            finally {
                pkt.release();
            }
        }
        buf.writeBytes(this.binary);
    }

    public Int2ObjectSortedMap<ResourceLocation> getIds() {
        return this.idsView;
    }

    public Map<ResourceLocation, ResourceLocation> getAliases() {
        return this.aliasesView;
    }

    @Nullable
    public <T> Registry<T> getFullBackup() {
        return this.fullBackup;
    }
}

