/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;

public abstract class ChildBasedIngredient
extends Ingredient {
    protected final List<Ingredient> children;
    private final boolean isSimple;
    private final boolean synchronizeWithContents;
    @Nullable
    private ItemStack[] filteredMatchingStacks;

    protected ChildBasedIngredient(Stream<? extends Ingredient.Value> values, Supplier<? extends IngredientType<?>> type, List<Ingredient> children) {
        super(values, type);
        this.children = Collections.unmodifiableList(children);
        this.isSimple = children.stream().allMatch(Ingredient::isSimple);
        this.synchronizeWithContents = children.stream().anyMatch(Ingredient::synchronizeWithContents);
    }

    protected abstract Stream<ItemStack> generateMatchingStacks();

    protected abstract boolean testComplex(@Nullable ItemStack var1);

    public final ItemStack[] getItems() {
        if (this.synchronizeWithContents() && this.isSimple()) {
            return super.getItems();
        }
        if (this.filteredMatchingStacks == null) {
            this.filteredMatchingStacks = (ItemStack[])this.generateMatchingStacks().distinct().toArray(ItemStack[]::new);
        }
        return this.filteredMatchingStacks;
    }

    public final boolean test(@Nullable ItemStack stack) {
        return this.synchronizeWithContents() && this.isSimple() ? super.test(stack) : this.testComplex(stack);
    }

    public final boolean isSimple() {
        return this.isSimple;
    }

    public final boolean synchronizeWithContents() {
        return this.synchronizeWithContents;
    }

    public final List<Ingredient> getChildren() {
        return this.children;
    }
}

