/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.fluids.capability.wrappers;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidBlock;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidBlockWrapper
implements IFluidHandler {
    protected final IFluidBlock fluidBlock;
    protected final Level world;
    protected final BlockPos blockPos;

    public FluidBlockWrapper(IFluidBlock fluidBlock, Level world, BlockPos blockPos) {
        this.fluidBlock = fluidBlock;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    public FluidStack getFluidInTank(int tank) {
        return tank == 0 ? this.fluidBlock.drain(this.world, this.blockPos, IFluidHandler.FluidAction.SIMULATE) : FluidStack.EMPTY;
    }

    @Override
    public int getTankCapacity(int tank) {
        float filledPercentage;
        FluidStack stored = this.getFluidInTank(tank);
        if (!stored.isEmpty() && (filledPercentage = this.fluidBlock.getFilledPercentage(this.world, this.blockPos)) > 0.0f) {
            return (int)((float)stored.getAmount() / filledPercentage);
        }
        return 1000;
    }

    @Override
    public boolean isFluidValid(int tank, FluidStack stack) {
        return stack.is(this.fluidBlock.getFluid());
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.fluidBlock.place(this.world, this.blockPos, resource, action);
    }

    @Override
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack simulatedDrained;
        if (!resource.isEmpty() && this.fluidBlock.canDrain(this.world, this.blockPos) && resource.is(this.fluidBlock.getFluid()) && (simulatedDrained = this.fluidBlock.drain(this.world, this.blockPos, IFluidHandler.FluidAction.SIMULATE)).getAmount() <= resource.getAmount() && resource.isFluidEqual(simulatedDrained)) {
            if (action.execute()) {
                return this.fluidBlock.drain(this.world, this.blockPos, IFluidHandler.FluidAction.EXECUTE).copy();
            }
            return simulatedDrained.copy();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack simulatedDrained;
        if (maxDrain > 0 && this.fluidBlock.canDrain(this.world, this.blockPos) && (simulatedDrained = this.fluidBlock.drain(this.world, this.blockPos, IFluidHandler.FluidAction.SIMULATE)).getAmount() <= maxDrain) {
            if (action.execute()) {
                return this.fluidBlock.drain(this.world, this.blockPos, IFluidHandler.FluidAction.EXECUTE).copy();
            }
            return simulatedDrained.copy();
        }
        return FluidStack.EMPTY;
    }
}

