/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import com.mojang.serialization.Codec;
import net.minecraft.core.Registry;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.advancements.critereon.ICustomItemPredicate;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.StructureModifier;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.RegistryBuilder;
import net.neoforged.neoforge.registries.holdersets.HolderSetType;

public class NeoForgeRegistries {
    public static final Registry<EntityDataSerializer<?>> ENTITY_DATA_SERIALIZERS = new RegistryBuilder(Keys.ENTITY_DATA_SERIALIZERS).sync(true).create();
    public static final Registry<Codec<? extends IGlobalLootModifier>> GLOBAL_LOOT_MODIFIER_SERIALIZERS = new RegistryBuilder<Codec<? extends IGlobalLootModifier>>(Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS).create();
    public static final Registry<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = new RegistryBuilder<Codec<? extends BiomeModifier>>(Keys.BIOME_MODIFIER_SERIALIZERS).create();
    public static final Registry<Codec<? extends StructureModifier>> STRUCTURE_MODIFIER_SERIALIZERS = new RegistryBuilder<Codec<? extends StructureModifier>>(Keys.STRUCTURE_MODIFIER_SERIALIZERS).create();
    public static final Registry<FluidType> FLUID_TYPES = new RegistryBuilder<FluidType>(Keys.FLUID_TYPES).create();
    public static final Registry<HolderSetType> HOLDER_SET_TYPES = new RegistryBuilder<HolderSetType>(Keys.HOLDER_SET_TYPES).create();
    public static final Registry<ItemDisplayContext> DISPLAY_CONTEXTS = new RegistryBuilder<ItemDisplayContext>(Keys.DISPLAY_CONTEXTS).sync(true).maxId(256).defaultKey(new ResourceLocation("none")).create();
    public static final Registry<IngredientType<?>> INGREDIENT_TYPES = new RegistryBuilder(Keys.INGREDIENT_TYPES).create();
    public static final Registry<Codec<? extends ICondition>> CONDITION_SERIALIZERS = new RegistryBuilder<Codec<? extends ICondition>>(Keys.CONDITION_CODECS).create();
    public static final Registry<Codec<? extends ICustomItemPredicate>> ITEM_PREDICATE_SERIALIZERS = new RegistryBuilder<Codec<? extends ICustomItemPredicate>>(Keys.ITEM_PREDICATE_SERIALIZERS).create();
    public static final Registry<AttachmentType<?>> ATTACHMENT_TYPES = new RegistryBuilder(Keys.ATTACHMENT_TYPES).create();

    public static final class Keys {
        public static final ResourceKey<Registry<EntityDataSerializer<?>>> ENTITY_DATA_SERIALIZERS = Keys.key("entity_data_serializers");
        public static final ResourceKey<Registry<Codec<? extends IGlobalLootModifier>>> GLOBAL_LOOT_MODIFIER_SERIALIZERS = Keys.key("global_loot_modifier_serializers");
        public static final ResourceKey<Registry<Codec<? extends BiomeModifier>>> BIOME_MODIFIER_SERIALIZERS = Keys.key("biome_modifier_serializers");
        public static final ResourceKey<Registry<Codec<? extends StructureModifier>>> STRUCTURE_MODIFIER_SERIALIZERS = Keys.key("structure_modifier_serializers");
        public static final ResourceKey<Registry<FluidType>> FLUID_TYPES = Keys.key("fluid_type");
        public static final ResourceKey<Registry<HolderSetType>> HOLDER_SET_TYPES = Keys.key("holder_set_type");
        public static final ResourceKey<Registry<ItemDisplayContext>> DISPLAY_CONTEXTS = Keys.key("display_contexts");
        public static final ResourceKey<Registry<IngredientType<?>>> INGREDIENT_TYPES = Keys.key("ingredient_serializer");
        public static final ResourceKey<Registry<Codec<? extends ICondition>>> CONDITION_CODECS = Keys.key("condition_codecs");
        public static final ResourceKey<Registry<Codec<? extends ICustomItemPredicate>>> ITEM_PREDICATE_SERIALIZERS = Keys.key("item_predicates");
        public static final ResourceKey<Registry<AttachmentType<?>>> ATTACHMENT_TYPES = Keys.key("attachment_types");
        public static final ResourceKey<Registry<BiomeModifier>> BIOME_MODIFIERS = Keys.key("biome_modifier");
        public static final ResourceKey<Registry<StructureModifier>> STRUCTURE_MODIFIERS = Keys.key("structure_modifier");

        private static <T> ResourceKey<Registry<T>> key(String name) {
            return ResourceKey.createRegistryKey((ResourceLocation)new ResourceLocation("neoforge", name));
        }
    }
}

