/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface IBlockGetterExtension {
    @Nullable
    @ApiStatus.NonExtendable
    default public AuxiliaryLightManager getAuxLightManager(BlockPos pos) {
        return this.getAuxLightManager(new ChunkPos(pos));
    }

    @Nullable
    default public AuxiliaryLightManager getAuxLightManager(ChunkPos pos) {
        IBlockGetterExtension iBlockGetterExtension = this;
        if (iBlockGetterExtension instanceof LevelAccessor) {
            LevelAccessor level = (LevelAccessor)iBlockGetterExtension;
            LightChunk chunk = level.getChunkSource().getChunkForLighting(pos.x, pos.z);
            return chunk != null ? chunk.getAuxLightManager(pos) : null;
        }
        iBlockGetterExtension = this;
        if (iBlockGetterExtension instanceof ImposterProtoChunk) {
            ImposterProtoChunk chunk = (ImposterProtoChunk)iBlockGetterExtension;
            return chunk.getWrapped().getAuxLightManager(pos);
        }
        return null;
    }

    @Nullable
    default public ModelDataManager getModelDataManager() {
        return null;
    }
}

