/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.CraftingHelper;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public class NBTIngredient
extends Ingredient {
    public static final Codec<NBTIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.singularOrPluralCodec(BuiltInRegistries.ITEM.byNameCodec(), "item").forGetter(NBTIngredient::getContainedItems), (App)CraftingHelper.TAG_CODEC.fieldOf("tag").forGetter(NBTIngredient::getTag), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(NBTIngredient::isStrict)).apply((Applicative)builder, NBTIngredient::new));
    public static final Codec<NBTIngredient> CODEC_NONEMPTY = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.singularOrPluralCodecNotEmpty(BuiltInRegistries.ITEM.byNameCodec(), "item").forGetter(NBTIngredient::getContainedItems), (App)CraftingHelper.TAG_CODEC.fieldOf("tag").forGetter(NBTIngredient::getTag), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(NBTIngredient::isStrict)).apply((Applicative)builder, NBTIngredient::new));
    private final boolean strict;

    protected NBTIngredient(Set<Item> items, CompoundTag tag, boolean strict) {
        super(items.stream().map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item, 1);
            stack.setTag(tag.copy());
            return new Ingredient.ItemValue(stack, strict ? ItemStack::matches : NBTIngredient::compareStacksWithNBT);
        }), NeoForgeMod.NBT_INGREDIENT_TYPE);
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0, (Object)"At least one item needs to be provided for a nbt matching ingredient");
        this.strict = strict;
    }

    protected boolean areStacksEqual(ItemStack left, ItemStack right) {
        return this.strict ? ItemStack.matches((ItemStack)left, (ItemStack)right) : NBTIngredient.compareStacksWithNBT(left, right);
    }

    public boolean synchronizeWithContents() {
        return false;
    }

    private static boolean compareStacksWithNBT(ItemStack left, ItemStack right) {
        return left.getItem() == right.getItem() && NbtUtils.compareNbt((Tag)left.getTag(), (Tag)right.getTag(), (boolean)true);
    }

    public static NBTIngredient of(boolean strict, CompoundTag nbt, ItemLike ... items) {
        return new NBTIngredient(Arrays.stream(items).map(ItemLike::asItem).collect(Collectors.toSet()), nbt, strict);
    }

    public static NBTIngredient of(boolean strict, ItemStack stack) {
        return new NBTIngredient(Set.of(stack.getItem()), stack.getOrCreateTag(), strict);
    }

    public Set<Item> getContainedItems() {
        return Arrays.stream(this.getItems()).map(ItemStack::getItem).collect(Collectors.toSet());
    }

    public CompoundTag getTag() {
        ItemStack[] items = this.getItems();
        if (items.length == 0) {
            return new CompoundTag();
        }
        return items[0].getOrCreateTag();
    }

    public boolean isSimple() {
        return false;
    }

    public boolean isStrict() {
        return this.strict;
    }
}

