/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.ChildBasedIngredient;
import org.jetbrains.annotations.Nullable;

public class IntersectionIngredient
extends ChildBasedIngredient {
    public static final Codec<IntersectionIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.LIST_CODEC.fieldOf("children").forGetter(ChildBasedIngredient::getChildren)).apply((Applicative)builder, IntersectionIngredient::new));
    public static final Codec<IntersectionIngredient> CODEC_NONEMPTY = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("children").forGetter(ChildBasedIngredient::getChildren)).apply((Applicative)builder, IntersectionIngredient::new));

    protected IntersectionIngredient(List<Ingredient> children) {
        super(children.stream().flatMap(ingredient -> Arrays.stream(ingredient.getValues()).map(value -> {
            ArrayList<Ingredient> matchers = new ArrayList<Ingredient>(children);
            matchers.remove(ingredient);
            return new IntersectionValue((Ingredient.Value)value, (List<Ingredient>)matchers);
        })), NeoForgeMod.INTERSECTION_INGREDIENT_TYPE, children);
    }

    public static Ingredient of(Ingredient ... ingredients) {
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create an IntersectionIngredient with no children, use Ingredient.of() to create an empty ingredient");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        return new IntersectionIngredient(Arrays.asList(ingredients));
    }

    @Override
    protected Stream<ItemStack> generateMatchingStacks() {
        return this.children.stream().flatMap(child -> Arrays.stream(child.getItems())).filter(this::testComplex);
    }

    @Override
    protected boolean testComplex(@Nullable ItemStack stack) {
        return this.children.stream().allMatch(c -> c.test(stack));
    }

    public record IntersectionValue(Ingredient.Value inner, List<Ingredient> other) implements Ingredient.Value
    {
        public Collection<ItemStack> getItems() {
            return this.inner().getItems().stream().filter(stack -> this.other().stream().allMatch(ingredient -> ingredient.test(stack))).toList();
        }
    }
}

