/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiOverlayEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.gui.overlay.GuiOverlayManager;
import net.neoforged.neoforge.client.gui.overlay.IGuiOverlay;
import net.neoforged.neoforge.client.gui.overlay.NamedGuiOverlay;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedGui
extends Gui {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int WHITE = 0xFFFFFF;
    public static double rayTraceDistance = 20.0;
    public int leftHeight = 39;
    public int rightHeight = 39;
    private Font font = null;

    public ExtendedGui(Minecraft mc) {
        super(mc, mc.getItemRenderer());
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public void setupOverlayRenderState(boolean blend, boolean depthTest) {
        if (blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        } else {
            RenderSystem.disableBlend();
        }
        if (depthTest) {
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
        this.screenWidth = this.minecraft.getWindow().getGuiScaledWidth();
        this.screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        this.rightHeight = 39;
        this.leftHeight = 39;
        if (((RenderGuiEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderGuiEvent.Pre(this.minecraft.getWindow(), guiGraphics, partialTick))).isCanceled()) {
            return;
        }
        this.font = this.minecraft.font;
        this.random.setSeed((long)this.tickCount * 312871L);
        GuiOverlayManager.getOverlays().forEach(entry -> {
            try {
                IGuiOverlay overlay = entry.overlay();
                if (this.pre((NamedGuiOverlay)entry, guiGraphics)) {
                    return;
                }
                overlay.render(this, guiGraphics, partialTick, this.screenWidth, this.screenHeight);
                this.post((NamedGuiOverlay)entry, guiGraphics);
            }
            catch (Exception e) {
                LOGGER.error("Error rendering overlay '{}'", (Object)entry.id(), (Object)e);
            }
        });
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        NeoForge.EVENT_BUS.post((Event)new RenderGuiEvent.Post(this.minecraft.getWindow(), guiGraphics, partialTick));
    }

    public boolean shouldDrawSurvivalElements() {
        return this.minecraft.gameMode.canHurtPlayer() && this.minecraft.getCameraEntity() instanceof Player;
    }

    protected void renderSubtitles(GuiGraphics guiGraphics) {
        this.subtitleOverlay.render(guiGraphics);
    }

    protected void renderBossHealth(GuiGraphics guiGraphics) {
        RenderSystem.defaultBlendFunc();
        this.minecraft.getProfiler().push("bossHealth");
        this.bossOverlay.render(guiGraphics);
        this.minecraft.getProfiler().pop();
    }

    void renderSpyglassOverlay(GuiGraphics guiGraphics) {
        float deltaFrame = this.minecraft.getDeltaFrameTime();
        this.scopeScale = Mth.lerp((float)(0.5f * deltaFrame), (float)this.scopeScale, (float)1.125f);
        if (this.minecraft.options.getCameraType().isFirstPerson()) {
            if (this.minecraft.player.isScoping()) {
                this.renderSpyglassOverlay(guiGraphics, this.scopeScale);
            } else {
                this.scopeScale = 0.5f;
            }
        }
    }

    void renderHelmet(float partialTick, GuiGraphics guiGraphics) {
        ItemStack itemstack = this.minecraft.player.getInventory().getArmor(3);
        if (this.minecraft.options.getCameraType().isFirstPerson() && !itemstack.isEmpty() && !this.minecraft.player.isScoping()) {
            Item item = itemstack.getItem();
            if (item == Blocks.CARVED_PUMPKIN.asItem()) {
                this.renderTextureOverlay(guiGraphics, PUMPKIN_BLUR_LOCATION, 1.0f);
            } else {
                IClientItemExtensions.of(item).renderHelmetOverlay(itemstack, (Player)this.minecraft.player, this.screenWidth, this.screenHeight, partialTick);
            }
        }
    }

    void renderFrostbite(GuiGraphics guiGraphics) {
        if (this.minecraft.player.getTicksFrozen() > 0) {
            this.renderTextureOverlay(guiGraphics, POWDER_SNOW_OUTLINE_LOCATION, this.minecraft.player.getPercentFrozen());
        }
    }

    protected void renderArmor(GuiGraphics guiGraphics, int width, int height) {
        this.minecraft.getProfiler().push("armor");
        RenderSystem.enableBlend();
        int left = width / 2 - 91;
        int top = height - this.leftHeight;
        int level = this.minecraft.player.getArmorValue();
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                guiGraphics.blitSprite(ARMOR_FULL_SPRITE, left, top, 9, 9);
            } else if (i == level) {
                guiGraphics.blitSprite(ARMOR_HALF_SPRITE, left, top, 9, 9);
            } else {
                guiGraphics.blitSprite(ARMOR_EMPTY_SPRITE, left, top, 9, 9);
            }
            left += 8;
        }
        this.leftHeight += 10;
        RenderSystem.disableBlend();
        this.minecraft.getProfiler().pop();
    }

    protected void renderPortalOverlay(GuiGraphics guiGraphics, float alpha) {
        if (alpha > 0.0f) {
            super.renderPortalOverlay(guiGraphics, alpha);
        }
    }

    protected void renderAir(int width, int height, GuiGraphics guiGraphics) {
        this.minecraft.getProfiler().push("air");
        Player player = (Player)this.minecraft.getCameraEntity();
        RenderSystem.enableBlend();
        int left = width / 2 + 91;
        int top = height - this.rightHeight;
        int air = player.getAirSupply();
        if (player.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) || air < 300) {
            int full = Mth.ceil((double)((double)(air - 2) * 10.0 / 300.0));
            int partial = Mth.ceil((double)((double)air * 10.0 / 300.0)) - full;
            for (int i = 0; i < full + partial; ++i) {
                guiGraphics.blitSprite(i < full ? AIR_SPRITE : AIR_BURSTING_SPRITE, left - i * 8 - 9, top, 9, 9);
            }
            this.rightHeight += 10;
        }
        RenderSystem.disableBlend();
        this.minecraft.getProfiler().pop();
    }

    public void renderHealth(int width, int height, GuiGraphics guiGraphics) {
        boolean highlight;
        this.minecraft.getProfiler().push("health");
        RenderSystem.enableBlend();
        Player player = (Player)this.minecraft.getCameraEntity();
        int health = Mth.ceil((float)player.getHealth());
        boolean bl = highlight = this.healthBlinkTime > (long)this.tickCount && (this.healthBlinkTime - (long)this.tickCount) / 3L % 2L == 1L;
        if (health < this.lastHealth && player.invulnerableTime > 0) {
            this.lastHealthTime = Util.getMillis();
            this.healthBlinkTime = this.tickCount + 20;
        } else if (health > this.lastHealth && player.invulnerableTime > 0) {
            this.lastHealthTime = Util.getMillis();
            this.healthBlinkTime = this.tickCount + 10;
        }
        if (Util.getMillis() - this.lastHealthTime > 1000L) {
            this.lastHealth = health;
            this.displayHealth = health;
            this.lastHealthTime = Util.getMillis();
        }
        this.lastHealth = health;
        int healthLast = this.displayHealth;
        AttributeInstance attrMaxHealth = player.getAttribute(Attributes.MAX_HEALTH);
        float healthMax = Math.max((float)attrMaxHealth.getValue(), (float)Math.max(healthLast, health));
        int absorb = Mth.ceil((float)player.getAbsorptionAmount());
        int healthRows = Mth.ceil((float)((healthMax + (float)absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.random.setSeed((long)(this.tickCount * 312871));
        int left = width / 2 - 91;
        int top = height - this.leftHeight;
        this.leftHeight += healthRows * rowHeight;
        if (rowHeight != 10) {
            this.leftHeight += 10 - rowHeight;
        }
        int regen = -1;
        if (player.hasEffect(MobEffects.REGENERATION)) {
            regen = this.tickCount % Mth.ceil((float)(healthMax + 5.0f));
        }
        this.renderHearts(guiGraphics, player, left, top, rowHeight, regen, healthMax, health, healthLast, absorb, highlight);
        RenderSystem.disableBlend();
        this.minecraft.getProfiler().pop();
    }

    public void renderFood(int width, int height, GuiGraphics guiGraphics) {
        this.minecraft.getProfiler().push("food");
        Player player = (Player)this.minecraft.getCameraEntity();
        RenderSystem.enableBlend();
        int left = width / 2 + 91;
        int top = height - this.rightHeight;
        this.rightHeight += 10;
        boolean unused = false;
        FoodData stats = this.minecraft.player.getFoodData();
        int level = stats.getFoodLevel();
        for (int i = 0; i < 10; ++i) {
            ResourceLocation full;
            ResourceLocation half;
            ResourceLocation empty;
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            if (this.minecraft.player.hasEffect(MobEffects.HUNGER)) {
                empty = FOOD_EMPTY_HUNGER_SPRITE;
                half = FOOD_HALF_HUNGER_SPRITE;
                full = FOOD_FULL_HUNGER_SPRITE;
            } else {
                empty = FOOD_EMPTY_SPRITE;
                half = FOOD_HALF_SPRITE;
                full = FOOD_FULL_SPRITE;
            }
            if (player.getFoodData().getSaturationLevel() <= 0.0f && this.tickCount % (level * 3 + 1) == 0) {
                y = top + (this.random.nextInt(3) - 1);
            }
            guiGraphics.blitSprite(empty, x, y, 9, 9);
            if (idx < level) {
                guiGraphics.blitSprite(full, x, y, 9, 9);
                continue;
            }
            if (idx != level) continue;
            guiGraphics.blitSprite(half, x, y, 9, 9);
        }
        RenderSystem.disableBlend();
        this.minecraft.getProfiler().pop();
    }

    protected void renderSleepFade(int width, int height, GuiGraphics guiGraphics) {
        if (this.minecraft.player.getSleepTimer() > 0) {
            this.minecraft.getProfiler().push("sleep");
            int sleepTime = this.minecraft.player.getSleepTimer();
            float opacity = (float)sleepTime / 100.0f;
            if (opacity > 1.0f) {
                opacity = 1.0f - (float)(sleepTime - 100) / 10.0f;
            }
            int color = (int)(220.0f * opacity) << 24 | 0x101020;
            guiGraphics.fill(RenderType.guiOverlay(), 0, 0, width, height, color);
            this.minecraft.getProfiler().pop();
        }
    }

    protected void renderExperience(int x, GuiGraphics guiGraphics) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        if (this.minecraft.gameMode.hasExperience()) {
            super.renderExperienceBar(guiGraphics, x);
        }
        RenderSystem.enableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderJumpMeter(PlayerRideableJumping playerRideableJumping, GuiGraphics guiGraphics, int x) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        super.renderJumpMeter(playerRideableJumping, guiGraphics, x);
        RenderSystem.enableBlend();
        this.minecraft.getProfiler().pop();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderRecordOverlay(int width, int height, float partialTick, GuiGraphics guiGraphics) {
        if (this.overlayMessageTime > 0) {
            this.minecraft.getProfiler().push("overlayMessage");
            float hue = (float)this.overlayMessageTime - partialTick;
            int opacity = (int)(hue * 255.0f / 20.0f);
            if (opacity > 255) {
                opacity = 255;
            }
            if (opacity > 8) {
                int yShift = Math.max(this.leftHeight, this.rightHeight) + 9;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((double)width / 2.0, (double)(height - Math.max(yShift, 68)), 0.0);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                int color = this.animateOverlayMessageColor ? Mth.hsvToRgb((float)(hue / 50.0f), (float)0.7f, (float)0.6f) & 0xFFFFFF : 0xFFFFFF;
                int messageWidth = this.font.width((FormattedText)this.overlayMessageString);
                this.drawBackdrop(guiGraphics, this.font, -4, messageWidth, 0xFFFFFF | opacity << 24);
                guiGraphics.drawString(this.font, this.overlayMessageString.getVisualOrderText(), -messageWidth / 2, -4, color | opacity << 24);
                RenderSystem.disableBlend();
                guiGraphics.pose().popPose();
            }
            this.minecraft.getProfiler().pop();
        }
    }

    protected void renderTitle(int width, int height, float partialTick, GuiGraphics guiGraphics) {
        if (this.title != null && this.titleTime > 0) {
            this.minecraft.getProfiler().push("titleAndSubtitle");
            float age = (float)this.titleTime - partialTick;
            int opacity = 255;
            if (this.titleTime > this.titleFadeOutTime + this.titleStayTime) {
                float f3 = (float)(this.titleFadeInTime + this.titleStayTime + this.titleFadeOutTime) - age;
                opacity = (int)(f3 * 255.0f / (float)this.titleFadeInTime);
            }
            if (this.titleTime <= this.titleFadeOutTime) {
                opacity = (int)(age * 255.0f / (float)this.titleFadeOutTime);
            }
            if ((opacity = Mth.clamp((int)opacity, (int)0, (int)255)) > 8) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((double)width / 2.0, (double)height / 2.0, 0.0);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(4.0f, 4.0f, 4.0f);
                int l = opacity << 24 & 0xFF000000;
                guiGraphics.drawString(this.font, this.title.getVisualOrderText(), -this.getFont().width((FormattedText)this.title) / 2, -10, 0xFFFFFF | l, true);
                guiGraphics.pose().popPose();
                if (this.subtitle != null) {
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().scale(2.0f, 2.0f, 2.0f);
                    guiGraphics.drawString(this.font, this.subtitle.getVisualOrderText(), -this.getFont().width((FormattedText)this.subtitle) / 2, 5, 0xFFFFFF | l, true);
                    guiGraphics.pose().popPose();
                }
                RenderSystem.disableBlend();
                guiGraphics.pose().popPose();
            }
            this.minecraft.getProfiler().pop();
        }
    }

    protected void renderChat(int width, int height, GuiGraphics guiGraphics) {
        this.minecraft.getProfiler().push("chat");
        Window window = this.minecraft.getWindow();
        CustomizeGuiOverlayEvent.Chat event = new CustomizeGuiOverlayEvent.Chat(window, guiGraphics, this.minecraft.getFrameTime(), 0, height - 40);
        NeoForge.EVENT_BUS.post((Event)event);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)event.getPosX(), (double)(event.getPosY() - height + 40) / this.chat.getScale(), 0.0);
        int mouseX = Mth.floor((double)(this.minecraft.mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth()));
        int mouseY = Mth.floor((double)(this.minecraft.mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight()));
        this.chat.render(guiGraphics, this.tickCount, mouseX, mouseY);
        guiGraphics.pose().popPose();
        this.minecraft.getProfiler().pop();
    }

    protected void renderPlayerList(int width, int height, GuiGraphics guiGraphics) {
        Objective scoreobjective = this.minecraft.level.getScoreboard().getDisplayObjective(DisplaySlot.LIST);
        ClientPacketListener handler = this.minecraft.player.connection;
        if (this.minecraft.options.keyPlayerList.isDown() && (!this.minecraft.isLocalServer() || handler.getOnlinePlayers().size() > 1 || scoreobjective != null)) {
            this.tabList.setVisible(true);
            this.tabList.render(guiGraphics, width, this.minecraft.level.getScoreboard(), scoreobjective);
        } else {
            this.tabList.setVisible(false);
        }
    }

    protected void renderHealthMount(int width, int height, GuiGraphics guiGraphics) {
        Player player = (Player)this.minecraft.getCameraEntity();
        Entity tmp = player.getVehicle();
        if (!(tmp instanceof LivingEntity)) {
            return;
        }
        int left_align = width / 2 + 91;
        this.minecraft.getProfiler().popPush("mountHealth");
        RenderSystem.enableBlend();
        LivingEntity mount = (LivingEntity)tmp;
        int health = (int)Math.ceil(mount.getHealth());
        float healthMax = mount.getMaxHealth();
        int hearts = (int)(healthMax + 0.5f) / 2;
        if (hearts > 30) {
            hearts = 30;
        }
        int heart = 0;
        while (hearts > 0) {
            int top = height - this.rightHeight;
            int rowCount = Math.min(hearts, 10);
            hearts -= rowCount;
            for (int i = 0; i < rowCount; ++i) {
                int x = left_align - i * 8 - 9;
                guiGraphics.blitSprite(HEART_VEHICLE_CONTAINER_SPRITE, x, top, 9, 9);
                if (i * 2 + 1 + heart < health) {
                    guiGraphics.blitSprite(HEART_VEHICLE_FULL_SPRITE, x, top, 9, 9);
                    continue;
                }
                if (i * 2 + 1 + heart != health) continue;
                guiGraphics.blitSprite(HEART_VEHICLE_HALF_SPRITE, x, top, 9, 9);
            }
            this.rightHeight += 10;
            heart += 20;
        }
        RenderSystem.disableBlend();
    }

    private boolean pre(NamedGuiOverlay overlay, GuiGraphics guiGraphics) {
        return ((RenderGuiOverlayEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Pre(this.minecraft.getWindow(), guiGraphics, this.minecraft.getFrameTime(), overlay))).isCanceled();
    }

    private void post(NamedGuiOverlay overlay, GuiGraphics guiGraphics) {
        NeoForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Post(this.minecraft.getWindow(), guiGraphics, this.minecraft.getFrameTime(), overlay));
    }

    public void renderDebugScreenOverlay(GuiGraphics guiGraphics) {
        this.getDebugOverlay().render(guiGraphics);
    }
}

