/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.ModLoadingWarning;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.StructureModifier;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.gametest.GameTestHooks;
import net.neoforged.neoforge.network.ConnectionType;
import net.neoforged.neoforge.network.NetworkHooks;
import net.neoforged.neoforge.network.NetworkRegistry;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.server.LanguageHook;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;

public class ServerLifecycleHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker SERVERHOOKS = MarkerManager.getMarker((String)"SERVERHOOKS");
    private static final LevelResource SERVERCONFIG = new LevelResource("serverconfig");
    private static volatile CountDownLatch exitLatch = null;
    private static MinecraftServer currentServer;
    private static AtomicBoolean allowLogins;

    private static Path getServerConfigPath(MinecraftServer server) {
        Path serverConfig = server.getWorldPath(SERVERCONFIG);
        if (!Files.isDirectory(serverConfig, new LinkOption[0])) {
            try {
                Files.createDirectories(serverConfig, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return serverConfig;
    }

    public static void handleServerAboutToStart(MinecraftServer server) {
        currentServer = server;
        LogicalSidedProvider.setServer(() -> server);
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ServerLifecycleHooks.getServerConfigPath(server));
        ServerLifecycleHooks.runModifiers(server);
        NeoForge.EVENT_BUS.post((Event)new ServerAboutToStartEvent(server));
    }

    public static void handleServerStarting(MinecraftServer server) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            LanguageHook.loadLanguagesOnServer(server);
            if (!(server instanceof GameTestServer)) {
                GameTestHooks.registerGametests();
            }
        }
        PermissionAPI.initializePermissionAPI();
        NeoForge.EVENT_BUS.post((Event)new ServerStartingEvent(server));
    }

    public static void handleServerStarted(MinecraftServer server) {
        NeoForge.EVENT_BUS.post((Event)new ServerStartedEvent(server));
        allowLogins.set(true);
    }

    public static void handleServerStopping(MinecraftServer server) {
        allowLogins.set(false);
        NeoForge.EVENT_BUS.post((Event)new ServerStoppingEvent(server));
    }

    public static void expectServerStopped() {
        exitLatch = new CountDownLatch(1);
    }

    public static void handleServerStopped(MinecraftServer server) {
        if (!server.isDedicatedServer()) {
            RegistryManager.revertToFrozen();
        }
        NeoForge.EVENT_BUS.post((Event)new ServerStoppedEvent(server));
        currentServer = null;
        LogicalSidedProvider.setServer(null);
        CountDownLatch latch = exitLatch;
        if (latch != null) {
            latch.countDown();
            exitLatch = null;
        }
        ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ServerLifecycleHooks.getServerConfigPath(server));
    }

    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static boolean handleServerLogin(ClientIntentionPacket packet, Connection manager) {
        if (!allowLogins.get()) {
            MutableComponent text = Component.literal((String)"Server is still starting! Please wait before reconnecting.");
            LOGGER.info(SERVERHOOKS, "Disconnecting Player (server is still starting): {}", (Object)text.getContents());
            manager.send((Packet)new ClientboundLoginDisconnectPacket((Component)text));
            manager.disconnect((Component)text);
            return false;
        }
        if (packet.intention() == ClientIntent.LOGIN) {
            ConnectionType connectionType = ConnectionType.forVersionFlag(packet.getFMLVersion());
            int versionNumber = connectionType.getFMLVersionNumber(packet.getFMLVersion());
            if (connectionType == ConnectionType.MODDED && versionNumber != 3) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, "This modded server is not impl compatible with your modded client. Please verify your NeoForge version closely matches the server. Got net version " + versionNumber + " this server is net version 3");
                return false;
            }
            if (connectionType == ConnectionType.VANILLA && !NetworkRegistry.acceptsVanillaClientConnections()) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, "This server has mods that require NeoForge to be installed on the client. Contact your server admin for more details.");
                return false;
            }
        }
        if (packet.intention() == ClientIntent.STATUS) {
            return true;
        }
        NetworkHooks.registerServerLoginChannel(manager, packet);
        return true;
    }

    private static void rejectConnection(Connection manager, ConnectionType type, String message) {
        manager.setClientboundProtocolAfterHandshake(ClientIntent.LOGIN);
        String ip = "local";
        if (manager.getRemoteAddress() != null) {
            ip = manager.getRemoteAddress().toString();
        }
        LOGGER.info(SERVERHOOKS, "[{}] Disconnecting {} connection attempt: {}", (Object)ip, (Object)type, (Object)message);
        MutableComponent text = Component.literal((String)message);
        manager.send((Packet)new ClientboundLoginDisconnectPacket((Component)text));
        manager.disconnect((Component)text);
    }

    public static void handleExit(int retVal) {
        System.exit(retVal);
    }

    @ApiStatus.Internal
    public static RepositorySource buildPackFinder(Map<IModFile, ? extends PackResources> modResourcePacks) {
        return packAcceptor -> ServerLifecycleHooks.serverPackFinder(modResourcePacks, packAcceptor);
    }

    private static void serverPackFinder(Map<IModFile, ? extends PackResources> modResourcePacks, Consumer<Pack> packAcceptor) {
        for (Map.Entry<IModFile, ? extends PackResources> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            if (Objects.equals(mod.getModId(), "minecraft")) continue;
            String name = "mod:" + mod.getModId();
            Pack modPack = Pack.readMetaAndCreate((String)name, (Component)Component.literal((String)e.getValue().packId()), (boolean)false, (Pack.ResourcesSupplier)BuiltInPackSource.fixedResources((PackResources)e.getValue()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.DEFAULT);
            if (modPack == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{e.getKey()}));
                continue;
            }
            LOGGER.debug(Logging.CORE, "Generating PackInfo named {} for mod file {}", (Object)name, (Object)e.getKey().getFilePath());
            packAcceptor.accept(modPack);
        }
    }

    private static void runModifiers(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.registryAccess();
        List<BiomeModifier> biomeModifiers = registries.registryOrThrow(NeoForgeRegistries.Keys.BIOME_MODIFIERS).holders().map(Holder::value).toList();
        List<StructureModifier> structureModifiers = registries.registryOrThrow(NeoForgeRegistries.Keys.STRUCTURE_MODIFIERS).holders().map(Holder::value).toList();
        registries.registryOrThrow(Registries.BIOME).holders().forEach(biomeHolder -> ((Biome)biomeHolder.value()).modifiableBiomeInfo().applyBiomeModifiers((Holder<Biome>)biomeHolder, biomeModifiers));
        registries.registryOrThrow(Registries.STRUCTURE).holders().forEach(structureHolder -> ((Structure)structureHolder.value()).modifiableStructureInfo().applyStructureModifiers((Holder<Structure>)structureHolder, structureModifiers));
    }

    static {
        allowLogins = new AtomicBoolean(false);
    }
}

