/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LevelAttachmentsSavedData
extends SavedData {
    private static final String NAME = "neoforge_data_attachments";
    private final ServerLevel level;

    public static void init(ServerLevel level) {
        SavedData.Factory factory = new SavedData.Factory(() -> new LevelAttachmentsSavedData(level), tag -> new LevelAttachmentsSavedData(level, (CompoundTag)tag));
        level.getDataStorage().computeIfAbsent(factory, NAME);
    }

    public LevelAttachmentsSavedData(ServerLevel level) {
        this.level = level;
    }

    public LevelAttachmentsSavedData(ServerLevel level, CompoundTag tag) {
        this.level = level;
        level.deserializeAttachments(tag);
    }

    public CompoundTag save(CompoundTag tag) {
        return Objects.requireNonNullElseGet(this.level.serializeAttachments(), CompoundTag::new);
    }

    public boolean isDirty() {
        return true;
    }
}

