/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.custom.payload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.ICustomQueryPayloadWithBuffer;
import org.jetbrains.annotations.NotNull;

public final class SimpleQueryPayload
implements ICustomQueryPayloadWithBuffer {
    private final FriendlyByteBuf payload;
    private final int packetIndex;
    private final ResourceLocation id;

    private SimpleQueryPayload(byte[] payload, int packetIndex, ResourceLocation id) {
        this.payload = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])payload));
        this.packetIndex = packetIndex;
        this.id = id;
    }

    private SimpleQueryPayload(FriendlyByteBuf byteBuf, int packetIndex, ResourceLocation id) {
        this.payload = byteBuf;
        this.packetIndex = packetIndex;
        this.id = id;
    }

    public static SimpleQueryPayload outbound(byte[] payload, int packetIndex, ResourceLocation id) {
        return new SimpleQueryPayload(payload, packetIndex, id);
    }

    public static SimpleQueryPayload outbound(FriendlyByteBuf byteBuf, int packetIndex, ResourceLocation id) {
        return new SimpleQueryPayload(byteBuf, packetIndex, id);
    }

    public static SimpleQueryPayload inbound(FriendlyByteBuf byteBuf) {
        byte[] payload = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(payload);
        FriendlyByteBuf innerBuf = new FriendlyByteBuf(Unpooled.copiedBuffer((byte[])payload));
        return new SimpleQueryPayload(innerBuf, innerBuf.readVarInt(), innerBuf.readResourceLocation());
    }

    public static SimpleQueryPayload inbound(FriendlyByteBuf byteBuf, ResourceLocation verifiableId) {
        SimpleQueryPayload payload = SimpleQueryPayload.inbound(byteBuf);
        if (!payload.id().equals((Object)verifiableId)) {
            throw new IllegalStateException("The received payload did not indicate the same channel id as the received packet: %s vs: %s".formatted(payload.id(), verifiableId));
        }
        return payload;
    }

    public void write(FriendlyByteBuf p_295179_) {
        p_295179_.writeVarInt(this.packetIndex);
        p_295179_.writeResourceLocation(this.id);
        p_295179_.writeBytes(this.payload.slice());
    }

    @Override
    public FriendlyByteBuf buffer() {
        return new FriendlyByteBuf(Unpooled.copiedBuffer((ByteBuf)this.payload));
    }

    @Override
    public int packetIndex() {
        return this.packetIndex;
    }

    public FriendlyByteBuf payload() {
        return this.payload;
    }

    @NotNull
    public ResourceLocation id() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SimpleQueryPayload that = (SimpleQueryPayload)obj;
        return Objects.equals(this.payload, that.payload) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.payload, this.id);
    }

    public String toString() {
        return "SimpleQueryPayload[payload=" + String.valueOf(this.payload) + ", id=" + String.valueOf(this.id) + "]";
    }
}

