/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.items.wrapper;

import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.common.capabilities.Capabilities;
import net.neoforged.neoforge.common.capabilities.Capability;
import net.neoforged.neoforge.common.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.common.util.LazyOptional;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ShulkerItemStackInvWrapper
implements IItemHandlerModifiable,
ICapabilityProvider {
    private final ItemStack stack;
    private final LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this);
    private CompoundTag cachedTag;
    private NonNullList<ItemStack> itemStacksCache;

    @ApiStatus.Internal
    @Nullable
    public static ICapabilityProvider createDefaultProvider(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item == Items.SHULKER_BOX || item == Items.BLACK_SHULKER_BOX || item == Items.BLUE_SHULKER_BOX || item == Items.BROWN_SHULKER_BOX || item == Items.CYAN_SHULKER_BOX || item == Items.GRAY_SHULKER_BOX || item == Items.GREEN_SHULKER_BOX || item == Items.LIGHT_BLUE_SHULKER_BOX || item == Items.LIGHT_GRAY_SHULKER_BOX || item == Items.LIME_SHULKER_BOX || item == Items.MAGENTA_SHULKER_BOX || item == Items.ORANGE_SHULKER_BOX || item == Items.PINK_SHULKER_BOX || item == Items.PURPLE_SHULKER_BOX || item == Items.RED_SHULKER_BOX || item == Items.WHITE_SHULKER_BOX || item == Items.YELLOW_SHULKER_BOX) {
            return new ShulkerItemStackInvWrapper(itemStack);
        }
        return null;
    }

    private ShulkerItemStackInvWrapper(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.getItemList().get(slot);
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        NonNullList<ItemStack> itemStacks = this.getItemList();
        ItemStack existing = (ItemStack)itemStacks.get(slot);
        int limit = Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
        if (!existing.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                itemStacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack));
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.setItemList(itemStacks);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.getCount() - limit) : ItemStack.EMPTY;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        NonNullList<ItemStack> itemStacks = this.getItemList();
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)itemStacks.get(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                itemStacks.set(slot, (Object)ItemStack.EMPTY);
                this.setItemList(itemStacks);
                return existing;
            }
            return existing.copy();
        }
        if (!simulate) {
            itemStacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize(existing, existing.getCount() - toExtract));
            this.setItemList(itemStacks);
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return stack.getItem().canFitInsideContainerItems();
    }

    @Override
    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            throw new RuntimeException("Invalid stack " + String.valueOf(stack) + " for slot " + slot + ")");
        }
        NonNullList<ItemStack> itemStacks = this.getItemList();
        itemStacks.set(slot, (Object)stack);
        this.setItemList(itemStacks);
    }

    private NonNullList<ItemStack> getItemList() {
        CompoundTag rootTag = BlockItem.getBlockEntityData((ItemStack)this.stack);
        if (this.cachedTag == null || !this.cachedTag.equals((Object)rootTag)) {
            this.itemStacksCache = this.refreshItemList(rootTag);
        }
        return this.itemStacksCache;
    }

    private NonNullList<ItemStack> refreshItemList(CompoundTag rootTag) {
        NonNullList itemStacks = NonNullList.withSize((int)this.getSlots(), (Object)ItemStack.EMPTY);
        if (rootTag != null && rootTag.contains("Items", 9)) {
            ContainerHelper.loadAllItems((CompoundTag)rootTag, (NonNullList)itemStacks);
        }
        this.cachedTag = rootTag;
        return itemStacks;
    }

    private void setItemList(NonNullList<ItemStack> itemStacks) {
        CompoundTag existing = BlockItem.getBlockEntityData((ItemStack)this.stack);
        CompoundTag rootTag = ContainerHelper.saveAllItems((CompoundTag)(existing == null ? new CompoundTag() : existing), itemStacks);
        BlockItem.setBlockEntityData((ItemStack)this.stack, (BlockEntityType)BlockEntityType.SHULKER_BOX, (CompoundTag)rootTag);
        this.cachedTag = rootTag;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return Capabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
    }
}

