/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import net.neoforged.neoforge.common.capabilities.ICapabilitySerializable;
import org.jetbrains.annotations.NotNull;

public interface IBlockEntityExtension
extends ICapabilitySerializable<CompoundTag> {
    private BlockEntity self() {
        return (BlockEntity)this;
    }

    @Override
    default public void deserializeNBT(CompoundTag nbt) {
        this.self().load(nbt);
    }

    @Override
    default public CompoundTag serializeNBT() {
        return this.self().saveWithFullMetadata();
    }

    default public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compoundtag = pkt.getTag();
        if (compoundtag != null) {
            this.self().load(compoundtag);
        }
    }

    default public void handleUpdateTag(CompoundTag tag) {
        this.self().load(tag);
    }

    public CompoundTag getPersistentData();

    default public void onChunkUnloaded() {
    }

    default public void onLoad() {
        this.requestModelDataUpdate();
    }

    default public void requestModelDataUpdate() {
        ModelDataManager modelDataManager;
        BlockEntity te = this.self();
        Level level = te.getLevel();
        if (level != null && level.isClientSide && (modelDataManager = level.getModelDataManager()) != null) {
            modelDataManager.requestRefresh(te);
        }
    }

    @NotNull
    default public ModelData getModelData() {
        return ModelData.EMPTY;
    }

    default public boolean hasCustomOutlineRendering(Player player) {
        return false;
    }
}

