/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.Logging;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.LogManager;

public class NeoForgeConfig {
    static final ModConfigSpec clientSpec;
    public static final Client CLIENT;
    static final ModConfigSpec commonSpec;
    public static final Common COMMON;
    static final ModConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        LogManager.getLogger().debug(Logging.FORGEMOD, "Loaded NeoForge config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        LogManager.getLogger().debug(Logging.FORGEMOD, "NeoForge config just got changed on the file system!");
    }

    static {
        Object specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)((Object)specPair.getRight());
        CLIENT = (Client)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)((Object)specPair.getRight());
        COMMON = (Common)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Server::new);
        serverSpec = (ModConfigSpec)((Object)specPair.getRight());
        SERVER = (Server)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue alwaysSetupTerrainOffThread;
        public final ModConfigSpec.BooleanValue experimentalForgeLightPipelineEnabled;
        public final ModConfigSpec.BooleanValue showLoadWarnings;
        public final ModConfigSpec.BooleanValue useCombinedDepthStencilAttachment;
        @Deprecated(since="1.20.1", forRemoval=true)
        public final ModConfigSpec.BooleanValue compressLanIPv6Addresses;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client only settings, mostly things related to rendering").push("client");
            this.alwaysSetupTerrainOffThread = builder.comment("Enable NeoForge to queue all chunk updates to the Chunk Update thread.", "May increase FPS significantly, but may also cause weird rendering lag.", "Not recommended for computers without a significant number of cores available.").translation("neoforge.configgui.alwaysSetupTerrainOffThread").define("alwaysSetupTerrainOffThread", false);
            this.experimentalForgeLightPipelineEnabled = builder.comment("EXPERIMENTAL: Enable the NeoForge block rendering pipeline - fixes the lighting of custom models.").translation("neoforge.configgui.forgeLightPipelineEnabled").define("experimentalForgeLightPipelineEnabled", false);
            this.showLoadWarnings = builder.comment("When enabled, NeoForge will show any warnings that occurred during loading.").translation("neoforge.configgui.showLoadWarnings").define("showLoadWarnings", true);
            this.useCombinedDepthStencilAttachment = builder.comment("Set to true to use a combined DEPTH_STENCIL attachment instead of two separate ones.").translation("neoforge.configgui.useCombinedDepthStencilAttachment").define("useCombinedDepthStencilAttachment", false);
            this.compressLanIPv6Addresses = builder.comment("[Deprecated for Removal] IPv6 addresses will always be compressed").translation("neoforge.configgui.compressLanIPv6Addresses").define("compressLanIPv6Addresses", true);
            builder.pop();
        }
    }

    public static class Common {
        Common(ModConfigSpec.Builder builder) {
            builder.comment("[DEPRECATED / NO EFFECT]: General configuration settings").push("general");
            builder.pop();
        }
    }

    public static class Server {
        public final ModConfigSpec.BooleanValue removeErroringBlockEntities;
        public final ModConfigSpec.BooleanValue removeErroringEntities;
        public final ModConfigSpec.BooleanValue fullBoundingBoxLadders;
        public final ModConfigSpec.ConfigValue<String> permissionHandler;
        public final ModConfigSpec.BooleanValue advertiseDedicatedServerToLan;

        Server(ModConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            this.removeErroringBlockEntities = builder.comment("Set this to true to remove any BlockEntity that throws an error in its update method instead of closing the server and reporting a crash log. BE WARNED THIS COULD SCREW UP EVERYTHING USE SPARINGLY WE ARE NOT RESPONSIBLE FOR DAMAGES.").translation("neoforge.configgui.removeErroringBlockEntities").worldRestart().define("removeErroringBlockEntities", false);
            this.removeErroringEntities = builder.comment("Set this to true to remove any Entity (Note: Does not include BlockEntities) that throws an error in its tick method instead of closing the server and reporting a crash log. BE WARNED THIS COULD SCREW UP EVERYTHING USE SPARINGLY WE ARE NOT RESPONSIBLE FOR DAMAGES.").translation("neoforge.configgui.removeErroringEntities").worldRestart().define("removeErroringEntities", false);
            this.fullBoundingBoxLadders = builder.comment("Set this to true to check the entire entity's collision bounding box for ladders instead of just the block they are in. Causes noticeable differences in mechanics so default is vanilla behavior. Default: false.").translation("neoforge.configgui.fullBoundingBoxLadders").worldRestart().define("fullBoundingBoxLadders", false);
            this.permissionHandler = builder.comment("The permission handler used by the server. Defaults to neoforge:default_handler if no such handler with that name is registered.").translation("neoforge.configgui.permissionHandler").define("permissionHandler", "neoforge:default_handler");
            this.advertiseDedicatedServerToLan = builder.comment("Set this to true to enable advertising the dedicated server to local LAN clients so that it shows up in the Multiplayer screen automatically.").translation("neoforge.configgui.advertiseDedicatedServerToLan").define("advertiseDedicatedServerToLan", true);
            builder.pop();
        }
    }
}

