/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network;

import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.network.HandshakeMessages;
import net.neoforged.neoforge.network.NetworkEvent;
import net.neoforged.neoforge.network.simple.MessageFunctions;

public class ConfigSync {
    public static final ConfigSync INSTANCE = new ConfigSync(ConfigTracker.INSTANCE);
    private final ConfigTracker tracker;

    private ConfigSync(ConfigTracker tracker) {
        this.tracker = tracker;
    }

    public List<MessageFunctions.LoginPacket<HandshakeMessages.S2CConfigData>> syncConfigs(boolean isLocal) {
        Map<String, byte[]> configData = ((Set)this.tracker.configSets().get(ModConfig.Type.SERVER)).stream().collect(Collectors.toMap(ModConfig::getFileName, mc -> {
            try {
                return Files.readAllBytes(mc.getFullPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        return configData.entrySet().stream().map(e -> new MessageFunctions.LoginPacket<HandshakeMessages.S2CConfigData>("Config " + (String)e.getKey(), new HandshakeMessages.S2CConfigData((String)e.getKey(), (byte[])e.getValue()))).toList();
    }

    public void receiveSyncedConfig(HandshakeMessages.S2CConfigData s2CConfigData, NetworkEvent.Context contextSupplier) {
        if (!Minecraft.getInstance().isLocalServer()) {
            Optional.ofNullable((ModConfig)this.tracker.fileMap().get(s2CConfigData.getFileName())).ifPresent(mc -> mc.acceptSyncedConfig(s2CConfigData.getBytes()));
        }
    }
}

