/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.callback.AddCallback;
import net.neoforged.neoforge.registries.callback.BakeCallback;
import net.neoforged.neoforge.registries.callback.ClearCallback;
import net.neoforged.neoforge.registries.callback.RegistryCallback;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class BaseMappedRegistry<T>
implements Registry<T> {
    protected final List<AddCallback<T>> addCallbacks = new ArrayList<AddCallback<T>>();
    protected final List<BakeCallback<T>> bakeCallbacks = new ArrayList<BakeCallback<T>>();
    protected final List<ClearCallback<T>> clearCallbacks = new ArrayList<ClearCallback<T>>();
    final Map<ResourceLocation, ResourceLocation> aliases = new HashMap<ResourceLocation, ResourceLocation>();
    private int maxId = 0x7FFFFFFE;
    private boolean sync;

    void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean doesSync() {
        return this.sync;
    }

    void setMaxId(int maxId) {
        this.maxId = maxId;
    }

    public int getMaxId() {
        return this.maxId;
    }

    public void addCallback(RegistryCallback<T> callback) {
        if (callback instanceof AddCallback) {
            AddCallback addCallback = (AddCallback)callback;
            this.addCallbacks.add(addCallback);
        }
        if (callback instanceof BakeCallback) {
            BakeCallback bakeCallback = (BakeCallback)callback;
            this.bakeCallbacks.add(bakeCallback);
        }
        if (callback instanceof ClearCallback) {
            ClearCallback clearCallback = (ClearCallback)callback;
            this.clearCallbacks.add(clearCallback);
        }
    }

    public void addAlias(ResourceLocation from, ResourceLocation to) {
        ResourceLocation old;
        if (from.equals((Object)to)) {
            return;
        }
        if (this.aliases.containsKey(from) && !(old = this.aliases.get(from)).equals((Object)to)) {
            throw new IllegalStateException("Duplicate alias with key \"" + from + "\" attempting to map to \"" + to + "\", found existing mapping \"" + old + "\"");
        }
        if (this.resolve(from).equals((Object)to)) {
            throw new IllegalStateException("Infinite alias loop detected: from " + from + " to " + to);
        }
        this.aliases.put(from, to);
    }

    public ResourceLocation resolve(ResourceLocation name) {
        if (this.containsKey(name)) {
            return name;
        }
        ResourceLocation alias = this.aliases.get(name);
        if (alias == null) {
            return name;
        }
        return this.resolve(alias);
    }

    public ResourceKey<T> resolve(ResourceKey<T> key) {
        ResourceLocation resolvedName = this.resolve(key.location());
        return resolvedName == key.location() ? key : ResourceKey.create((ResourceKey)this.key(), (ResourceLocation)resolvedName);
    }

    public int getId(ResourceKey<T> key) {
        Object value = this.get(key);
        return value == null ? -1 : this.getId(value);
    }

    public int getId(ResourceLocation name) {
        Object value = this.get(name);
        return value == null ? -1 : this.getId(value);
    }

    protected void clear(boolean full) {
        this.aliases.clear();
    }

    protected abstract void registerIdMapping(ResourceKey<T> var1, int var2);

    protected abstract void unfreeze();
}

