/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.KeyDispatchCodec;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;

public class NeoForgeExtraCodecs {
    public static <T> MapCodec<T> aliasedFieldOf(Codec<T> codec, String ... names) {
        if (names.length == 0) {
            throw new IllegalArgumentException("Must have at least one name!");
        }
        MapCodec<T> mapCodec = codec.fieldOf(names[0]);
        for (int i = 1; i < names.length; ++i) {
            mapCodec = NeoForgeExtraCodecs.mapWithAlternative(mapCodec, codec.fieldOf(names[i]));
        }
        return mapCodec;
    }

    public static <T> MapCodec<T> mapWithAlternative(MapCodec<T> mapCodec, MapCodec<? extends T> alternative) {
        return Codec.mapEither(mapCodec, alternative).xmap(either -> either.map(Function.identity(), Function.identity()), Either::left);
    }

    public static <T> MapCodec<Set<T>> singularOrPluralCodec(Codec<T> codec, String singularName) {
        return NeoForgeExtraCodecs.singularOrPluralCodec(codec, singularName, "%ss".formatted(singularName));
    }

    public static <T> MapCodec<Set<T>> singularOrPluralCodec(Codec<T> codec, String singularName, String pluralName) {
        return Codec.mapEither((MapCodec)codec.fieldOf(singularName), (MapCodec)NeoForgeExtraCodecs.setOf(codec).fieldOf(pluralName)).xmap(either -> (Set)either.map(ImmutableSet::of, ImmutableSet::copyOf), set -> set.size() == 1 ? Either.left(set.iterator().next()) : Either.right((Object)set));
    }

    public static <T> MapCodec<Set<T>> singularOrPluralCodecNotEmpty(Codec<T> codec, String singularName) {
        return NeoForgeExtraCodecs.singularOrPluralCodecNotEmpty(codec, singularName, "%ss".formatted(singularName));
    }

    public static <T> MapCodec<Set<T>> singularOrPluralCodecNotEmpty(Codec<T> codec, String singularName, String pluralName) {
        return Codec.mapEither((MapCodec)codec.fieldOf(singularName), (MapCodec)NeoForgeExtraCodecs.setOf(codec).fieldOf(pluralName)).xmap(either -> (ImmutableSet)either.map(ImmutableSet::of, ImmutableSet::copyOf), set -> set.size() == 1 ? Either.left((Object)set.iterator().next()) : Either.right((Object)set)).flatXmap(ts -> {
            if (ts.isEmpty()) {
                return DataResult.error(() -> "The set for: %s can not be empty!".formatted(singularName));
            }
            return DataResult.success((Object)ts);
        }, ts -> {
            if (ts.isEmpty()) {
                return DataResult.error(() -> "The set for: %s can not be empty!".formatted(singularName));
            }
            return DataResult.success((Object)ImmutableSet.copyOf((Collection)ts));
        });
    }

    public static <T> Codec<Set<T>> setOf(Codec<T> codec) {
        return Codec.list(codec).xmap(ImmutableSet::copyOf, ImmutableList::copyOf);
    }

    public static <K, V> Codec<V> dispatchUnsafe(Codec<K> keyCodec, Function<? super V, ? extends K> type, Function<? super K, ? extends Codec<? extends V>> codec) {
        return NeoForgeExtraCodecs.dispatchUnsafe(keyCodec, "type", type, codec);
    }

    public static <K, V> Codec<V> dispatchUnsafe(Codec<K> keyCodec, String typeKey, Function<? super V, ? extends K> type, Function<? super K, ? extends Codec<? extends V>> codec) {
        return NeoForgeExtraCodecs.partialDispatchUnsafe(keyCodec, typeKey, type.andThen(DataResult::success), codec.andThen(DataResult::success));
    }

    public static <K, V> Codec<V> partialDispatchUnsafe(Codec<K> keyCodec, String typeKey, Function<? super V, ? extends DataResult<? extends K>> type, Function<? super K, ? extends DataResult<? extends Codec<? extends V>>> codec) {
        return KeyDispatchCodec.unsafe((String)typeKey, keyCodec, type, codec, v -> ((DataResult)type.apply((Object)v)).flatMap(k -> ((DataResult)codec.apply((Object)k)).map(Function.identity())).map(e -> e)).codec();
    }

    public static <A> Codec<A> decodeOnly(Decoder<A> decoder) {
        return Codec.of((Encoder)Codec.unit(() -> {
            throw new UnsupportedOperationException("Cannot encode with decode-only codec! Decoder:" + decoder);
        }), decoder, (String)("DecodeOnly[" + decoder + "]"));
    }

    public static <A> Codec<List<A>> listWithOptionalElements(Codec<Optional<A>> elementCodec) {
        return NeoForgeExtraCodecs.listWithoutEmpty(elementCodec.listOf());
    }

    public static <A> Codec<List<A>> listWithoutEmpty(Codec<List<Optional<A>>> codec) {
        return codec.xmap(list -> list.stream().filter(Optional::isPresent).map(Optional::get).toList(), list -> list.stream().map(Optional::of).toList());
    }

    public static <A> Decoder<List<A>> listDecoderWithIndexedPeek(Decoder<List<A>> decoder, ObjIntConsumer<A> consumer) {
        return decoder.map(list -> {
            for (int i = 0; i < list.size(); ++i) {
                consumer.accept(list.get(i), i);
            }
            return list;
        });
    }

    public static <T> Codec<T> withAlternative(Codec<T> codec, Codec<T> alternative) {
        return new AlternativeCodec<T>(codec, alternative);
    }

    private record AlternativeCodec<T>(Codec<T> codec, Codec<T> alternative) implements Codec<T>
    {
        public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
            DataResult result = this.codec.decode(ops, input);
            if (result.error().isEmpty()) {
                return result;
            }
            return this.alternative.decode(ops, input);
        }

        public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
            DataResult result = this.codec.encode(input, ops, prefix);
            if (result.error().isEmpty()) {
                return result;
            }
            return this.alternative.encode(input, ops, prefix);
        }

        @Override
        public String toString() {
            return "Alternative[" + this.codec + ", " + this.alternative + "]";
        }
    }
}

