/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public interface IMobEffectInstanceExtension {
    public List<ItemStack> getCurativeItems();

    default public boolean isCurativeItem(ItemStack stack) {
        return this.getCurativeItems().stream().anyMatch(e -> ItemStack.isSameItem((ItemStack)e, (ItemStack)stack));
    }

    public void setCurativeItems(List<ItemStack> var1);

    default public void addCurativeItem(ItemStack stack) {
        if (!this.isCurativeItem(stack)) {
            this.getCurativeItems().add(stack);
        }
    }

    default public void writeCurativeItems(CompoundTag nbt) {
        ListTag list = new ListTag();
        this.getCurativeItems().forEach(s -> list.add((Object)s.save(new CompoundTag())));
        nbt.put("CurativeItems", (Tag)list);
    }
}

