/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.BusBuilder;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.ConnectionData;
import net.neoforged.neoforge.network.ICustomPacketPayloadWithBuffer;
import net.neoforged.neoforge.network.ICustomQueryPayloadWithBuffer;
import net.neoforged.neoforge.network.LoginNetworkDirection;
import net.neoforged.neoforge.network.MCRegisterPacketHandler;
import net.neoforged.neoforge.network.NetworkEvent;
import net.neoforged.neoforge.network.NetworkHooks;
import net.neoforged.neoforge.network.NetworkRegistry;
import net.neoforged.neoforge.network.PlayNetworkDirection;

public class NetworkInstance {
    private final ResourceLocation channelName;
    private final String networkProtocolVersion;
    private final Predicate<String> clientAcceptedVersions;
    private final Predicate<String> serverAcceptedVersions;
    private final IEventBus networkEventBus;

    public ResourceLocation getChannelName() {
        return this.channelName;
    }

    NetworkInstance(ResourceLocation channelName, Supplier<String> networkProtocolVersion, Predicate<String> clientAcceptedVersions, Predicate<String> serverAcceptedVersions) {
        this.channelName = channelName;
        this.networkProtocolVersion = networkProtocolVersion.get();
        this.clientAcceptedVersions = clientAcceptedVersions;
        this.serverAcceptedVersions = serverAcceptedVersions;
        this.networkEventBus = BusBuilder.builder().setExceptionHandler(this::handleError).build();
    }

    private void handleError(IEventBus iEventBus, Event event, EventListener[] iEventListeners, int i, Throwable throwable) {
    }

    public <T extends NetworkEvent> void addListener(Consumer<T> eventListener) {
        this.networkEventBus.addListener(eventListener);
    }

    public void addGatherListener(Consumer<NetworkEvent.GatherLoginPayloadsEvent> eventListener) {
        this.networkEventBus.addListener(eventListener);
    }

    public void registerObject(Object object) {
        this.networkEventBus.register(object);
    }

    public void unregisterObject(Object object) {
        this.networkEventBus.unregister(object);
    }

    boolean dispatch(PlayNetworkDirection side, ICustomPacketPayloadWithBuffer packet, Connection manager) {
        NetworkEvent.Context context = new NetworkEvent.Context(manager, side, packet.packetIndex());
        this.networkEventBus.post((Event)side.getEvent(packet, context));
        return context.getPacketHandled();
    }

    boolean dispatch(LoginNetworkDirection side, ICustomQueryPayloadWithBuffer packet, Connection manager) {
        NetworkEvent.Context context = new NetworkEvent.Context(manager, side, packet.packetIndex());
        this.networkEventBus.post((Event)side.getEvent(packet, context));
        return context.getPacketHandled();
    }

    String getNetworkProtocolVersion() {
        return this.networkProtocolVersion;
    }

    boolean tryServerVersionOnClient(String serverVersion) {
        return this.clientAcceptedVersions.test(serverVersion);
    }

    boolean tryClientVersionOnServer(String clientVersion) {
        return this.serverAcceptedVersions.test(clientVersion);
    }

    void dispatchGatherLogin(List<NetworkRegistry.LoginPayload> loginPayloadList, boolean isLocal) {
        this.networkEventBus.post((Event)new NetworkEvent.GatherLoginPayloadsEvent(loginPayloadList, isLocal));
    }

    void dispatchLoginPacket(NetworkEvent.LoginPayloadEvent loginPayloadEvent) {
        this.networkEventBus.post((Event)loginPayloadEvent);
    }

    void dispatchEvent(NetworkEvent networkEvent) {
        this.networkEventBus.post((Event)networkEvent);
    }

    public boolean isRemotePresent(Connection manager) {
        ConnectionData connectionData = NetworkHooks.getConnectionData(manager);
        MCRegisterPacketHandler.ChannelList channelList = NetworkHooks.getChannelList(manager);
        return connectionData != null && connectionData.getChannels().containsKey((Object)this.channelName) || channelList != null && channelList.getRemoteLocations().contains(this.channelName);
    }
}

