/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.permission.events;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.server.permission.handler.DefaultPermissionHandler;
import net.neoforged.neoforge.server.permission.handler.IPermissionHandlerFactory;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;

public abstract class PermissionGatherEvent
extends Event {

    public static class Nodes
    extends PermissionGatherEvent {
        private final Set<PermissionNode<?>> nodes = new HashSet();

        public Collection<PermissionNode<?>> getNodes() {
            return Collections.unmodifiableCollection(this.nodes);
        }

        public void addNodes(PermissionNode<?> ... nodes) {
            for (PermissionNode<?> node : nodes) {
                if (this.nodes.add(node)) continue;
                throw new IllegalArgumentException("Tried to register duplicate PermissionNode '" + node.getNodeName() + "'");
            }
        }

        public void addNodes(Iterable<PermissionNode<?>> nodes) {
            for (PermissionNode<?> node : nodes) {
                if (this.nodes.add(node)) continue;
                throw new IllegalArgumentException("Tried to register duplicate PermissionNode '" + node.getNodeName() + "'");
            }
        }
    }

    public static class Handler
    extends PermissionGatherEvent {
        private Map<ResourceLocation, IPermissionHandlerFactory> availableHandlers = new HashMap<ResourceLocation, IPermissionHandlerFactory>();

        public Handler() {
            this.availableHandlers.put(DefaultPermissionHandler.IDENTIFIER, DefaultPermissionHandler::new);
        }

        public Map<ResourceLocation, IPermissionHandlerFactory> getAvailablePermissionHandlerFactories() {
            return Collections.unmodifiableMap(this.availableHandlers);
        }

        public void addPermissionHandler(ResourceLocation identifier, IPermissionHandlerFactory handlerFactory) {
            Preconditions.checkNotNull((Object)identifier, (Object)"Permission handler identifier cannot be null!");
            Preconditions.checkNotNull((Object)handlerFactory, (Object)"Permission handler cannot be null!");
            if (this.availableHandlers.containsKey(identifier)) {
                throw new IllegalArgumentException("Attempted to overwrite permission handler " + identifier + ", this is not allowed.");
            }
            this.availableHandlers.put(identifier, handlerFactory);
        }
    }
}

