/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.ToolAction;
import net.neoforged.neoforge.common.capabilities.ICapabilitySerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IItemStackExtension
extends ICapabilitySerializable<CompoundTag> {
    private ItemStack self() {
        return (ItemStack)this;
    }

    default public ItemStack getCraftingRemainingItem() {
        return this.self().getItem().getCraftingRemainingItem(this.self());
    }

    default public boolean hasCraftingRemainingItem() {
        return this.self().getItem().hasCraftingRemainingItem(this.self());
    }

    default public int getBurnTime(@Nullable RecipeType<?> recipeType) {
        return this.self().getItem().getBurnTime(this.self(), recipeType);
    }

    default public InteractionResult onItemUseFirst(UseOnContext context) {
        Player entityplayer = context.getPlayer();
        BlockPos blockpos = context.getClickedPos();
        BlockInWorld blockworldstate = new BlockInWorld((LevelReader)context.getLevel(), blockpos, false);
        Registry registry = entityplayer.level().registryAccess().registryOrThrow(Registries.BLOCK);
        if (entityplayer != null && !entityplayer.getAbilities().mayBuild && !this.self().hasAdventureModePlaceTagForBlock(registry, blockworldstate)) {
            return InteractionResult.PASS;
        }
        Item item = this.self().getItem();
        InteractionResult enumactionresult = item.onItemUseFirst(this.self(), context);
        if (entityplayer != null && enumactionresult == InteractionResult.SUCCESS) {
            entityplayer.awardStat(Stats.ITEM_USED.get((Object)item));
        }
        return enumactionresult;
    }

    @Override
    default public CompoundTag serializeNBT() {
        CompoundTag ret = new CompoundTag();
        this.self().save(ret);
        return ret;
    }

    default public boolean canPerformAction(ToolAction toolAction) {
        return this.self().getItem().canPerformAction(this.self(), toolAction);
    }

    default public boolean onBlockStartBreak(BlockPos pos, Player player) {
        return !this.self().isEmpty() && this.self().getItem().onBlockStartBreak(this.self(), pos, player);
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack newStack) {
        return this.self().getItem().shouldCauseBlockBreakReset(this.self(), newStack);
    }

    default public boolean canApplyAtEnchantingTable(Enchantment enchantment) {
        return this.self().getItem().canApplyAtEnchantingTable(this.self(), enchantment);
    }

    default public int getEnchantmentLevel(Enchantment enchantment) {
        return this.self().getItem().getEnchantmentLevel(this.self(), enchantment);
    }

    default public Map<Enchantment, Integer> getAllEnchantments() {
        return this.self().getItem().getAllEnchantments(this.self());
    }

    default public int getEnchantmentValue() {
        return this.self().getItem().getEnchantmentValue(this.self());
    }

    @Nullable
    default public EquipmentSlot getEquipmentSlot() {
        return this.self().getItem().getEquipmentSlot(this.self());
    }

    default public boolean canDisableShield(ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.self().getItem().canDisableShield(this.self(), shield, entity, attacker);
    }

    default public boolean onEntitySwing(LivingEntity entity) {
        return this.self().getItem().onEntitySwing(this.self(), entity);
    }

    default public void onStopUsing(LivingEntity entity, int count) {
        this.self().getItem().onStopUsing(this.self(), entity, count);
    }

    default public int getEntityLifespan(Level level) {
        return this.self().getItem().getEntityLifespan(this.self(), level);
    }

    default public boolean onEntityItemUpdate(ItemEntity entity) {
        return this.self().getItem().onEntityItemUpdate(this.self(), entity);
    }

    default public float getXpRepairRatio() {
        return this.self().getItem().getXpRepairRatio(this.self());
    }

    default public void onArmorTick(Level level, Player player) {
        this.self().getItem().onArmorTick(this.self(), level, player);
    }

    default public void onHorseArmorTick(Level level, Mob horse) {
        this.self().getItem().onHorseArmorTick(this.self(), level, horse);
    }

    default public boolean canEquip(EquipmentSlot armorType, Entity entity) {
        return this.self().getItem().canEquip(this.self(), armorType, entity);
    }

    default public boolean isBookEnchantable(ItemStack book) {
        return this.self().getItem().isBookEnchantable(this.self(), book);
    }

    default public boolean onDroppedByPlayer(Player player) {
        return this.self().getItem().onDroppedByPlayer(this.self(), player);
    }

    default public Component getHighlightTip(Component displayName) {
        return this.self().getItem().getHighlightTip(this.self(), displayName);
    }

    @Nullable
    default public CompoundTag getShareTag() {
        return this.self().getItem().getShareTag(this.self());
    }

    default public void readShareTag(@Nullable CompoundTag nbt) {
        this.self().getItem().readShareTag(this.self(), nbt);
    }

    default public boolean doesSneakBypassUse(LevelReader level, BlockPos pos, Player player) {
        return this.self().isEmpty() || this.self().getItem().doesSneakBypassUse(this.self(), level, pos, player);
    }

    default public boolean areShareTagsEqual(ItemStack other) {
        CompoundTag shareTagA = this.self().getShareTag();
        CompoundTag shareTagB = other.getShareTag();
        if (shareTagA == null) {
            return shareTagB == null;
        }
        return shareTagB != null && shareTagA.equals((Object)shareTagB);
    }

    default public boolean equals(ItemStack other, boolean limitTags) {
        if (this.self().isEmpty()) {
            return other.isEmpty();
        }
        return !other.isEmpty() && this.self().getCount() == other.getCount() && this.self().getItem() == other.getItem() && (limitTags ? this.self().areShareTagsEqual(other) : Objects.equals(this.self().getTag(), other.getTag()));
    }

    default public boolean isRepairable() {
        return this.self().getItem().isRepairable(this.self());
    }

    default public boolean isPiglinCurrency() {
        return this.self().getItem().isPiglinCurrency(this.self());
    }

    default public boolean makesPiglinsNeutral(LivingEntity wearer) {
        return this.self().getItem().makesPiglinsNeutral(this.self(), wearer);
    }

    default public boolean isEnderMask(Player player, EnderMan endermanEntity) {
        return this.self().getItem().isEnderMask(this.self(), player, endermanEntity);
    }

    default public boolean canElytraFly(LivingEntity entity) {
        return this.self().getItem().canElytraFly(this.self(), entity);
    }

    default public boolean elytraFlightTick(LivingEntity entity, int flightTicks) {
        return this.self().getItem().elytraFlightTick(this.self(), entity, flightTicks);
    }

    default public boolean canWalkOnPowderedSnow(LivingEntity wearer) {
        return this.self().getItem().canWalkOnPowderedSnow(this.self(), wearer);
    }

    @NotNull
    default public AABB getSweepHitBox(@NotNull Player player, @NotNull Entity target) {
        return this.self().getItem().getSweepHitBox(this.self(), player, target);
    }

    default public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        this.self().getItem().onDestroyed(itemEntity, damageSource);
    }

    @Nullable
    default public FoodProperties getFoodProperties(@Nullable LivingEntity entity) {
        return this.self().getItem().getFoodProperties(this.self(), entity);
    }

    default public boolean isNotReplaceableByPickAction(Player player, int inventorySlot) {
        return this.self().getItem().isNotReplaceableByPickAction(this.self(), player, inventorySlot);
    }

    default public boolean canGrindstoneRepair() {
        return this.self().getItem().canGrindstoneRepair(this.self());
    }
}

