/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.IdMapper;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.StartupMessageManager;
import net.neoforged.fml.util.EnhancedRuntimeException;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.CreativeModeTabRegistry;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.advancements.critereon.ICustomItemPredicate;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.util.LogMessageAdapter;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.StructureModifier;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.ForgeRegistries;
import net.neoforged.neoforge.registries.ForgeRegistry;
import net.neoforged.neoforge.registries.IForgeRegistry;
import net.neoforged.neoforge.registries.IForgeRegistryInternal;
import net.neoforged.neoforge.registries.ILockableRegistry;
import net.neoforged.neoforge.registries.IdMappingEvent;
import net.neoforged.neoforge.registries.MissingMappingsEvent;
import net.neoforged.neoforge.registries.NamespacedDefaultedWrapper;
import net.neoforged.neoforge.registries.NamespacedWrapper;
import net.neoforged.neoforge.registries.ObjectHolderRegistry;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.holdersets.HolderSetType;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GameData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Marker REGISTRIES = ForgeRegistry.REGISTRIES;
    private static final int MAX_VARINT = 0x7FFFFFFE;
    private static final ResourceLocation BLOCK_TO_ITEM = new ResourceLocation("minecraft:blocktoitemmap");
    private static final ResourceLocation BLOCKSTATE_TO_ID = new ResourceLocation("minecraft:blockstatetoid");
    private static final ResourceLocation BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE = new ResourceLocation("minecraft:blockstatetopointofinteresttype");
    private static boolean hasInit = false;
    private static final boolean DISABLE_VANILLA_REGISTRIES = Boolean.parseBoolean(System.getProperty("neoforge.disableVanillaGameData", "false"));
    private static final BiConsumer<ResourceLocation, ForgeRegistry<?>> LOCK_VANILLA = (name, reg) -> reg.slaves.values().stream().filter(o -> o instanceof ILockableRegistry).forEach(o -> ((ILockableRegistry)o).lock());

    public static void init() {
        if (DISABLE_VANILLA_REGISTRIES) {
            LOGGER.warn(REGISTRIES, "DISABLING VANILLA REGISTRY CREATION AS PER SYSTEM VARIABLE SETTING! neoforge.disableVanillaGameData");
            return;
        }
        if (hasInit) {
            return;
        }
        hasInit = true;
        GameData.makeRegistry(ForgeRegistries.Keys.BLOCKS, "air").addCallback(BlockCallbacks.INSTANCE).legacyName("blocks").intrusiveHolderCallback(Block::builtInRegistryHolder).create();
        GameData.makeRegistry(ForgeRegistries.Keys.FLUIDS, "empty").intrusiveHolderCallback(Fluid::builtInRegistryHolder).create();
        GameData.makeRegistry(ForgeRegistries.Keys.ITEMS, "air").addCallback(ItemCallbacks.INSTANCE).legacyName("items").intrusiveHolderCallback(Item::builtInRegistryHolder).create();
        GameData.makeRegistry(ForgeRegistries.Keys.MOB_EFFECTS).legacyName("potions").intrusiveHolderCallback(MobEffect::builtInRegistryHolder).create();
        GameData.makeRegistry(ForgeRegistries.Keys.SOUND_EVENTS).legacyName("soundevents").create();
        GameData.makeRegistry(ForgeRegistries.Keys.POTIONS, "empty").legacyName("potiontypes").intrusiveHolderCallback(Potion::builtInRegistryHolder).create();
        GameData.makeRegistry(ForgeRegistries.Keys.ENCHANTMENTS).legacyName("enchantments").intrusiveHolderCallback(Enchantment::builtInRegistryHolder).create();
        GameData.makeRegistry(ForgeRegistries.Keys.ENTITY_TYPES, "pig").legacyName("entities").intrusiveHolderCallback(EntityType::builtInRegistryHolder).create();
        GameData.makeRegistry(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES).disableSaving().legacyName("blockentities").intrusiveHolderCallback(BlockEntityType::builtInRegistryHolder).create();
        GameData.makeRegistry(ForgeRegistries.Keys.PARTICLE_TYPES).disableSaving().create();
        GameData.makeRegistry(ForgeRegistries.Keys.MENU_TYPES).disableSaving().create();
        GameData.makeRegistry(ForgeRegistries.Keys.PAINTING_VARIANTS, "kebab").create();
        GameData.makeRegistry(ForgeRegistries.Keys.RECIPE_TYPES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.RECIPE_SERIALIZERS).disableSaving().create();
        GameData.makeRegistry(ForgeRegistries.Keys.ATTRIBUTES).onValidate(AttributeCallbacks.INSTANCE).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.STAT_TYPES).create();
        GameData.makeRegistry(ForgeRegistries.Keys.COMMAND_ARGUMENT_TYPES).disableSaving().create();
        GameData.makeRegistry(ForgeRegistries.Keys.VILLAGER_PROFESSIONS, "none").create();
        GameData.makeRegistry(ForgeRegistries.Keys.POI_TYPES).addCallback(PointOfInterestTypeCallbacks.INSTANCE).disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.MEMORY_MODULE_TYPES, "dummy").disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.SENSOR_TYPES, "dummy").disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.SCHEDULES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.ACTIVITIES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.WORLD_CARVERS).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.FEATURES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.CHUNK_STATUS, "empty").disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.BLOCK_STATE_PROVIDER_TYPES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.FOLIAGE_PLACER_TYPES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.TREE_DECORATOR_TYPES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.BIOMES).disableSync().create();
    }

    static RegistryBuilder<EntityDataSerializer<?>> getDataSerializersRegistryBuilder() {
        return GameData.makeRegistry(ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, 256, 0x7FFFFFFE).disableSaving().disableOverrides();
    }

    static RegistryBuilder<Codec<? extends IGlobalLootModifier>> getGLMSerializersRegistryBuilder() {
        return GameData.makeRegistry(ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS).disableSaving().disableSync();
    }

    static RegistryBuilder<Codec<? extends BiomeModifier>> getBiomeModifierSerializersRegistryBuilder() {
        return new RegistryBuilder().disableSaving().disableSync();
    }

    static RegistryBuilder<Codec<? extends StructureModifier>> getStructureModifierSerializersRegistryBuilder() {
        return new RegistryBuilder().disableSaving().disableSync();
    }

    static RegistryBuilder<FluidType> getFluidTypeRegistryBuilder() {
        return GameData.makeRegistry(ForgeRegistries.Keys.FLUID_TYPES).disableSaving();
    }

    static RegistryBuilder<HolderSetType> getHolderSetTypeRegistryBuilder() {
        return new RegistryBuilder().disableSaving().disableSync();
    }

    static RegistryBuilder<IngredientType<?>> getIngredientTypeRegistryBuilder() {
        return new RegistryBuilder().disableSaving().disableSync();
    }

    static RegistryBuilder<Codec<? extends ICondition>> getConditionCodecRegistryBuilder() {
        return new RegistryBuilder().disableSaving().disableSync();
    }

    static RegistryBuilder<Codec<? extends ICustomItemPredicate>> getItemPredicateSerializersRegistryBuilder() {
        return new RegistryBuilder().disableSaving().disableSync();
    }

    static RegistryBuilder<ItemDisplayContext> getItemDisplayContextRegistryBuilder() {
        return new RegistryBuilder().setMaxID(256).disableOverrides().disableSaving().setDefaultKey(new ResourceLocation("minecraft:none")).onAdd(ItemDisplayContext.ADD_CALLBACK);
    }

    private static <T> RegistryBuilder<T> makeRegistry(ResourceKey<? extends Registry<T>> key) {
        return new RegistryBuilder().setName(key.location()).setMaxID(0x7FFFFFFE).hasWrapper();
    }

    private static <T> RegistryBuilder<T> makeRegistry(ResourceKey<? extends Registry<T>> key, int min, int max) {
        return new RegistryBuilder().setName(key.location()).setIDRange(min, max).hasWrapper();
    }

    private static <T> RegistryBuilder<T> makeRegistry(ResourceKey<? extends Registry<T>> key, String _default) {
        return new RegistryBuilder().setName(key.location()).setMaxID(0x7FFFFFFE).hasWrapper().setDefaultKey(new ResourceLocation(_default));
    }

    public static <T> MappedRegistry<T> getWrapper(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle) {
        ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(key);
        Validate.notNull(reg, (String)("Attempted to get vanilla wrapper for unknown registry: " + key.toString()), (Object[])new Object[0]);
        MappedRegistry ret = reg.getSlaveMap(NamespacedWrapper.Factory.ID, NamespacedWrapper.class);
        Validate.notNull((Object)ret, (String)("Attempted to get vanilla wrapper for registry created incorrectly: " + key.toString()), (Object[])new Object[0]);
        return ret;
    }

    public static <T> MappedRegistry<T> getWrapper(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle, String defKey) {
        ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(key);
        Validate.notNull(reg, (String)("Attempted to get vanilla wrapper for unknown registry: " + key.toString()), (Object[])new Object[0]);
        MappedRegistry ret = reg.getSlaveMap(NamespacedDefaultedWrapper.Factory.ID, NamespacedDefaultedWrapper.class);
        Validate.notNull((Object)ret, (String)("Attempted to get vanilla wrapper for registry created incorrectly: " + key.toString()), (Object[])new Object[0]);
        return ret;
    }

    public static Map<Block, Item> getBlockItemMap() {
        return RegistryManager.ACTIVE.getRegistry(ForgeRegistries.Keys.ITEMS).getSlaveMap(BLOCK_TO_ITEM, Map.class);
    }

    public static IdMapper<BlockState> getBlockStateIDMap() {
        return RegistryManager.ACTIVE.getRegistry(ForgeRegistries.Keys.BLOCKS).getSlaveMap(BLOCKSTATE_TO_ID, IdMapper.class);
    }

    public static Map<BlockState, PoiType> getBlockStatePointOfInterestTypeMap() {
        return RegistryManager.ACTIVE.getRegistry(ForgeRegistries.Keys.POI_TYPES).getSlaveMap(BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE, Map.class);
    }

    public static void vanillaSnapshot() {
        LOGGER.debug(REGISTRIES, "Creating vanilla freeze snapshot");
        for (Map.Entry r : RegistryManager.ACTIVE.registries.entrySet()) {
            GameData.loadRegistry((ResourceLocation)r.getKey(), RegistryManager.ACTIVE, RegistryManager.VANILLA, true);
        }
        RegistryManager.VANILLA.registries.forEach((name, reg) -> {
            reg.validateContent((ResourceLocation)name);
            reg.freeze();
        });
        RegistryManager.VANILLA.registries.forEach(LOCK_VANILLA);
        RegistryManager.ACTIVE.registries.forEach(LOCK_VANILLA);
        LOGGER.debug(REGISTRIES, "Vanilla freeze snapshot created");
    }

    public static void unfreezeData() {
        LOGGER.debug(REGISTRIES, "Unfreezing vanilla registries");
        BuiltInRegistries.REGISTRY.stream().filter(r -> r instanceof MappedRegistry).forEach(r -> ((MappedRegistry)r).unfreeze());
    }

    public static void freezeData() {
        LOGGER.debug(REGISTRIES, "Freezing registries");
        BuiltInRegistries.REGISTRY.stream().filter(r -> r instanceof MappedRegistry).forEach(r -> ((MappedRegistry)r).freeze());
        for (Map.Entry r2 : RegistryManager.ACTIVE.registries.entrySet()) {
            GameData.loadRegistry((ResourceLocation)r2.getKey(), RegistryManager.ACTIVE, RegistryManager.FROZEN, true);
        }
        RegistryManager.FROZEN.registries.forEach((name, reg) -> {
            reg.validateContent((ResourceLocation)name);
            reg.freeze();
        });
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> {
            reg.freeze();
            reg.bake();
            reg.dump((ResourceLocation)name);
        });
        GameData.fireRemapEvent((Map<ResourceLocation, Map<ResourceLocation, IdMappingEvent.IdRemapping>>)ImmutableMap.of(), true);
        LOGGER.debug(REGISTRIES, "All registries frozen");
    }

    public static void revertToFrozen() {
        GameData.revertTo(RegistryManager.FROZEN, true);
    }

    public static void revertTo(RegistryManager target, boolean fireEvents) {
        if (target.registries.isEmpty()) {
            LOGGER.warn(REGISTRIES, "Can't revert to {} GameData state without a valid snapshot.", (Object)target.getName());
            return;
        }
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.resetDelegates());
        LOGGER.debug(REGISTRIES, "Reverting to {} data state.", (Object)target.getName());
        for (Map.Entry r : RegistryManager.ACTIVE.registries.entrySet()) {
            GameData.loadRegistry((ResourceLocation)r.getKey(), target, RegistryManager.ACTIVE, true);
        }
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.bake());
        if (fireEvents) {
            GameData.fireRemapEvent((Map<ResourceLocation, Map<ResourceLocation, IdMappingEvent.IdRemapping>>)ImmutableMap.of(), true);
            ObjectHolderRegistry.applyObjectHolders();
        }
        LOGGER.debug(REGISTRIES, "{} state restored.", (Object)target.getName());
    }

    public static void revert(RegistryManager state, ResourceLocation registry, boolean lock) {
        LOGGER.debug(REGISTRIES, "Reverting {} to {}", (Object)registry, (Object)state.getName());
        GameData.loadRegistry(registry, state, RegistryManager.ACTIVE, lock);
        LOGGER.debug(REGISTRIES, "Reverting complete");
    }

    public static void postRegisterEvents() {
        HashSet<ResourceLocation> keySet = new HashSet<ResourceLocation>(RegistryManager.ACTIVE.registries.keySet());
        keySet.addAll(RegistryManager.getVanillaRegistryKeys());
        LinkedHashSet ordered = new LinkedHashSet(MappedRegistry.getKnownRegistries());
        ordered.retainAll(keySet);
        ordered.addAll(keySet.stream().sorted(ResourceLocation::compareNamespaced).toList());
        RuntimeException aggregate = new RuntimeException();
        for (ResourceLocation rootRegistryName : ordered) {
            try {
                ResourceKey registryKey = ResourceKey.createRegistryKey((ResourceLocation)rootRegistryName);
                ForgeRegistry forgeRegistry = RegistryManager.ACTIVE.getRegistry(rootRegistryName);
                Registry vanillaRegistry = (Registry)BuiltInRegistries.REGISTRY.get(rootRegistryName);
                RegisterEvent registerEvent = new RegisterEvent(registryKey, forgeRegistry, vanillaRegistry);
                StartupMessageManager.modLoaderConsumer().ifPresent(s -> s.accept("REGISTERING " + registryKey.location()));
                if (forgeRegistry != null) {
                    forgeRegistry.unfreeze();
                }
                ModLoader.get().postEventWrapContainerInModOrder((Event)registerEvent);
                if (forgeRegistry != null) {
                    forgeRegistry.freeze();
                }
                LOGGER.debug(REGISTRIES, "Applying holder lookups: {}", (Object)registryKey.location());
                ObjectHolderRegistry.applyObjectHolders(arg_0 -> ((ResourceLocation)registryKey.location()).equals(arg_0));
                LOGGER.debug(REGISTRIES, "Holder lookups applied: {}", (Object)registryKey.location());
            }
            catch (Throwable t) {
                aggregate.addSuppressed(t);
            }
        }
        if (aggregate.getSuppressed().length > 0) {
            LOGGER.fatal("Failed to register some entries, see suppressed exceptions for details", (Throwable)aggregate);
            LOGGER.fatal("Detected errors during registry event dispatch, rolling back to VANILLA state");
            GameData.revertTo(RegistryManager.VANILLA, false);
            LOGGER.fatal("Detected errors during registry event dispatch, roll back to VANILLA complete");
            throw aggregate;
        }
        CommonHooks.modifyAttributes();
        SpawnPlacements.fireSpawnPlacementEvent();
        CreativeModeTabRegistry.sortTabs();
    }

    private static <T> void loadRegistry(final ResourceLocation registryName, final RegistryManager from, final RegistryManager to, boolean freeze) {
        ForgeRegistry fromRegistry = from.getRegistry(registryName);
        if (fromRegistry == null) {
            ForgeRegistry toRegistry = to.getRegistry(registryName);
            if (toRegistry == null) {
                throw new EnhancedRuntimeException("Could not find registry to load: " + registryName){
                    private static final long serialVersionUID = 1L;

                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("Looking For: " + registryName);
                        stream.println("Found From:");
                        for (ResourceLocation name : from.registries.keySet()) {
                            stream.println("  " + name);
                        }
                        stream.println("Found To:");
                        for (ResourceLocation name : to.registries.keySet()) {
                            stream.println("  " + name);
                        }
                    }
                };
            }
        } else {
            ForgeRegistry toRegistry = to.getRegistry(registryName, from);
            toRegistry.sync(registryName, fromRegistry);
            if (freeze) {
                toRegistry.isFrozen = true;
            }
        }
    }

    public static Multimap<ResourceLocation, ResourceLocation> injectSnapshot(Map<ResourceLocation, ForgeRegistry.Snapshot> snapshot, boolean injectFrozenData, boolean isLocalWorld) {
        List missingRegs;
        LOGGER.info(REGISTRIES, "Injecting existing registry data into this {} instance", (Object)EffectiveSide.get());
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.validateContent((ResourceLocation)name));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.dump((ResourceLocation)name));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.resetDelegates());
        snapshot = snapshot.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(e -> RegistryManager.ACTIVE.updateLegacyName((ResourceLocation)e.getKey()), Map.Entry::getValue, (k1, k2) -> k1, LinkedHashMap::new));
        if (isLocalWorld && (missingRegs = snapshot.keySet().stream().filter(name -> !RegistryManager.ACTIVE.registries.containsKey(name)).collect(Collectors.toList())).size() > 0) {
            String header = "Fancy Mod Loader detected missing/unknown registries.\n\nThere are " + missingRegs.size() + " missing registries in this save.\nIf you continue the missing registries will get removed.\nThis may cause issues, it is advised that you create a world backup before continuing.\n\n";
            StringBuilder text = new StringBuilder("Missing Registries:\n");
            for (ResourceLocation s : missingRegs) {
                text.append(s).append("\n");
            }
            LOGGER.warn(REGISTRIES, header);
            LOGGER.warn(REGISTRIES, text.toString());
        }
        RegistryManager STAGING = new RegistryManager();
        HashMap remaps = Maps.newHashMap();
        LinkedHashMap missing = Maps.newLinkedHashMap();
        snapshot.forEach((key, value) -> {
            remaps.put(key, Maps.newLinkedHashMap());
            missing.put(key, Maps.newLinkedHashMap());
            GameData.loadPersistentDataToStagingRegistry(RegistryManager.ACTIVE, STAGING, (Map)remaps.get(key), (Map)missing.get(key), key, value);
        });
        int count = missing.values().stream().mapToInt(Map::size).sum();
        if (count > 0) {
            LOGGER.debug(REGISTRIES, "There are {} mappings missing - attempting a mod remap", (Object)count);
            ArrayListMultimap defaulted = ArrayListMultimap.create();
            ArrayListMultimap failed = ArrayListMultimap.create();
            missing.entrySet().stream().filter(e -> ((Map)e.getValue()).size() > 0).forEach(arg_0 -> GameData.lambda$injectSnapshot$27(STAGING, (Multimap)failed, remaps, (Multimap)defaulted, isLocalWorld, arg_0));
            if (!defaulted.isEmpty() && !isLocalWorld) {
                return defaulted;
            }
            if (!defaulted.isEmpty()) {
                String header = "Fancy Mod Loader detected missing registry entries.\n\nThere are " + defaulted.size() + " missing entries in this save.\nIf you continue the missing entries will get removed.\nA world backup will be automatically created in your saves directory.\n\n";
                StringBuilder buf = new StringBuilder();
                defaulted.asMap().forEach((name, entries) -> {
                    buf.append("Missing ").append(name).append(":\n");
                    entries.stream().sorted((o1, o2) -> o1.compareNamespaced(o2)).forEach(rl -> buf.append("    ").append(rl).append("\n"));
                    buf.append("\n");
                });
                LOGGER.warn(REGISTRIES, header);
                LOGGER.warn(REGISTRIES, buf.toString());
            }
            if (!defaulted.isEmpty() && isLocalWorld) {
                LOGGER.error(REGISTRIES, "There are unidentified mappings in this world - we are going to attempt to process anyway");
            }
        }
        if (injectFrozenData) {
            RegistryManager.ACTIVE.registries.forEach((name, reg) -> GameData.loadFrozenDataToStagingRegistry(STAGING, name, (Map)remaps.get(name)));
        }
        STAGING.registries.forEach((name, reg) -> reg.validateContent((ResourceLocation)name));
        RegistryManager.ACTIVE.registries.forEach((key, value) -> GameData.loadRegistry(key, STAGING, RegistryManager.ACTIVE, true));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> {
            reg.bake();
            reg.dump((ResourceLocation)name);
        });
        GameData.fireRemapEvent(remaps, false);
        ObjectHolderRegistry.applyObjectHolders();
        return ArrayListMultimap.create();
    }

    private static void fireRemapEvent(Map<ResourceLocation, Map<ResourceLocation, IdMappingEvent.IdRemapping>> remaps, boolean isFreezing) {
        NeoForge.EVENT_BUS.post((Event)new IdMappingEvent(remaps, isFreezing));
    }

    private static <T> void loadPersistentDataToStagingRegistry(RegistryManager pool, RegistryManager to, Map<ResourceLocation, IdMappingEvent.IdRemapping> remaps, Map<ResourceLocation, Integer> missing, ResourceLocation name, ForgeRegistry.Snapshot snap) {
        ForgeRegistry active = pool.getRegistry(name);
        if (active == null) {
            return;
        }
        ForgeRegistry _new = to.getRegistry(name, RegistryManager.ACTIVE);
        snap.aliases.forEach(_new::addAlias);
        snap.blocked.forEach(_new::block);
        _new.loadIds(snap.ids, snap.overrides, missing, remaps, active, name);
    }

    private static <T> void processMissing(ResourceLocation name, RegistryManager STAGING, MissingMappingsEvent e, Map<ResourceLocation, Integer> missing, Map<ResourceLocation, IdMappingEvent.IdRemapping> remaps, Collection<ResourceLocation> defaulted, Collection<ResourceLocation> failed, boolean injectNetworkDummies) {
        List mappings = e.getAllMappings(ResourceKey.createRegistryKey((ResourceLocation)name));
        ForgeRegistry active = RegistryManager.ACTIVE.getRegistry(name);
        ForgeRegistry staging = STAGING.getRegistry(name);
        staging.processMissingEvent(name, active, mappings, missing, remaps, defaulted, failed, injectNetworkDummies);
    }

    private static <T> void loadFrozenDataToStagingRegistry(RegistryManager STAGING, ResourceLocation name, Map<ResourceLocation, IdMappingEvent.IdRemapping> remaps) {
        ForgeRegistry frozen = RegistryManager.FROZEN.getRegistry(name);
        ForgeRegistry newRegistry = STAGING.getRegistry(name, RegistryManager.FROZEN);
        LinkedHashMap _new = Maps.newLinkedHashMap();
        frozen.getKeys().stream().filter(key -> !newRegistry.containsKey((ResourceLocation)key)).forEach(key -> _new.put(key, frozen.getID((ResourceLocation)key)));
        newRegistry.loadIds(_new, frozen.getOverrideOwners(), Maps.newLinkedHashMap(), remaps, frozen, name);
    }

    public static ResourceLocation checkPrefix(String name, boolean warnOverrides) {
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index).toLowerCase(Locale.ROOT);
        name = index == -1 ? name : name.substring(index + 1);
        String prefix = ModLoadingContext.get().getActiveNamespace();
        if (warnOverrides && !oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            LogManager.getLogger().debug("Mod `{}` attempting to register `{}` to the namespace `{}`. This could be intended, but likely means an EventBusSubscriber without a modid.", (Object)prefix, (Object)name, (Object)oldPrefix);
            prefix = oldPrefix;
        }
        return new ResourceLocation(prefix, name);
    }

    private static /* synthetic */ void lambda$injectSnapshot$27(RegistryManager STAGING, Multimap failed, Map remaps, Multimap defaulted, boolean isLocalWorld, Map.Entry m) {
        ResourceLocation name = (ResourceLocation)m.getKey();
        ForgeRegistry reg = STAGING.getRegistry(name);
        MissingMappingsEvent event = reg.getMissingEvent(name, (Map)m.getValue());
        NeoForge.EVENT_BUS.post((Event)event);
        List lst = event.getAllMappings(reg.getRegistryKey()).stream().filter(e -> e.action == MissingMappingsEvent.Action.DEFAULT).sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
        if (!lst.isEmpty()) {
            LOGGER.error(REGISTRIES, () -> LogMessageAdapter.adapt(sb -> {
                sb.append("Unidentified mapping from registry ").append(name).append('\n');
                lst.stream().sorted().forEach(map -> sb.append('\t').append(map.key).append(": ").append(map.id).append('\n'));
            }));
        }
        event.getAllMappings(reg.getRegistryKey()).stream().filter(e -> e.action == MissingMappingsEvent.Action.FAIL).forEach(fail -> failed.put((Object)name, (Object)fail.key));
        GameData.processMissing(name, STAGING, event, (Map)m.getValue(), (Map)remaps.get(name), defaulted.get((Object)name), failed.get((Object)name), !isLocalWorld);
    }

    static {
        GameData.init();
    }

    private static class BlockCallbacks
    implements IForgeRegistry.AddCallback<Block>,
    IForgeRegistry.ClearCallback<Block>,
    IForgeRegistry.BakeCallback<Block>,
    IForgeRegistry.CreateCallback<Block> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();

        private BlockCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<Block> owner, RegistryManager stage, int id, ResourceKey<Block> key, Block block, @Nullable Block oldBlock) {
            if (oldBlock != null) {
                StateDefinition oldContainer = oldBlock.getStateDefinition();
                StateDefinition newContainer = block.getStateDefinition();
                if (key.location().getNamespace().equals("minecraft") && !oldContainer.getProperties().equals(newContainer.getProperties())) {
                    String oldSequence = oldContainer.getProperties().stream().map(s -> String.format(Locale.ENGLISH, "%s={%s}", s.getName(), s.getPossibleValues().stream().map(Object::toString).collect(Collectors.joining(",")))).collect(Collectors.joining(";"));
                    String newSequence = newContainer.getProperties().stream().map(s -> String.format(Locale.ENGLISH, "%s={%s}", s.getName(), s.getPossibleValues().stream().map(Object::toString).collect(Collectors.joining(",")))).collect(Collectors.joining(";"));
                    LOGGER.error(REGISTRIES, () -> LogMessageAdapter.adapt(sb -> {
                        sb.append("Registry replacements for vanilla block '").append(key.location()).append("' must not change the number or order of blockstates.\n");
                        sb.append("\tOld: ").append(oldSequence).append('\n');
                        sb.append("\tNew: ").append(newSequence);
                    }));
                    throw new RuntimeException("Invalid vanilla replacement. See log for details.");
                }
            }
        }

        @Override
        public void onClear(IForgeRegistryInternal<Block> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCKSTATE_TO_ID, ClearableObjectIntIdentityMap.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<Block> owner, RegistryManager stage) {
            ClearableObjectIntIdentityMap<BlockState> idMap = new ClearableObjectIntIdentityMap<BlockState>(){

                public int getId(BlockState key) {
                    Integer integer = this.tToId.get((Object)key);
                    return integer == null ? -1 : integer;
                }
            };
            owner.setSlaveMap(BLOCKSTATE_TO_ID, idMap);
            owner.setSlaveMap(BLOCK_TO_ITEM, Maps.newHashMap());
        }

        @Override
        public void onBake(IForgeRegistryInternal<Block> owner, RegistryManager stage) {
            ClearableObjectIntIdentityMap blockstateMap = owner.getSlaveMap(BLOCKSTATE_TO_ID, ClearableObjectIntIdentityMap.class);
            for (Block block : owner) {
                for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                    blockstateMap.add(state);
                    state.initCache();
                }
                block.getLootTable();
            }
            DebugLevelSource.initValidStates();
        }
    }

    private static class ItemCallbacks
    implements IForgeRegistry.AddCallback<Item>,
    IForgeRegistry.ClearCallback<Item>,
    IForgeRegistry.CreateCallback<Item> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();

        private ItemCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<Item> owner, RegistryManager stage, int id, ResourceKey<Item> key, Item item, @Nullable Item oldItem) {
            Map blockToItem;
            if (oldItem instanceof BlockItem) {
                blockToItem = owner.getSlaveMap(BLOCK_TO_ITEM, Map.class);
                ((BlockItem)oldItem).removeFromBlockToItemMap(blockToItem, item);
            }
            if (item instanceof BlockItem) {
                blockToItem = owner.getSlaveMap(BLOCK_TO_ITEM, Map.class);
                ((BlockItem)item).registerBlocks(blockToItem, item);
            }
        }

        @Override
        public void onClear(IForgeRegistryInternal<Item> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCK_TO_ITEM, Map.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<Item> owner, RegistryManager stage) {
            Map map = stage.getRegistry(ForgeRegistries.Keys.BLOCKS).getSlaveMap(BLOCK_TO_ITEM, Map.class);
            owner.setSlaveMap(BLOCK_TO_ITEM, map);
        }
    }

    private static class AttributeCallbacks
    implements IForgeRegistry.ValidateCallback<Attribute> {
        static final AttributeCallbacks INSTANCE = new AttributeCallbacks();

        private AttributeCallbacks() {
        }

        @Override
        public void onValidate(IForgeRegistryInternal<Attribute> owner, RegistryManager stage, int id, ResourceLocation key, Attribute obj) {
            if (stage != RegistryManager.VANILLA) {
                DefaultAttributes.validate();
            }
        }
    }

    private static class PointOfInterestTypeCallbacks
    implements IForgeRegistry.AddCallback<PoiType>,
    IForgeRegistry.ClearCallback<PoiType>,
    IForgeRegistry.CreateCallback<PoiType> {
        static final PointOfInterestTypeCallbacks INSTANCE = new PointOfInterestTypeCallbacks();

        private PointOfInterestTypeCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<PoiType> owner, RegistryManager stage, int id, ResourceKey<PoiType> key, PoiType obj, @Nullable PoiType oldObj) {
            Map map = owner.getSlaveMap(BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE, Map.class);
            if (oldObj != null) {
                oldObj.matchingStates().forEach(map::remove);
            }
            obj.matchingStates().forEach(state -> {
                PoiType oldType = map.put(state, obj);
                if (oldType != null) {
                    throw new IllegalStateException(String.format(Locale.ENGLISH, "Point of interest types %s and %s both list %s in their blockstates, this is not allowed. Blockstates can only have one point of interest type each.", oldType, obj, state));
                }
            });
        }

        @Override
        public void onClear(IForgeRegistryInternal<PoiType> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE, Map.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<PoiType> owner, RegistryManager stage) {
            owner.setSlaveMap(BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE, new HashMap());
        }
    }

    private static class ClearableObjectIntIdentityMap<I>
    extends IdMapper<I> {
        private ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.tToId.clear();
            this.idToT.clear();
            this.nextId = 0;
        }

        void remove(I key) {
            Integer prev = this.tToId.remove(key);
            if (prev != null) {
                this.idToT.set(prev, null);
            }
        }
    }
}

