/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.NetworkRegistry;
import net.neoforged.neoforge.network.simple.SimpleLoginMessage;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.ForgeRegistry;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class HandshakeMessages {

    public static class S2CChannelMismatchData
    extends LoginIndexedMessage {
        private final Map<ResourceLocation, String> mismatchedChannelData;

        public S2CChannelMismatchData(Map<ResourceLocation, String> mismatchedChannelData) {
            this.mismatchedChannelData = mismatchedChannelData;
        }

        public static S2CChannelMismatchData decode(FriendlyByteBuf input) {
            Map mismatchedMods = input.readMap(i -> new ResourceLocation(i.readUtf(256)), i -> i.readUtf(256));
            return new S2CChannelMismatchData(mismatchedMods);
        }

        @Override
        public void encode(FriendlyByteBuf output) {
            output.writeMap(this.mismatchedChannelData, (o, r) -> o.writeUtf(r.toString(), 256), (o, v) -> o.writeUtf(v, 256));
        }

        public Map<ResourceLocation, String> getMismatchedChannelData() {
            return this.mismatchedChannelData;
        }
    }

    public static class S2CConfigData
    extends LoginIndexedMessage {
        private final String fileName;
        private final byte[] fileData;

        public S2CConfigData(String configFileName, byte[] configFileData) {
            this.fileName = configFileName;
            this.fileData = configFileData;
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.fileName);
            buffer.writeByteArray(this.fileData);
        }

        public static S2CConfigData decode(FriendlyByteBuf buffer) {
            return new S2CConfigData(buffer.readUtf(Short.MAX_VALUE), buffer.readByteArray());
        }

        public String getFileName() {
            return this.fileName;
        }

        public byte[] getBytes() {
            return this.fileData;
        }
    }

    public static class S2CRegistry
    extends LoginIndexedMessage {
        private final ResourceLocation registryName;
        @Nullable
        private final ForgeRegistry.Snapshot snapshot;

        public S2CRegistry(ResourceLocation name, @Nullable ForgeRegistry.Snapshot snapshot) {
            this.registryName = name;
            this.snapshot = snapshot;
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.writeResourceLocation(this.registryName);
            buffer.writeBoolean(this.hasSnapshot());
            if (this.hasSnapshot()) {
                buffer.writeBytes((ByteBuf)this.snapshot.getPacketData());
            }
        }

        public static S2CRegistry decode(FriendlyByteBuf buffer) {
            ResourceLocation name = buffer.readResourceLocation();
            ForgeRegistry.Snapshot snapshot = null;
            if (buffer.readBoolean()) {
                snapshot = ForgeRegistry.Snapshot.read(buffer);
            }
            return new S2CRegistry(name, snapshot);
        }

        public ResourceLocation getRegistryName() {
            return this.registryName;
        }

        public boolean hasSnapshot() {
            return this.snapshot != null;
        }

        @Nullable
        public ForgeRegistry.Snapshot getSnapshot() {
            return this.snapshot;
        }
    }

    public static class C2SAcknowledge
    extends LoginIndexedMessage {
        @Override
        public void encode(FriendlyByteBuf buf) {
        }

        public static C2SAcknowledge decode(FriendlyByteBuf buf) {
            return new C2SAcknowledge();
        }
    }

    public static class C2SModListReply
    extends LoginIndexedMessage {
        private List<String> mods;
        private Map<ResourceLocation, String> channels;
        private Map<ResourceLocation, String> registries;

        public C2SModListReply() {
            this.mods = ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toList());
            this.channels = NetworkRegistry.buildChannelVersions();
            this.registries = Maps.newHashMap();
        }

        private C2SModListReply(List<String> mods, Map<ResourceLocation, String> channels, Map<ResourceLocation, String> registries) {
            this.mods = mods;
            this.channels = channels;
            this.registries = registries;
        }

        public static C2SModListReply decode(FriendlyByteBuf input) {
            ArrayList<String> mods = new ArrayList<String>();
            int len = input.readVarInt();
            for (int x = 0; x < len; ++x) {
                mods.add(input.readUtf(256));
            }
            HashMap<ResourceLocation, String> channels = new HashMap<ResourceLocation, String>();
            len = input.readVarInt();
            for (int x = 0; x < len; ++x) {
                channels.put(input.readResourceLocation(), input.readUtf(256));
            }
            HashMap<ResourceLocation, String> registries = new HashMap<ResourceLocation, String>();
            len = input.readVarInt();
            for (int x = 0; x < len; ++x) {
                registries.put(input.readResourceLocation(), input.readUtf(256));
            }
            return new C2SModListReply(mods, channels, registries);
        }

        @Override
        public void encode(FriendlyByteBuf output) {
            output.writeVarInt(this.mods.size());
            this.mods.forEach(m -> output.writeUtf(m, 256));
            output.writeVarInt(this.channels.size());
            this.channels.forEach((k, v) -> {
                output.writeResourceLocation(k);
                output.writeUtf(v, 256);
            });
            output.writeVarInt(this.registries.size());
            this.registries.forEach((k, v) -> {
                output.writeResourceLocation(k);
                output.writeUtf(v, 256);
            });
        }

        public List<String> getModList() {
            return this.mods;
        }

        public Map<ResourceLocation, String> getRegistries() {
            return this.registries;
        }

        public Map<ResourceLocation, String> getChannels() {
            return this.channels;
        }
    }

    public static class S2CModData
    extends LoginIndexedMessage {
        private final Map<String, Pair<String, String>> mods;

        public S2CModData() {
            this.mods = ModList.get().getMods().stream().collect(Collectors.toMap(IModInfo::getModId, info -> Pair.of((Object)info.getDisplayName(), (Object)info.getVersion().toString())));
        }

        private S2CModData(Map<String, Pair<String, String>> mods) {
            this.mods = mods;
        }

        public static S2CModData decode(FriendlyByteBuf input) {
            Map mods = input.readMap(o -> o.readUtf(256), o -> Pair.of((Object)o.readUtf(256), (Object)o.readUtf(256)));
            return new S2CModData(mods);
        }

        @Override
        public void encode(FriendlyByteBuf output) {
            output.writeMap(this.mods, (o, s) -> o.writeUtf(s, 256), (o, p) -> {
                o.writeUtf((String)p.getLeft(), 256);
                o.writeUtf((String)p.getRight(), 256);
            });
        }

        public Map<String, Pair<String, String>> getMods() {
            return this.mods;
        }
    }

    public static class S2CModList
    extends LoginIndexedMessage {
        private List<String> mods;
        private Map<ResourceLocation, String> channels;
        private List<ResourceLocation> registries;
        private final List<ResourceKey<? extends Registry<?>>> dataPackRegistries;

        public S2CModList() {
            this.mods = ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toList());
            this.channels = NetworkRegistry.buildChannelVersions();
            this.registries = RegistryManager.getRegistryNamesForSyncToClient();
            this.dataPackRegistries = List.copyOf(DataPackRegistriesHooks.getSyncedCustomRegistries());
        }

        private S2CModList(List<String> mods, Map<ResourceLocation, String> channels, List<ResourceLocation> registries, List<ResourceKey<? extends Registry<?>>> dataPackRegistries) {
            this.mods = mods;
            this.channels = channels;
            this.registries = registries;
            this.dataPackRegistries = dataPackRegistries;
        }

        public static S2CModList decode(FriendlyByteBuf input) {
            ArrayList<String> mods = new ArrayList<String>();
            int len = input.readVarInt();
            for (int x = 0; x < len; ++x) {
                mods.add(input.readUtf(256));
            }
            HashMap<ResourceLocation, String> channels = new HashMap<ResourceLocation, String>();
            len = input.readVarInt();
            for (int x = 0; x < len; ++x) {
                channels.put(input.readResourceLocation(), input.readUtf(256));
            }
            ArrayList<ResourceLocation> registries = new ArrayList<ResourceLocation>();
            len = input.readVarInt();
            for (int x = 0; x < len; ++x) {
                registries.add(input.readResourceLocation());
            }
            List dataPackRegistries = (List)input.readCollection(ArrayList::new, buf -> ResourceKey.createRegistryKey((ResourceLocation)buf.readResourceLocation()));
            return new S2CModList(mods, channels, registries, dataPackRegistries);
        }

        @Override
        public void encode(FriendlyByteBuf output) {
            output.writeVarInt(this.mods.size());
            this.mods.forEach(m -> output.writeUtf(m, 256));
            output.writeVarInt(this.channels.size());
            this.channels.forEach((k, v) -> {
                output.writeResourceLocation(k);
                output.writeUtf(v, 256);
            });
            output.writeVarInt(this.registries.size());
            this.registries.forEach(arg_0 -> ((FriendlyByteBuf)output).writeResourceLocation(arg_0));
            Set<ResourceKey<? extends Registry<?>>> dataPackRegistries = DataPackRegistriesHooks.getSyncedCustomRegistries();
            output.writeCollection(dataPackRegistries, (buf, key) -> buf.writeResourceLocation(key.location()));
        }

        public List<String> getModList() {
            return this.mods;
        }

        public List<ResourceLocation> getRegistries() {
            return this.registries;
        }

        public Map<ResourceLocation, String> getChannels() {
            return this.channels;
        }

        public List<ResourceKey<? extends Registry<?>>> getCustomDataPackRegistries() {
            return this.dataPackRegistries;
        }
    }

    static abstract class LoginIndexedMessage
    implements SimpleLoginMessage {
        private int loginIndex;

        LoginIndexedMessage() {
        }

        @Override
        public void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }

        @Override
        public int getLoginIndex() {
            return this.loginIndex;
        }
    }
}

