/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.LogMessageAdapter;
import net.neoforged.neoforge.event.entity.player.PlayerNegotiationEvent;
import net.neoforged.neoforge.network.ConfigSync;
import net.neoforged.neoforge.network.ConnectionData;
import net.neoforged.neoforge.network.ConnectionType;
import net.neoforged.neoforge.network.HandshakeMessages;
import net.neoforged.neoforge.network.LoginNetworkDirection;
import net.neoforged.neoforge.network.LoginWrapper;
import net.neoforged.neoforge.network.NetworkConstants;
import net.neoforged.neoforge.network.NetworkEvent;
import net.neoforged.neoforge.network.NetworkHooks;
import net.neoforged.neoforge.network.NetworkRegistry;
import net.neoforged.neoforge.network.simple.MessageFunctions;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.ForgeRegistry;
import net.neoforged.neoforge.registries.GameData;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;

public class HandshakeHandler {
    static final Marker FMLHSMARKER = MarkerManager.getMarker((String)"FMLHANDSHAKE").setParents(new Marker[]{NetworkConstants.NETWORK});
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LoginWrapper loginWrapper = new LoginWrapper();
    private final List<NetworkRegistry.LoginPayload> messageList;
    private final IntArrayList sentMessages = new IntArrayList();
    private final LoginNetworkDirection direction;
    private final Connection manager;
    private int packetPosition;
    private Map<ResourceLocation, ForgeRegistry.Snapshot> registrySnapshots;
    private Set<ResourceLocation> registriesToReceive;
    private boolean negotiationStarted = false;
    private final List<Future<Void>> pendingFutures = new ArrayList<Future<Void>>();

    static void registerHandshake(Connection manager, LoginNetworkDirection direction) {
        manager.channel().attr(NetworkConstants.FML_HANDSHAKE_HANDLER).compareAndSet(null, (Object)new HandshakeHandler(manager, direction));
    }

    static boolean tickLogin(Connection networkManager) {
        return ((HandshakeHandler)networkManager.channel().attr(NetworkConstants.FML_HANDSHAKE_HANDLER).get()).tickServer();
    }

    private HandshakeHandler(Connection networkManager, LoginNetworkDirection side) {
        this.direction = side;
        this.manager = networkManager;
        if (networkManager.isMemoryConnection()) {
            this.messageList = NetworkRegistry.gatherLoginPayloads(this.direction, true);
            LOGGER.debug(FMLHSMARKER, "Starting local connection.");
        } else if (NetworkHooks.getConnectionType(() -> this.manager) == ConnectionType.VANILLA) {
            this.messageList = Collections.emptyList();
            LOGGER.debug(FMLHSMARKER, "Starting new vanilla impl connection.");
        } else {
            this.messageList = NetworkRegistry.gatherLoginPayloads(this.direction, false);
            LOGGER.debug(FMLHSMARKER, "Starting new modded impl connection. Found {} messages to dispatch.", (Object)this.messageList.size());
        }
    }

    public static <MSG extends IntSupplier> MessageFunctions.MessageConsumer<MSG> consumerFor(HandshakeConsumer<MSG> consumer) {
        return (m, c) -> consumer.accept(HandshakeHandler.getHandshake(c), m, c);
    }

    public static <MSG extends IntSupplier> MessageFunctions.MessageConsumer<MSG> indexFirst(HandshakeConsumer<MSG> next) {
        MessageFunctions.MessageConsumer<IntSupplier> loginIndexedMessageSupplierBiConsumer = HandshakeHandler.consumerFor(HandshakeHandler::handleIndexedMessage);
        return loginIndexedMessageSupplierBiConsumer.andThen(HandshakeHandler.consumerFor(next));
    }

    private static HandshakeHandler getHandshake(NetworkEvent.Context contextSupplier) {
        return (HandshakeHandler)contextSupplier.attr(NetworkConstants.FML_HANDSHAKE_HANDLER).get();
    }

    void handleServerModListOnClient(HandshakeMessages.S2CModList serverModList, NetworkEvent.Context c) {
        LOGGER.debug(FMLHSMARKER, "Logging into server with mod list [{}]", (Object)String.join((CharSequence)", ", serverModList.getModList()));
        Map<ResourceLocation, String> mismatchedChannels = NetworkRegistry.validateClientChannels(serverModList.getChannels());
        c.setPacketHandled(true);
        NetworkHooks.appendConnectionData(c.getNetworkManager(), serverModList.getModList().stream().collect(Collectors.toMap(Function.identity(), s -> Pair.of((Object)"", (Object)""))), serverModList.getChannels());
        if (!mismatchedChannels.isEmpty()) {
            LOGGER.error(FMLHSMARKER, "Terminating connection with server, mismatched mod list");
            c.getNetworkManager().channel().attr(NetworkConstants.FML_MOD_MISMATCH_DATA).set((Object)ConnectionData.ModMismatchData.channel(mismatchedChannels, NetworkHooks.getConnectionData(c.getNetworkManager()), true));
            c.getNetworkManager().disconnect((Component)Component.literal((String)"Connection closed - mismatched mod channel list"));
            return;
        }
        ArrayList<String> missingDataPackRegistries = new ArrayList<String>();
        Set<ResourceKey<Registry<?>>> clientDataPackRegistries = DataPackRegistriesHooks.getSyncedCustomRegistries();
        for (ResourceKey<? extends Registry<?>> resourceKey : serverModList.getCustomDataPackRegistries()) {
            if (clientDataPackRegistries.contains(resourceKey)) continue;
            ResourceLocation location = resourceKey.location();
            LOGGER.error(FMLHSMARKER, "Missing required datapack registry: {}", (Object)location);
            missingDataPackRegistries.add(resourceKey.location().toString());
        }
        if (!missingDataPackRegistries.isEmpty()) {
            c.getNetworkManager().disconnect((Component)Component.translatable((String)"fml.menu.multiplayer.missingdatapackregistries", (Object[])new Object[]{String.join((CharSequence)", ", missingDataPackRegistries)}));
            return;
        }
        NetworkConstants.handshakeChannel.reply(new HandshakeMessages.C2SModListReply(), c);
        LOGGER.debug(FMLHSMARKER, "Accepted server connection");
        c.getNetworkManager().channel().attr(NetworkConstants.FML_NETVERSION).set((Object)"FML3");
        this.registriesToReceive = new HashSet<ResourceLocation>(serverModList.getRegistries());
        this.registrySnapshots = Maps.newHashMap();
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Expecting {} registries: {}", new Supplier[]{() -> this.registriesToReceive.size(), () -> this.registriesToReceive});
    }

    void handleModData(HandshakeMessages.S2CModData serverModData, NetworkEvent.Context c) {
        c.getNetworkManager().channel().attr(NetworkConstants.FML_CONNECTION_DATA).set((Object)new ConnectionData(serverModData.getMods(), new HashMap<ResourceLocation, String>()));
        c.setPacketHandled(true);
    }

    <MSG extends IntSupplier> void handleIndexedMessage(MSG message, NetworkEvent.Context c) {
        LOGGER.debug(FMLHSMARKER, "Received client indexed reply {} of type {}", (Object)message.getAsInt(), (Object)message.getClass().getName());
        boolean removed = this.sentMessages.removeIf(i -> i == message.getAsInt());
        if (!removed) {
            LOGGER.error(FMLHSMARKER, "Recieved unexpected index {} in client reply", (Object)message.getAsInt());
        }
    }

    void handleClientModListOnServer(HandshakeMessages.C2SModListReply clientModList, NetworkEvent.Context c) {
        LOGGER.debug(FMLHSMARKER, "Received client connection with modlist [{}]", (Object)String.join((CharSequence)", ", clientModList.getModList()));
        Map<ResourceLocation, String> mismatchedChannels = NetworkRegistry.validateServerChannels(clientModList.getChannels());
        c.getNetworkManager().channel().attr(NetworkConstants.FML_CONNECTION_DATA).set((Object)new ConnectionData(clientModList.getModList().stream().collect(Collectors.toMap(Function.identity(), s -> Pair.of((Object)"", (Object)""))), clientModList.getChannels()));
        c.setPacketHandled(true);
        if (!mismatchedChannels.isEmpty()) {
            LOGGER.error(FMLHSMARKER, "Terminating connection with client, mismatched mod list");
            NetworkConstants.handshakeChannel.reply(new HandshakeMessages.S2CChannelMismatchData(mismatchedChannels), c);
            c.getNetworkManager().disconnect((Component)Component.literal((String)"Connection closed - mismatched mod channel list"));
            return;
        }
        LOGGER.debug(FMLHSMARKER, "Accepted client connection mod list");
    }

    void handleModMismatchData(HandshakeMessages.S2CChannelMismatchData modMismatchData, NetworkEvent.Context c) {
        if (!modMismatchData.getMismatchedChannelData().isEmpty()) {
            LOGGER.error(FMLHSMARKER, "Channels [{}] rejected their client side version number", (Object)modMismatchData.getMismatchedChannelData().keySet().stream().map(Object::toString).collect(Collectors.joining(",")));
            LOGGER.error(FMLHSMARKER, "Terminating connection with server, mismatched mod list");
            c.setPacketHandled(true);
            c.getNetworkManager().channel().attr(NetworkConstants.FML_MOD_MISMATCH_DATA).set((Object)ConnectionData.ModMismatchData.channel(modMismatchData.getMismatchedChannelData(), NetworkHooks.getConnectionData(c.getNetworkManager()), false));
            c.getNetworkManager().disconnect((Component)Component.literal((String)"Connection closed - mismatched mod channel list"));
        }
    }

    void handleRegistryMessage(HandshakeMessages.S2CRegistry registryPacket, NetworkEvent.Context contextSupplier) {
        LOGGER.debug(FMLHSMARKER, "Received registry packet for {}", (Object)registryPacket.getRegistryName());
        this.registriesToReceive.remove(registryPacket.getRegistryName());
        this.registrySnapshots.put(registryPacket.getRegistryName(), registryPacket.getSnapshot());
        boolean continueHandshake = true;
        if (this.registriesToReceive.isEmpty()) {
            continueHandshake = this.handleRegistryLoading(contextSupplier);
        }
        contextSupplier.setPacketHandled(true);
        if (!continueHandshake) {
            LOGGER.error(FMLHSMARKER, "Connection closed, not continuing handshake");
        } else {
            NetworkConstants.handshakeChannel.reply(new HandshakeMessages.C2SAcknowledge(), contextSupplier);
        }
    }

    private boolean handleRegistryLoading(NetworkEvent.Context contextSupplier) {
        AtomicBoolean successfulConnection = new AtomicBoolean(false);
        AtomicReference registryMismatches = new AtomicReference();
        CountDownLatch block = new CountDownLatch(1);
        contextSupplier.enqueueWork(() -> {
            LOGGER.debug(FMLHSMARKER, "Injecting registry snapshot from server.");
            Multimap<ResourceLocation, ResourceLocation> missingData = GameData.injectSnapshot(this.registrySnapshots, false, false);
            LOGGER.debug(FMLHSMARKER, "Snapshot injected.");
            if (!missingData.isEmpty()) {
                LOGGER.error(FMLHSMARKER, "Missing registry data for impl connection:\n{}", (Object)LogMessageAdapter.adapt(sb -> missingData.forEach((reg, entry) -> sb.append("\t").append(reg).append(": ").append(entry).append('\n'))));
            }
            successfulConnection.set(missingData.isEmpty());
            registryMismatches.set(missingData);
            block.countDown();
        });
        LOGGER.debug(FMLHSMARKER, "Waiting for registries to load.");
        try {
            block.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        if (successfulConnection.get()) {
            LOGGER.debug(FMLHSMARKER, "Registry load complete, continuing handshake.");
        } else {
            LOGGER.error(FMLHSMARKER, "Failed to load registry, closing connection.");
            this.manager.channel().attr(NetworkConstants.FML_MOD_MISMATCH_DATA).set((Object)ConnectionData.ModMismatchData.registry((Multimap<ResourceLocation, ResourceLocation>)((Multimap)registryMismatches.get()), NetworkHooks.getConnectionData(contextSupplier.getNetworkManager())));
            this.manager.disconnect((Component)Component.literal((String)"Failed to synchronize registry data from server, closing connection"));
        }
        return successfulConnection.get();
    }

    void handleClientAck(HandshakeMessages.C2SAcknowledge msg, NetworkEvent.Context contextSupplier) {
        LOGGER.debug(FMLHSMARKER, "Received acknowledgement from client");
        contextSupplier.setPacketHandled(true);
    }

    void handleConfigSync(HandshakeMessages.S2CConfigData msg, NetworkEvent.Context contextSupplier) {
        LOGGER.debug(FMLHSMARKER, "Received config sync from server");
        ConfigSync.INSTANCE.receiveSyncedConfig(msg, contextSupplier);
        contextSupplier.setPacketHandled(true);
        NetworkConstants.handshakeChannel.reply(new HandshakeMessages.C2SAcknowledge(), contextSupplier);
    }

    public boolean tickServer() {
        if (!this.negotiationStarted) {
            GameProfile profile = ((ServerLoginPacketListenerImpl)this.manager.getPacketListener()).authenticatedProfile;
            PlayerNegotiationEvent event = new PlayerNegotiationEvent(this.manager, profile, this.pendingFutures);
            NeoForge.EVENT_BUS.post((Event)event);
            this.negotiationStarted = true;
        }
        if (this.packetPosition < this.messageList.size()) {
            NetworkRegistry.LoginPayload message = this.messageList.get(this.packetPosition);
            LOGGER.debug(FMLHSMARKER, "Sending ticking packet info '{}' to '{}' sequence {}", (Object)message.getMessageContext(), (Object)message.getChannelName(), (Object)this.packetPosition);
            if (message.needsResponse()) {
                this.sentMessages.add(this.packetPosition);
            }
            loginWrapper.sendServerToClientLoginPacket(message.getChannelName(), message.getData(), this.packetPosition, this.manager);
            ++this.packetPosition;
        }
        this.pendingFutures.removeIf(future -> {
            if (!future.isDone()) {
                return false;
            }
            try {
                future.get();
            }
            catch (ExecutionException ex) {
                LOGGER.error("Error during negotiation", ex.getCause());
            }
            catch (InterruptedException | CancellationException exception) {
                // empty catch block
            }
            return true;
        });
        if (this.sentMessages.isEmpty() && this.packetPosition >= this.messageList.size() - 1 && this.pendingFutures.isEmpty()) {
            this.manager.channel().attr(NetworkConstants.FML_HANDSHAKE_HANDLER).set(null);
            LOGGER.debug(FMLHSMARKER, "Handshake complete!");
            return true;
        }
        return false;
    }

    public static boolean packetNeedsResponse(Connection mgr, int packetPosition) {
        HandshakeHandler handler = (HandshakeHandler)mgr.channel().attr(NetworkConstants.FML_HANDSHAKE_HANDLER).get();
        if (handler != null) {
            return handler.sentMessages.contains(packetPosition);
        }
        return false;
    }

    @FunctionalInterface
    public static interface HandshakeConsumer<MSG extends IntSupplier> {
        public void accept(HandshakeHandler var1, MSG var2, NetworkEvent.Context var3);
    }
}

