/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.items;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class SlotItemHandler
extends Slot {
    private static Container emptyInventory = new SimpleContainer(0);
    private final IItemHandler itemHandler;
    private final int index;

    public SlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.itemHandler = itemHandler;
        this.index = index;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.itemHandler.isItemValid(this.index, stack);
    }

    @NotNull
    public ItemStack getItem() {
        return this.getItemHandler().getStackInSlot(this.index);
    }

    public void set(@NotNull ItemStack stack) {
        ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.index, stack);
        this.setChanged();
    }

    public void initialize(ItemStack stack) {
        ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.index, stack);
        this.setChanged();
    }

    public void onQuickCraft(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
    }

    public int getMaxStackSize() {
        return this.itemHandler.getSlotLimit(this.index);
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        ItemStack maxAdd = stack.copy();
        int maxInput = stack.getMaxStackSize();
        maxAdd.setCount(maxInput);
        IItemHandler handler = this.getItemHandler();
        ItemStack currentStack = handler.getStackInSlot(this.index);
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handlerModifiable = (IItemHandlerModifiable)handler;
            handlerModifiable.setStackInSlot(this.index, ItemStack.EMPTY);
            ItemStack remainder = handlerModifiable.insertItem(this.index, maxAdd, true);
            handlerModifiable.setStackInSlot(this.index, currentStack);
            return maxInput - remainder.getCount();
        }
        ItemStack remainder = handler.insertItem(this.index, maxAdd, true);
        int current = currentStack.getCount();
        int added = maxInput - remainder.getCount();
        return current + added;
    }

    public boolean mayPickup(Player playerIn) {
        return !this.getItemHandler().extractItem(this.index, 1, true).isEmpty();
    }

    @NotNull
    public ItemStack remove(int amount) {
        return this.getItemHandler().extractItem(this.index, amount, false);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

