/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.ForgeRegistry;
import net.neoforged.neoforge.registries.IForgeRegistry;
import net.neoforged.neoforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;

public interface IFriendlyByteBufExtension {
    private FriendlyByteBuf self() {
        return (FriendlyByteBuf)this;
    }

    default public <T> void writeRegistryIdUnsafe(@NotNull IForgeRegistry<T> registry, @NotNull T entry) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = forgeRegistry.getID(entry);
        this.self().writeVarInt(id);
    }

    default public void writeRegistryIdUnsafe(@NotNull IForgeRegistry<?> registry, @NotNull ResourceLocation entryKey) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = forgeRegistry.getID(entryKey);
        this.self().writeVarInt(id);
    }

    default public <T> T readRegistryIdUnsafe(@NotNull IForgeRegistry<T> registry) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = this.self().readVarInt();
        return (T)forgeRegistry.getValue(id);
    }

    default public <T> void writeRegistryId(@NotNull IForgeRegistry<T> registry, @NotNull T entry) {
        Objects.requireNonNull(registry, "Cannot write a null registry key!");
        Objects.requireNonNull(entry, "Cannot write a null registry entry!");
        ResourceLocation name = registry.getRegistryName();
        Preconditions.checkArgument((boolean)registry.containsValue(entry), (String)"Cannot find %s in %s", registry.getKey(entry) != null ? registry.getKey(entry) : entry, (Object)name);
        ForgeRegistry reg = (ForgeRegistry)registry;
        this.self().writeResourceLocation(name);
        this.self().writeVarInt(reg.getID(entry));
    }

    default public <T> T readRegistryId() {
        ResourceLocation location = this.self().readResourceLocation();
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(location);
        return (T)registry.getValue(this.self().readVarInt());
    }

    default public <T> T readRegistryIdSafe(Class<? super T> registrySuperType) {
        T value = this.readRegistryId();
        if (!registrySuperType.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Attempted to read an registryValue of the wrong type from the Buffer!");
        }
        return value;
    }

    default public void writeFluidStack(FluidStack stack) {
        if (stack.isEmpty()) {
            this.self().writeBoolean(false);
        } else {
            this.self().writeBoolean(true);
            stack.writeToPacket(this.self());
        }
    }

    default public FluidStack readFluidStack() {
        return !this.self().readBoolean() ? FluidStack.EMPTY : FluidStack.readFromPacket(this.self());
    }
}

