/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import org.jetbrains.annotations.Nullable;

public interface IBlockGetterExtension {
    private BlockGetter self() {
        return (BlockGetter)this;
    }

    @Nullable
    default public BlockEntity getExistingBlockEntity(BlockPos pos) {
        IBlockGetterExtension iBlockGetterExtension = this;
        if (iBlockGetterExtension instanceof Level) {
            Level level = (Level)iBlockGetterExtension;
            if (!level.hasChunk(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()))) {
                return null;
            }
            return level.getChunk(pos).getExistingBlockEntity(pos);
        }
        iBlockGetterExtension = this;
        if (iBlockGetterExtension instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)iBlockGetterExtension;
            return (BlockEntity)chunk.getBlockEntities().get(pos);
        }
        iBlockGetterExtension = this;
        if (iBlockGetterExtension instanceof ImposterProtoChunk) {
            ImposterProtoChunk chunk = (ImposterProtoChunk)iBlockGetterExtension;
            return chunk.getWrapped().getExistingBlockEntity(pos);
        }
        return this.self().getBlockEntity(pos);
    }

    @Nullable
    default public ModelDataManager getModelDataManager() {
        return null;
    }
}

