/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import net.neoforged.neoforge.common.capabilities.ICapabilitySerializable;
import org.jetbrains.annotations.NotNull;

public interface IBlockEntityExtension
extends ICapabilitySerializable<CompoundTag> {
    public static final AABB INFINITE_EXTENT_AABB = new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    private BlockEntity self() {
        return (BlockEntity)this;
    }

    @Override
    default public void deserializeNBT(CompoundTag nbt) {
        this.self().load(nbt);
    }

    @Override
    default public CompoundTag serializeNBT() {
        return this.self().saveWithFullMetadata();
    }

    default public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compoundtag = pkt.getTag();
        if (compoundtag != null) {
            this.self().load(compoundtag);
        }
    }

    default public void handleUpdateTag(CompoundTag tag) {
        this.self().load(tag);
    }

    public CompoundTag getPersistentData();

    default public void onChunkUnloaded() {
    }

    default public void onLoad() {
        this.requestModelDataUpdate();
    }

    default public AABB getRenderBoundingBox() {
        AABB bb = INFINITE_EXTENT_AABB;
        BlockState state = this.self().getBlockState();
        Block block = state.getBlock();
        BlockPos pos = this.self().getBlockPos();
        if (block == Blocks.ENCHANTING_TABLE) {
            bb = new AABB(pos, pos.offset(1, 1, 1));
        } else if (block == Blocks.CHEST || block == Blocks.TRAPPED_CHEST) {
            bb = new AABB(pos.offset(-1, 0, -1), pos.offset(2, 2, 2));
        } else if (block == Blocks.STRUCTURE_BLOCK) {
            bb = INFINITE_EXTENT_AABB;
        } else if (block != null && block != Blocks.BEACON) {
            AABB cbb = null;
            try {
                VoxelShape collisionShape = state.getCollisionShape((BlockGetter)this.self().getLevel(), pos);
                if (!collisionShape.isEmpty()) {
                    cbb = collisionShape.bounds().move(pos);
                }
            }
            catch (Exception e) {
                cbb = new AABB(pos.offset(-1, 0, -1), pos.offset(1, 1, 1));
            }
            if (cbb != null) {
                bb = cbb;
            }
        }
        return bb;
    }

    default public void requestModelDataUpdate() {
        ModelDataManager modelDataManager;
        BlockEntity te = this.self();
        Level level = te.getLevel();
        if (level != null && level.isClientSide && (modelDataManager = level.getModelDataManager()) != null) {
            modelDataManager.requestRefresh(te);
        }
    }

    @NotNull
    default public ModelData getModelData() {
        return ModelData.EMPTY;
    }

    default public boolean hasCustomOutlineRendering(Player player) {
        return false;
    }
}

