/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data.internal;

import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeBlockTagsProvider
extends BlockTagsProvider {
    public NeoForgeBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "neoforge", existingFileHelper);
    }

    public void addTags(HolderLookup.Provider p_256380_) {
        this.tag(Tags.Blocks.BARRELS).addTag(Tags.Blocks.BARRELS_WOODEN);
        this.tag(Tags.Blocks.BARRELS_WOODEN).add((Object)Blocks.BARREL);
        this.tag(Tags.Blocks.BOOKSHELVES).add((Object)Blocks.BOOKSHELF);
        this.tag(Tags.Blocks.CHESTS).addTags(new TagKey[]{Tags.Blocks.CHESTS_ENDER, Tags.Blocks.CHESTS_TRAPPED, Tags.Blocks.CHESTS_WOODEN});
        this.tag(Tags.Blocks.CHESTS_ENDER).add((Object)Blocks.ENDER_CHEST);
        this.tag(Tags.Blocks.CHESTS_TRAPPED).add((Object)Blocks.TRAPPED_CHEST);
        this.tag(Tags.Blocks.CHESTS_WOODEN).add((Object[])new Block[]{Blocks.CHEST, Blocks.TRAPPED_CHEST});
        this.tag(Tags.Blocks.COBBLESTONE).addTags(new TagKey[]{Tags.Blocks.COBBLESTONE_NORMAL, Tags.Blocks.COBBLESTONE_INFESTED, Tags.Blocks.COBBLESTONE_MOSSY, Tags.Blocks.COBBLESTONE_DEEPSLATE});
        this.tag(Tags.Blocks.COBBLESTONE_NORMAL).add((Object)Blocks.COBBLESTONE);
        this.tag(Tags.Blocks.COBBLESTONE_INFESTED).add((Object)Blocks.INFESTED_COBBLESTONE);
        this.tag(Tags.Blocks.COBBLESTONE_MOSSY).add((Object)Blocks.MOSSY_COBBLESTONE);
        this.tag(Tags.Blocks.COBBLESTONE_DEEPSLATE).add((Object)Blocks.COBBLED_DEEPSLATE);
        this.tag(Tags.Blocks.END_STONES).add((Object)Blocks.END_STONE);
        this.tag(Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST);
        this.tag(Tags.Blocks.FENCE_GATES).addTags(new TagKey[]{Tags.Blocks.FENCE_GATES_WOODEN});
        this.tag(Tags.Blocks.FENCE_GATES_WOODEN).add((Object[])new Block[]{Blocks.OAK_FENCE_GATE, Blocks.SPRUCE_FENCE_GATE, Blocks.BIRCH_FENCE_GATE, Blocks.JUNGLE_FENCE_GATE, Blocks.ACACIA_FENCE_GATE, Blocks.DARK_OAK_FENCE_GATE, Blocks.CRIMSON_FENCE_GATE, Blocks.WARPED_FENCE_GATE, Blocks.MANGROVE_FENCE_GATE, Blocks.BAMBOO_FENCE_GATE, Blocks.CHERRY_FENCE_GATE});
        this.tag(Tags.Blocks.FENCES).addTags(new TagKey[]{Tags.Blocks.FENCES_NETHER_BRICK, Tags.Blocks.FENCES_WOODEN});
        this.tag(Tags.Blocks.FENCES_NETHER_BRICK).add((Object)Blocks.NETHER_BRICK_FENCE);
        this.tag(Tags.Blocks.FENCES_WOODEN).addTag(BlockTags.WOODEN_FENCES);
        this.tag(Tags.Blocks.GLASS).addTags(new TagKey[]{Tags.Blocks.GLASS_COLORLESS, Tags.Blocks.STAINED_GLASS, Tags.Blocks.GLASS_TINTED});
        this.tag(Tags.Blocks.GLASS_COLORLESS).add((Object)Blocks.GLASS);
        this.tag(Tags.Blocks.GLASS_SILICA).add((Object[])new Block[]{Blocks.GLASS, Blocks.BLACK_STAINED_GLASS, Blocks.BLUE_STAINED_GLASS, Blocks.BROWN_STAINED_GLASS, Blocks.CYAN_STAINED_GLASS, Blocks.GRAY_STAINED_GLASS, Blocks.GREEN_STAINED_GLASS, Blocks.LIGHT_BLUE_STAINED_GLASS, Blocks.LIGHT_GRAY_STAINED_GLASS, Blocks.LIME_STAINED_GLASS, Blocks.MAGENTA_STAINED_GLASS, Blocks.ORANGE_STAINED_GLASS, Blocks.PINK_STAINED_GLASS, Blocks.PURPLE_STAINED_GLASS, Blocks.RED_STAINED_GLASS, Blocks.WHITE_STAINED_GLASS, Blocks.YELLOW_STAINED_GLASS});
        this.tag(Tags.Blocks.GLASS_TINTED).add((Object)Blocks.TINTED_GLASS);
        this.addColored(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(Tags.Blocks.STAINED_GLASS)).add(arg_0), Tags.Blocks.GLASS, "{color}_stained_glass");
        this.tag(Tags.Blocks.GLASS_PANES).addTags(new TagKey[]{Tags.Blocks.GLASS_PANES_COLORLESS, Tags.Blocks.STAINED_GLASS_PANES});
        this.tag(Tags.Blocks.GLASS_PANES_COLORLESS).add((Object)Blocks.GLASS_PANE);
        this.addColored(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(Tags.Blocks.STAINED_GLASS_PANES)).add(arg_0), Tags.Blocks.GLASS_PANES, "{color}_stained_glass_pane");
        this.tag(Tags.Blocks.GRAVEL).add((Object)Blocks.GRAVEL);
        this.tag(Tags.Blocks.NETHERRACK).add((Object)Blocks.NETHERRACK);
        this.tag(Tags.Blocks.OBSIDIAN).add((Object)Blocks.OBSIDIAN);
        this.tag(Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE).add((Object)Blocks.DEEPSLATE);
        this.tag(Tags.Blocks.ORE_BEARING_GROUND_NETHERRACK).add((Object)Blocks.NETHERRACK);
        this.tag(Tags.Blocks.ORE_BEARING_GROUND_STONE).add((Object)Blocks.STONE);
        this.tag(Tags.Blocks.ORE_RATES_DENSE).add((Object[])new Block[]{Blocks.COPPER_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.DEEPSLATE_LAPIS_ORE, Blocks.DEEPSLATE_REDSTONE_ORE, Blocks.LAPIS_ORE, Blocks.REDSTONE_ORE});
        this.tag(Tags.Blocks.ORE_RATES_SINGULAR).add((Object[])new Block[]{Blocks.ANCIENT_DEBRIS, Blocks.COAL_ORE, Blocks.DEEPSLATE_COAL_ORE, Blocks.DEEPSLATE_DIAMOND_ORE, Blocks.DEEPSLATE_EMERALD_ORE, Blocks.DEEPSLATE_GOLD_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.DIAMOND_ORE, Blocks.EMERALD_ORE, Blocks.GOLD_ORE, Blocks.IRON_ORE, Blocks.NETHER_QUARTZ_ORE});
        this.tag(Tags.Blocks.ORE_RATES_SPARSE).add((Object)Blocks.NETHER_GOLD_ORE);
        this.tag(Tags.Blocks.ORES).addTags(new TagKey[]{Tags.Blocks.ORES_COAL, Tags.Blocks.ORES_COPPER, Tags.Blocks.ORES_DIAMOND, Tags.Blocks.ORES_EMERALD, Tags.Blocks.ORES_GOLD, Tags.Blocks.ORES_IRON, Tags.Blocks.ORES_LAPIS, Tags.Blocks.ORES_REDSTONE, Tags.Blocks.ORES_QUARTZ, Tags.Blocks.ORES_NETHERITE_SCRAP});
        this.tag(Tags.Blocks.ORES_COAL).addTag(BlockTags.COAL_ORES);
        this.tag(Tags.Blocks.ORES_COPPER).addTag(BlockTags.COPPER_ORES);
        this.tag(Tags.Blocks.ORES_DIAMOND).addTag(BlockTags.DIAMOND_ORES);
        this.tag(Tags.Blocks.ORES_EMERALD).addTag(BlockTags.EMERALD_ORES);
        this.tag(Tags.Blocks.ORES_GOLD).addTag(BlockTags.GOLD_ORES);
        this.tag(Tags.Blocks.ORES_IRON).addTag(BlockTags.IRON_ORES);
        this.tag(Tags.Blocks.ORES_LAPIS).addTag(BlockTags.LAPIS_ORES);
        this.tag(Tags.Blocks.ORES_QUARTZ).add((Object)Blocks.NETHER_QUARTZ_ORE);
        this.tag(Tags.Blocks.ORES_REDSTONE).addTag(BlockTags.REDSTONE_ORES);
        this.tag(Tags.Blocks.ORES_NETHERITE_SCRAP).add((Object)Blocks.ANCIENT_DEBRIS);
        this.tag(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE).add((Object[])new Block[]{Blocks.DEEPSLATE_COAL_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.DEEPSLATE_DIAMOND_ORE, Blocks.DEEPSLATE_EMERALD_ORE, Blocks.DEEPSLATE_GOLD_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.DEEPSLATE_LAPIS_ORE, Blocks.DEEPSLATE_REDSTONE_ORE});
        this.tag(Tags.Blocks.ORES_IN_GROUND_NETHERRACK).add((Object[])new Block[]{Blocks.NETHER_GOLD_ORE, Blocks.NETHER_QUARTZ_ORE});
        this.tag(Tags.Blocks.ORES_IN_GROUND_STONE).add((Object[])new Block[]{Blocks.COAL_ORE, Blocks.COPPER_ORE, Blocks.DIAMOND_ORE, Blocks.EMERALD_ORE, Blocks.GOLD_ORE, Blocks.IRON_ORE, Blocks.LAPIS_ORE, Blocks.REDSTONE_ORE});
        this.tag(Tags.Blocks.SAND).addTags(new TagKey[]{Tags.Blocks.SAND_COLORLESS, Tags.Blocks.SAND_RED});
        this.tag(Tags.Blocks.SAND_COLORLESS).add((Object)Blocks.SAND);
        this.tag(Tags.Blocks.SAND_RED).add((Object)Blocks.RED_SAND);
        this.tag(Tags.Blocks.SANDSTONE).add((Object[])new Block[]{Blocks.SANDSTONE, Blocks.CUT_SANDSTONE, Blocks.CHISELED_SANDSTONE, Blocks.SMOOTH_SANDSTONE, Blocks.RED_SANDSTONE, Blocks.CUT_RED_SANDSTONE, Blocks.CHISELED_RED_SANDSTONE, Blocks.SMOOTH_RED_SANDSTONE});
        this.tag(Tags.Blocks.STONE).add((Object[])new Block[]{Blocks.ANDESITE, Blocks.DIORITE, Blocks.GRANITE, Blocks.INFESTED_STONE, Blocks.STONE, Blocks.POLISHED_ANDESITE, Blocks.POLISHED_DIORITE, Blocks.POLISHED_GRANITE, Blocks.DEEPSLATE, Blocks.POLISHED_DEEPSLATE, Blocks.INFESTED_DEEPSLATE, Blocks.TUFF});
        this.tag(Tags.Blocks.STORAGE_BLOCKS).addTags(new TagKey[]{Tags.Blocks.STORAGE_BLOCKS_AMETHYST, Tags.Blocks.STORAGE_BLOCKS_COAL, Tags.Blocks.STORAGE_BLOCKS_COPPER, Tags.Blocks.STORAGE_BLOCKS_DIAMOND, Tags.Blocks.STORAGE_BLOCKS_EMERALD, Tags.Blocks.STORAGE_BLOCKS_GOLD, Tags.Blocks.STORAGE_BLOCKS_IRON, Tags.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER, Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD, Tags.Blocks.STORAGE_BLOCKS_RAW_IRON, Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Tags.Blocks.STORAGE_BLOCKS_NETHERITE});
        this.tag(Tags.Blocks.STORAGE_BLOCKS_AMETHYST).add((Object)Blocks.AMETHYST_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_COAL).add((Object)Blocks.COAL_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_COPPER).add((Object)Blocks.COPPER_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_DIAMOND).add((Object)Blocks.DIAMOND_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_EMERALD).add((Object)Blocks.EMERALD_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_GOLD).add((Object)Blocks.GOLD_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_IRON).add((Object)Blocks.IRON_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_LAPIS).add((Object)Blocks.LAPIS_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_QUARTZ).add((Object)Blocks.QUARTZ_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER).add((Object)Blocks.RAW_COPPER_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD).add((Object)Blocks.RAW_GOLD_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_RAW_IRON).add((Object)Blocks.RAW_IRON_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_REDSTONE).add((Object)Blocks.REDSTONE_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_NETHERITE).add((Object)Blocks.NETHERITE_BLOCK);
    }

    private void addColored(Consumer<Block> consumer, TagKey<Block> group, String pattern) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation key = new ResourceLocation("minecraft", pattern.replace("{color}", color.getName()));
            TagKey<Block> tag = this.getForgeTag(prefix + color.getName());
            Block block = ForgeRegistries.BLOCKS.getValue(key);
            if (block == null || block == Blocks.AIR) {
                throw new IllegalStateException("Unknown vanilla block: " + key.toString());
            }
            this.tag(tag).add((Object)block);
            consumer.accept(block);
        }
    }

    private TagKey<Block> getForgeTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (TagKey)Tags.Blocks.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Blocks.class.getName() + " is missing tag name: " + name);
        }
    }
}

