/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.registries.ForgeRegistries;

public class PartialNBTIngredient
extends Ingredient {
    public static final Codec<PartialNBTIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.singularOrPluralCodec(ForgeRegistries.ITEMS.getCodec(), "item").forGetter(PartialNBTIngredient::getContainedItems), (App)CompoundTag.CODEC.fieldOf("tag").forGetter(PartialNBTIngredient::getTag)).apply((Applicative)builder, PartialNBTIngredient::new));
    public static final Codec<PartialNBTIngredient> CODEC_NONEMPTY = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.singularOrPluralCodecNotEmpty(ForgeRegistries.ITEMS.getCodec(), "item").forGetter(PartialNBTIngredient::getContainedItems), (App)CompoundTag.CODEC.fieldOf("tag").forGetter(PartialNBTIngredient::getTag)).apply((Applicative)builder, PartialNBTIngredient::new));

    protected PartialNBTIngredient(Set<Item> items, CompoundTag tag) {
        super(items.stream().map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item, 1);
            stack.setTag(tag.copy());
            return new Ingredient.ItemValue(stack, PartialNBTIngredient::compareStacksUsingPredicate);
        }), NeoForgeMod.PARTIAL_NBT_INGREDIENT_TYPE::get);
        if (items.isEmpty()) {
            throw new IllegalStateException("At least one item needs to be provided for a partial nbt matching ingredient.");
        }
    }

    protected boolean areStacksEqual(ItemStack left, ItemStack right) {
        return PartialNBTIngredient.compareStacksUsingPredicate(left, right);
    }

    public boolean synchronizeWithContents() {
        return false;
    }

    private static boolean compareStacksUsingPredicate(ItemStack left, ItemStack right) {
        NbtPredicate predicate = new NbtPredicate(left.getOrCreateTag());
        return left.getItem() == right.getItem() && predicate.matches(right);
    }

    public static PartialNBTIngredient of(CompoundTag nbt, ItemLike ... items) {
        return new PartialNBTIngredient(Arrays.stream(items).map(ItemLike::asItem).collect(Collectors.toSet()), nbt);
    }

    public static PartialNBTIngredient of(ItemLike item, CompoundTag nbt) {
        return new PartialNBTIngredient(Set.of(item.asItem()), nbt);
    }

    public Set<Item> getContainedItems() {
        return Arrays.stream(this.getItems()).map(ItemStack::getItem).collect(Collectors.toSet());
    }

    public CompoundTag getTag() {
        ItemStack[] items = this.getItems();
        if (items.length == 0) {
            return new CompoundTag();
        }
        return items[0].getOrCreateTag();
    }

    public boolean isSimple() {
        return false;
    }
}

