/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.conditions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.apache.commons.lang3.Validate;

public record WithConditions<A>(List<ICondition> conditions, A carrier) {

    public static class Builder<T> {
        private final List<ICondition> conditions = new ArrayList<ICondition>();
        private T carrier;

        public Builder<T> addCondition(ICondition ... condition) {
            this.conditions.addAll(List.of(condition));
            return this;
        }

        public Builder<T> addCondition(Collection<ICondition> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        public Builder<T> withCarrier(T carrier) {
            this.carrier = carrier;
            return this;
        }

        public WithConditions<T> build() {
            Validate.notNull(this.carrier, (String)"You need to supply a carrier to create a WithConditions", (Object[])new Object[0]);
            Validate.notEmpty(this.conditions, (String)"You need to supply at least one condition to create a WithConditions", (Object[])new Object[0]);
            return new WithConditions<T>(this.conditions, this.carrier);
        }
    }
}

