/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Unit;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.registries.ForgeRegistries;

public interface ICondition {
    public static final Codec<ICondition> CODEC = NeoForgeExtraCodecs.dispatchUnsafe(ExtraCodecs.lazyInitializedCodec(() -> ForgeRegistries.CONDITION_SERIALIZERS.get().getCodec()), ICondition::codec, Function.identity());
    public static final Codec<List<ICondition>> LIST_CODEC = CODEC.listOf();

    public static <V, T> Optional<T> getConditionally(Codec<T> codec, DynamicOps<V> ops, V element) {
        return ICondition.getWithConditionalCodec(ConditionalOps.createConditionalCodec(codec).codec(), ops, element);
    }

    public static <V, T> Optional<T> getWithConditionalCodec(Codec<Optional<T>> codec, DynamicOps<V> ops, V element) {
        return (Optional)Util.getOrThrow((DataResult)codec.parse(ops, element).promotePartial(m -> {}), JsonParseException::new);
    }

    public static <V> boolean conditionsMatched(DynamicOps<V> ops, V element) {
        Codec codec = Codec.unit((Object)Unit.INSTANCE);
        return ICondition.getConditionally(codec, ops, element).isPresent();
    }

    public static void writeConditions(HolderLookup.Provider registries, JsonObject jsonObject, String conditionalsKey, ICondition ... conditions) {
        ICondition.writeConditions(registries, jsonObject, conditionalsKey, List.of(conditions));
    }

    public static void writeConditions(HolderLookup.Provider registries, JsonObject jsonObject, String conditionalsKey, List<ICondition> conditions) {
        ICondition.writeConditions((DynamicOps<JsonElement>)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registries), jsonObject, conditionalsKey, conditions);
    }

    public static void writeConditions(DynamicOps<JsonElement> jsonOps, JsonObject jsonObject, String conditionalsKey, List<ICondition> conditions) {
        if (!conditions.isEmpty()) {
            DataResult result = LIST_CODEC.encodeStart(jsonOps, conditions);
            JsonElement serializedConditions = (JsonElement)result.result().orElseThrow(() -> new RuntimeException("Failed to serialize conditions"));
            jsonObject.add(conditionalsKey, serializedConditions);
        }
    }

    public boolean test(IContext var1);

    public Codec<? extends ICondition> codec();

    public static interface IContext {
        public static final IContext EMPTY = new IContext(){

            @Override
            public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> registry) {
                return Collections.emptyMap();
            }
        };
        public static final IContext TAGS_INVALID = new IContext(){

            @Override
            public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> registry) {
                throw new UnsupportedOperationException("Usage of tag-based conditions is not permitted in this context!");
            }
        };

        default public <T> Collection<Holder<T>> getTag(TagKey<T> key) {
            return this.getAllTags(key.registry()).getOrDefault(key.location(), Set.of());
        }

        public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> var1);
    }
}

