/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.conditions;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.stream.Stream;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public class ConditionalOps<T>
extends RegistryOps<T> {
    private final ICondition.IContext context;

    public static <T> ConditionalOps<T> create(RegistryOps<T> ops, ICondition.IContext context) {
        return new ConditionalOps<T>(ops, context);
    }

    private ConditionalOps(RegistryOps<T> ops, ICondition.IContext context) {
        super(ops);
        this.context = context;
    }

    public static MapCodec<ICondition.IContext> retrieveContext() {
        return ExtraCodecs.retrieveContext(ops -> {
            if (!(ops instanceof ConditionalOps)) {
                return DataResult.success((Object)ICondition.IContext.EMPTY);
            }
            ConditionalOps conditionalOps = (ConditionalOps)((Object)ops);
            return DataResult.success((Object)conditionalOps.context);
        });
    }

    public static <T> MapCodec<Optional<T>> createConditionalCodec(Codec<T> ownerCodec) {
        return ConditionalOps.createConditionalCodec(ownerCodec, "conditions");
    }

    public static <T> MapCodec<Optional<T>> createConditionalCodec(Codec<T> ownerCodec, String conditionalsKey) {
        return ConditionalOps.createConditionalCodecWithConditions(ownerCodec, conditionalsKey).xmap(r -> r.map(WithConditions::carrier), r -> r.map(i -> new WithConditions<Object>(List.of(), i)));
    }

    public static <T> Codec<List<T>> decodeListWithElementConditions(Codec<T> ownerCodec, String conditionalsKey) {
        Codec delegate = ownerCodec.listOf();
        Decoder<List<T>> decoder = NeoForgeExtraCodecs.listDecoderWithOptionalElements(ConditionalOps.createConditionalDecoder(ownerCodec, conditionalsKey));
        return Codec.of((Encoder)delegate, decoder);
    }

    public static <T> Codec<List<T>> decodeListWithElementConditionsAndConsumeIndex(Codec<T> ownerCodec, String conditionalsKey, ObjIntConsumer<T> consumer) {
        Codec list = ownerCodec.listOf();
        return Codec.of((Encoder)list, NeoForgeExtraCodecs.listOptionalUnwrapDecoder(NeoForgeExtraCodecs.listDecoderWithIndexConsumer(NeoForgeExtraCodecs.listDecoder(ConditionalOps.createConditionalDecoder(ownerCodec, conditionalsKey)), (op, i) -> op.ifPresent(o -> consumer.accept(o, i))), Function.identity()));
    }

    public static <T> Decoder<Optional<T>> createConditionalDecoder(Decoder<T> ownerCodec) {
        return ConditionalOps.createConditionalDecoder(ownerCodec, "conditions");
    }

    public static <T> Decoder<Optional<T>> createConditionalDecoder(Decoder<T> ownerCodec, String conditionalsKey) {
        return new ConditionalDecoder<T>(conditionalsKey, ICondition.LIST_CODEC, (Codec<ICondition.IContext>)ConditionalOps.retrieveContext().codec(), ownerCodec).map(o -> o.map(WithConditions::carrier));
    }

    public static <T> MapCodec<Optional<WithConditions<T>>> createConditionalCodecWithConditions(Codec<T> ownerCodec) {
        return ConditionalOps.createConditionalCodecWithConditions(ownerCodec, "conditions");
    }

    public static <T> MapCodec<Optional<WithConditions<T>>> createConditionalCodecWithConditions(Codec<T> ownerCodec, String conditionalsKey) {
        return new ConditionalCodec<T>(conditionalsKey, ICondition.LIST_CODEC, (Codec<ICondition.IContext>)ConditionalOps.retrieveContext().codec(), ownerCodec);
    }

    private static final class ConditionalDecoder<A>
    implements Decoder<Optional<WithConditions<A>>> {
        private final String conditionalsPropertyKey;
        public final Codec<List<ICondition>> conditionsCodec;
        private final Codec<ICondition.IContext> contextCodec;
        private final Decoder<A> innerCodec;
        private final String valuePropertyKey = "value";

        private ConditionalDecoder(String conditionalsPropertyKey, Codec<List<ICondition>> conditionsCodec, Codec<ICondition.IContext> contextCodec, Decoder<A> innerCodec) {
            this.conditionalsPropertyKey = conditionalsPropertyKey;
            this.conditionsCodec = conditionsCodec;
            this.contextCodec = contextCodec;
            this.innerCodec = innerCodec;
        }

        public <T> DataResult<Pair<Optional<WithConditions<A>>, T>> decode(DynamicOps<T> ops, T input) {
            DataResult conditionsDataCarrierResult = ops.get(input, this.conditionalsPropertyKey);
            if (conditionsDataCarrierResult.error().isPresent()) {
                return this.decodeInner(ops, input).map(result -> result.map(carrier -> new WithConditions<Object>(List.of(), carrier))).map(v -> Pair.of((Object)v, (Object)input));
            }
            return conditionsDataCarrierResult.flatMap(conditionsDataCarrier -> this.conditionsCodec.decode(ops, conditionsDataCarrier).flatMap(conditionsCarrier -> {
                List conditions = (List)conditionsCarrier.getFirst();
                DataResult contextDataResult = this.contextCodec.decode(ops, ops.emptyMap());
                return contextDataResult.flatMap(contextCarrier -> {
                    ICondition.IContext context = (ICondition.IContext)contextCarrier.getFirst();
                    boolean conditionsMatch = conditions.stream().allMatch(c -> c.test(context));
                    if (!conditionsMatch) {
                        return DataResult.error(() -> "Conditions did not match", Optional.empty());
                    }
                    return this.decodeInner(ops, input).map(result -> result.map(carrier -> new WithConditions<Object>(conditions, carrier)));
                });
            })).map(v -> Pair.of((Object)v, (Object)input));
        }

        private <T> DataResult<Optional<A>> decodeInner(DynamicOps<T> ops, T input) {
            if (ops.compressMaps()) {
                DataResult valueResult = ops.get(input, "value");
                if (valueResult.error().map(DataResult.PartialResult::message).isPresent()) {
                    return DataResult.error(() -> "Input does not have a \"value\" entry: " + input);
                }
                return valueResult.flatMap(value -> this.innerCodec.parse(ops, value).map(Optional::of));
            }
            Decoder<A> decoder = this.innerCodec;
            if (decoder instanceof MapCodec.MapCodecCodec) {
                MapCodec.MapCodecCodec mapCodec = (MapCodec.MapCodecCodec)decoder;
                return mapCodec.decode(ops, input).map(Pair::getFirst).map(Optional::of);
            }
            DataResult valueDataCarrierResult = ops.get(input, "value");
            if (valueDataCarrierResult.error().isPresent()) {
                return this.innerCodec.decode(ops, input).map(Pair::getFirst).map(Optional::of);
            }
            return valueDataCarrierResult.flatMap(valueDataCarrier -> this.innerCodec.decode(ops, valueDataCarrier).map(Pair::getFirst).map(Optional::of));
        }

        public String toString() {
            return "Conditional[inner=" + this.innerCodec + ", conditionalsKey=" + this.conditionalsPropertyKey + "]";
        }
    }

    private static final class ConditionalCodec<A>
    extends MapCodec<Optional<WithConditions<A>>> {
        private final String conditionalsPropertyKey;
        public final Codec<List<ICondition>> conditionsCodec;
        private final Codec<ICondition.IContext> contextCodec;
        private final Codec<A> innerCodec;
        private final String valuePropertyKey = "value";

        private ConditionalCodec(String conditionalsPropertyKey, Codec<List<ICondition>> conditionsCodec, Codec<ICondition.IContext> contextCodec, Codec<A> innerCodec) {
            this.conditionalsPropertyKey = conditionalsPropertyKey;
            this.conditionsCodec = conditionsCodec;
            this.contextCodec = contextCodec;
            this.innerCodec = innerCodec;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(this.conditionalsPropertyKey, "value").map(arg_0 -> ops.createString(arg_0));
        }

        public <T> DataResult<Optional<WithConditions<A>>> decode(DynamicOps<T> ops, MapLike<T> input) {
            Object conditionsDataCarrier = input.get(this.conditionalsPropertyKey);
            if (conditionsDataCarrier == null) {
                return this.decodeInner(ops, input).map(result -> result.map(carrier -> new WithConditions<Object>(List.of(), carrier)));
            }
            return this.conditionsCodec.decode(ops, conditionsDataCarrier).flatMap(conditionsCarrier -> {
                List conditions = (List)conditionsCarrier.getFirst();
                DataResult contextDataResult = this.contextCodec.decode(ops, ops.emptyMap());
                return contextDataResult.flatMap(contextCarrier -> {
                    ICondition.IContext context = (ICondition.IContext)contextCarrier.getFirst();
                    boolean conditionsMatch = conditions.stream().allMatch(c -> c.test(context));
                    if (!conditionsMatch) {
                        return DataResult.error(() -> "Conditions did not match", Optional.empty());
                    }
                    return this.decodeInner(ops, input).map(result -> result.map(carrier -> new WithConditions<Object>(conditions, carrier)));
                });
            });
        }

        private <T> DataResult<Optional<A>> decodeInner(DynamicOps<T> ops, MapLike<T> input) {
            if (ops.compressMaps()) {
                Object value = input.get(ops.createString("value"));
                if (value == null) {
                    return DataResult.error(() -> "Input does not have a \"value\" entry: " + input);
                }
                return this.innerCodec.parse(ops, value).map(Optional::of);
            }
            if (this.innerCodec instanceof MapCodec.MapCodecCodec) {
                return ((MapCodec.MapCodecCodec)this.innerCodec).codec().decode(ops, input).map(Optional::of);
            }
            return this.innerCodec.decode(ops, input.get("value")).map(Pair::getFirst).map(Optional::of);
        }

        public <T> RecordBuilder<T> encode(Optional<WithConditions<A>> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            if (input.isEmpty()) {
                return prefix;
            }
            WithConditions<A> withConditions = input.get();
            if (ops.compressMaps()) {
                if (!withConditions.conditions().isEmpty()) {
                    prefix.add(this.conditionalsPropertyKey, this.conditionsCodec.encodeStart(ops, withConditions.conditions()));
                }
                return prefix.add("value", this.innerCodec.encodeStart(ops, withConditions.carrier()));
            }
            if (this.innerCodec instanceof MapCodec.MapCodecCodec) {
                RecordBuilder prefixWithInner = ((MapCodec.MapCodecCodec)this.innerCodec).codec().encode(withConditions.carrier(), ops, prefix);
                if (!withConditions.conditions().isEmpty()) {
                    return prefixWithInner.add(this.conditionalsPropertyKey, this.conditionsCodec.encodeStart(ops, withConditions.conditions()));
                }
                return prefixWithInner;
            }
            DataResult result = this.innerCodec.encodeStart(ops, withConditions.carrier());
            if (!withConditions.conditions().isEmpty()) {
                prefix.add(this.conditionalsPropertyKey, this.conditionsCodec.encodeStart(ops, withConditions.conditions()));
            }
            prefix.add("value", result);
            return prefix;
        }
    }
}

