/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.loading;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.DataPackConfig;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.LoadingFailedException;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.ModLoadingWarning;
import net.neoforged.fml.ModWorkManager;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import net.neoforged.neoforge.client.gui.LoadingErrorScreen;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeConfig;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.internal.BrandingControl;
import net.neoforged.neoforge.logging.CrashReportExtender;
import net.neoforged.neoforge.resource.DelegatingPackResources;
import net.neoforged.neoforge.resource.PathPackResources;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforge.server.LanguageHook;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean loading;
    private static Minecraft mc;
    private static boolean loadingComplete;
    private static LoadingFailedException error;

    public static void begin(Minecraft minecraft, PackRepository defaultResourcePacks, ReloadableResourceManager mcResourceManager) {
        Runtime.getRuntime().addShutdownHook(new Thread(LogManager::shutdown));
        ImmediateWindowHandler.updateProgress((String)"Loading mods");
        loading = true;
        mc = minecraft;
        LogicalSidedProvider.setClient(() -> minecraft);
        LanguageHook.loadForgeAndMCLangs();
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().gatherAndInitializeMods(ModWorkManager.syncExecutor(), ModWorkManager.parallelExecutor(), ImmediateWindowHandler::renderTick)).run();
        if (error == null) {
            ResourcePackLoader.loadResourcePacks(defaultResourcePacks, ClientModLoader::buildPackFinder);
            ModLoader.get().postEvent((Event)new AddPackFindersEvent(PackType.CLIENT_RESOURCES, arg_0 -> ((PackRepository)defaultResourcePacks).addPackFinder(arg_0)));
            DataPackConfig.DEFAULT.addModPacks(ResourcePackLoader.getPackNames());
            mcResourceManager.registerReloadListener(ClientModLoader::onResourceReload);
            mcResourceManager.registerReloadListener((PreparableReloadListener)BrandingControl.resourceManagerReloadListener());
        }
    }

    private static CompletableFuture<Void> onResourceReload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller prepareProfiler, ProfilerFiller executeProfiler, Executor asyncExecutor, Executor syncExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(ClientModLoader.createRunnableWithCatch(() -> ClientModLoader.startModLoading(ModWorkManager.wrappedExecutor((Executor)syncExecutor), asyncExecutor)), ModWorkManager.parallelExecutor()).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenRunAsync(() -> ClientModLoader.finishModLoading(ModWorkManager.wrappedExecutor((Executor)syncExecutor), asyncExecutor), ModWorkManager.parallelExecutor());
    }

    private static Runnable createRunnableWithCatch(Runnable r) {
        return () -> {
            block3: {
                if (loadingComplete) {
                    return;
                }
                try {
                    r.run();
                }
                catch (LoadingFailedException e) {
                    if (error != null) break block3;
                    error = e;
                }
            }
        };
    }

    private static void startModLoading(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor) {
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().loadMods(syncExecutor, parallelExecutor, ImmediateWindowHandler::renderTick)).run();
    }

    private static void finishModLoading(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor) {
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().finishMods(syncExecutor, parallelExecutor, ImmediateWindowHandler::renderTick)).run();
        loading = false;
        loadingComplete = true;
        syncExecutor.execute(() -> ClientModLoader.mc.options.load(true));
    }

    public static VersionChecker.Status checkForUpdates() {
        boolean anyOutdated = ModList.get().getMods().stream().map(VersionChecker::getResult).map(result -> result.status()).anyMatch(status -> status == VersionChecker.Status.OUTDATED || status == VersionChecker.Status.BETA_OUTDATED);
        return anyOutdated ? VersionChecker.Status.OUTDATED : null;
    }

    public static boolean completeModLoading() {
        List<ModLoadingWarning> warnings = ModLoader.get().getWarnings();
        boolean showWarnings = true;
        try {
            showWarnings = (Boolean)NeoForgeConfig.CLIENT.showLoadWarnings.get();
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (!showWarnings) {
            if (!warnings.isEmpty()) {
                LOGGER.warn(Logging.LOADING, "Mods loaded with {} warning(s)", (Object)warnings.size());
                warnings.forEach(warning -> LOGGER.warn(Logging.LOADING, warning.formatToString()));
            }
            warnings = Collections.emptyList();
        }
        File dumpedLocation = null;
        if (error == null) {
            NeoForge.EVENT_BUS.start();
        } else {
            LanguageHook.loadForgeAndMCLangs();
            dumpedLocation = CrashReportExtender.dumpModLoadingCrashReport(LOGGER, error, ClientModLoader.mc.gameDirectory);
        }
        if (error != null || !warnings.isEmpty()) {
            mc.setScreen((Screen)new LoadingErrorScreen(error, warnings, dumpedLocation));
            return true;
        }
        return false;
    }

    public static boolean isLoading() {
        return loading;
    }

    private static RepositorySource buildPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks) {
        return packAcceptor -> ClientModLoader.clientPackFinder(modResourcePacks, packAcceptor);
    }

    private static void clientPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks, Consumer<Pack> packAcceptor) {
        ArrayList<PathPackResources> hiddenPacks = new ArrayList<PathPackResources>();
        for (Map.Entry<IModFile, ? extends PathPackResources> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            String name = "mod:" + mod.getModId();
            Pack modPack = Pack.readMetaAndCreate((String)name, (Component)Component.literal((String)e.getValue().packId()), (boolean)false, (Pack.ResourcesSupplier)BuiltInPackSource.fixedResources((PackResources)((PackResources)e.getValue())), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.DEFAULT);
            if (modPack == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{e.getKey()}));
                continue;
            }
            LOGGER.debug(Logging.CORE, "Generating PackInfo named {} for mod file {}", (Object)name, (Object)e.getKey().getFilePath());
            if (mod.getOwningFile().showAsResourcePack()) {
                packAcceptor.accept(modPack);
                continue;
            }
            hiddenPacks.add(e.getValue());
        }
        Pack modResourcesPack = Pack.readMetaAndCreate((String)"mod_resources", (Component)Component.literal((String)"Mod Resources"), (boolean)true, (Pack.ResourcesSupplier)BuiltInPackSource.fromName(id -> new DelegatingPackResources((String)id, false, new PackMetadataSection((Component)Component.translatable((String)"fml.resources.modresources", (Object[])new Object[]{hiddenPacks.size()}), SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES)), (List<? extends PackResources>)hiddenPacks)), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.DEFAULT);
        packAcceptor.accept(modResourcesPack);
    }
}

