/*
 * Copyright (c) Forge Development LLC and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package net.neoforged.neoforge.common.capabilities;

import net.neoforged.fml.common.asm.CapabilityTokenSubclass;

/**
 * Inspired by {@link com.google.common.reflect.TypeToken TypeToken}, use a subclass to capture
 * generic types. Then uses {@link CapabilityTokenSubclass a transformer}
 * to convert that generic into a string returned by {@link #getType}
 * This allows us to know the generic type, without having a hard reference to the
 * class.
 *
 * Example usage:
 * 
 * <pre>{@code
 * public static Capability<IDataHolder> DATA_HOLDER_CAPABILITY = CapabilityManager.get(new CapabilityToken<>() {});
 * }</pre>
 *
 */
public abstract class CapabilityToken<T> {
    protected final String getType() {
        throw new RuntimeException("This will be implemented by a transformer");
    }

    @Override
    public String toString() {
        return "CapabilityToken[" + getType() + "]";
    }
}
